/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.client.wizard;

import java.awt.Component;
import java.io.IOException;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.websvc.api.support.ClientCreator;
import org.netbeans.modules.websvc.api.support.LogUtils;
import org.netbeans.modules.websvc.core.CreatorProvider;
import org.netbeans.modules.websvc.core.JaxWsUtils;
import org.netbeans.modules.websvc.core.client.wizard.WebServiceClientWizardDescriptor;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.NbBundle;

public class WebServiceClientWizardIterator
implements TemplateWizard.Iterator {
    private int index = 0;
    private WizardDescriptor.Panel<WizardDescriptor>[] panels;
    private TemplateWizard wiz;
    private Project project;

    public static WebServiceClientWizardIterator create() {
        return new WebServiceClientWizardIterator();
    }

    private WizardDescriptor.Panel[] createPanels() {
        return new WizardDescriptor.Panel[]{new WebServiceClientWizardDescriptor()};
    }

    public void initialize(TemplateWizard wizard) {
        this.wiz = wizard;
        this.project = Templates.getProject((WizardDescriptor)this.wiz);
        this.index = 0;
        this.panels = this.createPanels();
        Object prop = this.wiz.getProperty("WizardPanel_contentData");
        String[] beforeSteps = null;
        if (prop != null && prop instanceof String[]) {
            beforeSteps = (String[])prop;
        }
        String[] steps = JaxWsUtils.createSteps(beforeSteps, this.panels);
        for (int i = 0; i < this.panels.length; ++i) {
            Component c = this.panels[i].getComponent();
            if (steps[i] == null) {
                steps[i] = c.getName();
            }
            assert (c instanceof JComponent);
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
    }

    public void uninitialize(TemplateWizard wizard) {
        this.wiz = null;
        this.panels = null;
    }

    public Set<DataObject> instantiate(TemplateWizard wiz) throws IOException {
        FileObject template = Templates.getTemplate((WizardDescriptor)wiz);
        DataObject dTemplate = DataObject.find((FileObject)template);
        ClientCreator creator = CreatorProvider.getClientCreator(this.project, (WizardDescriptor)wiz);
        if (creator != null) {
            creator.createClient();
        }
        Object[] params = new Object[5];
        boolean isJaxWs = "JAX-WS Style".equals(wiz.getProperty("jaxVersion"));
        params[0] = isJaxWs ? "JAX-WS" : "JAX-RPC";
        params[1] = this.project.getClass().getName();
        J2eeModule j2eeModule = JaxWsUtils.getJ2eeModule(this.project);
        params[2] = j2eeModule == null ? "J2SE" : j2eeModule.getModuleVersion() + "(" + JaxWsUtils.getModuleType(this.project) + ")";
        params[3] = (Boolean)wiz.getProperty("useDispatch") != false ? "DISPATCH" : "WS CLIENTL";
        int wsdlSource = (Integer)wiz.getProperty("wsdlSource");
        switch (wsdlSource) {
            case 0: {
                params[4] = "FROM PROJECT";
                break;
            }
            case 1: {
                params[4] = "FROM FILE";
                break;
            }
            case 3: {
                params[4] = "FROM SAAS WSDL";
                break;
            }
            default: {
                params[4] = "FROM URL";
            }
        }
        LogUtils.logWsWizard((Object[])params);
        return Collections.singleton(dTemplate);
    }

    public String name() {
        return NbBundle.getMessage(WebServiceClientWizardIterator.class, (String)"LBL_WebServiceClient");
    }

    public WizardDescriptor.Panel<WizardDescriptor> current() {
        return this.panels[this.index];
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void previousPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void removeChangeListener(ChangeListener l) {
    }
}

