/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.jdktools;

import eu.hansolo.jdktools.Api;
import eu.hansolo.jdktools.util.OutputFormat;
import java.util.Arrays;
import java.util.List;

public enum ArchiveType implements Api
{
    APK("apk", "apk", ".apk"),
    BIN("bin", "bin", ".bin"),
    CAB("cab", "cab", ".cab"),
    DEB("deb", "deb", ".deb"),
    DMG("dmg", "dmg", ".dmg"),
    MSI("msi", "msi", ".msi"),
    PKG("pkg", "pkg", ".pkg"),
    RPM("rpm", "rpm", ".rpm"),
    SRC_TAR("src.tar.gz", "src_tar", ".src.tar.gz", ".source.tar.gz", ".source.tar.gz"),
    TAR("tar", "tar", ".tar"),
    TAR_GZ("tar.gz", "tar.gz", ".tar.gz"),
    TGZ("tgz", "tgz", ".tgz"),
    TAR_Z("tar.Z", "tar.z", ".tar.Z"),
    ZIP("zip", "zip", ".zip"),
    EXE("exe", "exe", ".exe"),
    NONE("-", "", "-"),
    NOT_FOUND("", "", "");

    private final String uiString;
    private final String apiString;
    private final List<String> fileEndings;

    private ArchiveType(String uiString, String apiString, String ... fileEndings) {
        this.uiString = uiString;
        this.apiString = apiString;
        this.fileEndings = List.of(fileEndings);
    }

    @Override
    public String getUiString() {
        return this.uiString;
    }

    @Override
    public String getApiString() {
        return this.apiString;
    }

    @Override
    public ArchiveType getDefault() {
        return NONE;
    }

    @Override
    public ArchiveType getNotFound() {
        return NOT_FOUND;
    }

    public ArchiveType[] getAll() {
        return ArchiveType.values();
    }

    @Override
    public String toString(OutputFormat outputFormat) {
        StringBuilder msgBuilder = new StringBuilder();
        switch (outputFormat) {
            case FULL: 
            case REDUCED: 
            case REDUCED_ENRICHED: {
                msgBuilder.append("{").append("\n").append("  \"").append("name").append("\"").append(":").append("\"").append(this.name()).append("\"").append(",\n").append("  \"").append("ui_string").append("\"").append(":").append("\"").append(this.uiString).append("\"").append(",\n").append("  \"").append("api_string").append("\"").append(":").append("\"").append(this.apiString).append("\"").append("\n").append("}");
                break;
            }
            default: {
                msgBuilder.append("{").append("\"").append("name").append("\"").append(":").append("\"").append(this.name()).append("\"").append(",").append("\"").append("ui_string").append("\"").append(":").append("\"").append(this.uiString).append("\"").append(",").append("\"").append("api_string").append("\"").append(":").append("\"").append(this.apiString).append("\"").append("}");
            }
        }
        return msgBuilder.toString();
    }

    public String toString() {
        return this.toString(OutputFormat.FULL_COMPRESSED);
    }

    public static ArchiveType fromText(String text) {
        if (null == text) {
            return NOT_FOUND;
        }
        switch (text) {
            case "apk": 
            case ".apk": 
            case "APK": {
                return APK;
            }
            case "bin": 
            case ".bin": 
            case "BIN": {
                return BIN;
            }
            case "cab": 
            case ".cab": 
            case "CAB": {
                return CAB;
            }
            case "deb": 
            case ".deb": 
            case "DEB": {
                return DEB;
            }
            case "dmg": 
            case ".dmg": 
            case "DMG": {
                return DMG;
            }
            case "exe": 
            case ".exe": 
            case "EXE": {
                return EXE;
            }
            case "msi": 
            case ".msi": 
            case "MSI": {
                return MSI;
            }
            case "pkg": 
            case ".pkg": 
            case "PKG": {
                return PKG;
            }
            case "rpm": 
            case ".rpm": 
            case "RPM": {
                return RPM;
            }
            case "src.tar.gz": 
            case ".src.tar.gz": 
            case "source.tar.gz": 
            case "SRC.TAR.GZ": 
            case "src_tar": 
            case "SRC_TAR": {
                return SRC_TAR;
            }
            case "tar.Z": 
            case ".tar.Z": 
            case "TAR.Z": 
            case "tar.z": {
                return TAR_Z;
            }
            case "tar.gz": 
            case ".tar.gz": 
            case "TAR.GZ": {
                return TAR_GZ;
            }
            case "tgz": 
            case ".tgz": 
            case "TGZ": {
                return TGZ;
            }
            case "tar": 
            case ".tar": 
            case "TAR": {
                return TAR;
            }
            case "zip": 
            case ".zip": 
            case "ZIP": {
                return ZIP;
            }
        }
        return NOT_FOUND;
    }

    public List<String> getFileEndings() {
        return this.fileEndings;
    }

    public static ArchiveType getFromFileName(String filename) {
        if (null == filename || filename.isEmpty()) {
            return NONE;
        }
        for (ArchiveType archiveType : ArchiveType.values()) {
            for (String ending : archiveType.getFileEndings()) {
                if (!filename.toLowerCase().endsWith(ending)) continue;
                return archiveType;
            }
        }
        return NONE;
    }

    public static List<ArchiveType> getAsList() {
        return Arrays.asList(ArchiveType.values());
    }
}

