/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutdesign;

import java.awt.Rectangle;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.form.FormDataObject;
import org.netbeans.modules.form.FormDesigner;
import org.netbeans.modules.form.layoutdesign.LayoutConstants;
import org.netbeans.modules.form.layoutdesign.LayoutModel;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;

public class LayoutTestUtils
implements LayoutConstants {
    static void writeString(List<String> codeList, String name, String value) {
        if (value != null) {
            codeList.add("String " + name + "= \"" + value + "\";");
        } else {
            codeList.add("String " + name + " = null;");
        }
    }

    static void writeLayoutComponentArray(List<String> codeList, String arrayName, String lcName) {
        codeList.add("LayoutComponent[] " + arrayName + " = new LayoutComponent[] { " + lcName + " };");
    }

    static void writeCollection(List<String> codeList, String name, Collection c) {
        codeList.add("Collection " + name + " = new ArrayList();");
        Iterator i = c.iterator();
        while (i.hasNext()) {
            codeList.add(name + ".add(\"" + (String)i.next() + "\");");
        }
    }

    static void writeStringArray(List<String> codeList, String name, String[] compIds) {
        codeList.add("String[] " + name + " = new String[] {");
        for (int i = 0; i < compIds.length; ++i) {
            codeList.add("\"" + compIds[i] + "\"" + (i + 1 < compIds.length ? "," : ""));
        }
        codeList.add("};");
    }

    static void writeIntArray(List<String> codeList, String name, int[] values) {
        codeList.add("int[] " + name + " = new int[] {");
        for (int i = 0; i < values.length; ++i) {
            codeList.add(Integer.toString(values[i]) + (i + 1 < values.length ? "," : ""));
        }
        codeList.add("};");
    }

    static void writeRectangleArray(List<String> codeList, String name, Rectangle[] bounds) {
        codeList.add("Rectangle[] " + name + " = new Rectangle[] {");
        for (int i = 0; i < bounds.length; ++i) {
            codeList.add("new Rectangle(" + bounds[i].x + ", " + bounds[i].y + ", " + bounds[i].width + ", " + bounds[i].height + (i + 1 < bounds.length ? "), " : ")"));
        }
        codeList.add("};");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void dumpTestcode(List codeList, DataObject form, int modelCounter) {
        FileWriter fw = null;
        StringBuilder template = new StringBuilder();
        if (form == null) {
            return;
        }
        try {
            FileObject primaryFile = form.getPrimaryFile();
            InputStream in = LayoutTestUtils.class.getResourceAsStream("/org/netbeans/modules/form/resources/LayoutModelAutoTest_template");
            LineNumberReader lReader = new LineNumberReader(new InputStreamReader(in));
            while (lReader.ready()) {
                template.append(lReader.readLine()).append('\n');
            }
            lReader.close();
            StringBuffer code = new StringBuffer();
            for (String line : codeList) {
                code.append(line).append('\n');
            }
            String testClassName = primaryFile.getName() + "Test";
            FileObject testFO = primaryFile.getParent().getFileObject(testClassName, "java");
            if (testFO == null) {
                testFO = primaryFile.getParent().createData(testClassName, "java");
                String output = template.toString().replace("${CLASS_NAME}", testFO.getName());
                fw = new FileWriter(FileUtil.toFile((FileObject)testFO));
                fw.write(output);
                fw.close();
            }
            String oldContent = testFO.asText();
            int idx = oldContent.lastIndexOf(125);
            StringBuilder sb = new StringBuilder();
            sb.append(oldContent.substring(0, idx));
            sb.append("public void doChanges");
            sb.append(modelCounter);
            sb.append("() {\n");
            sb.append(code);
            sb.append("}\n\n");
            sb.append(oldContent.substring(idx));
            FileLock lock = testFO.lock();
            try {
                OutputStreamWriter writer = new OutputStreamWriter(testFO.getOutputStream(lock));
                writer.write(sb.toString());
                ((Writer)writer).close();
            }
            finally {
                lock.releaseLock();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return;
        }
    }

    public static FileObject getTargetFolder(FileObject file) {
        FileObject targetFolder = file.getParent();
        try {
            FileObject folder = file.getParent().getParent().getParent().getParent().getParent().getParent().getParent().getFileObject("data/goldenfiles");
            if (folder != null) {
                targetFolder = folder;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return targetFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeTest(FormDesigner fd, FormDataObject formDO, Map<String, String> idToNameMap, LayoutModel lm) {
        FileObject formFO = formDO.getFormFile();
        fd.getLayoutDesigner().dumpTestcode((DataObject)formDO);
        OutputStreamWriter fw = null;
        try {
            FileObject targetFolder = LayoutTestUtils.getTargetFolder(formFO);
            FileObject fo = targetFolder.createData(formFO.getName() + "Test-ExpectedEndModel" + Integer.toString(fd.getLayoutDesigner().getModelCounter()), "txt");
            fw = new FileWriter(FileUtil.toFile((FileObject)fo));
            fw.write(lm.dump(idToNameMap));
            StatusDisplayer.getDefault().setStatusText("The test was successfully written: " + FileUtil.getFileDisplayName((FileObject)fo));
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return;
        }
        finally {
            try {
                if (fw != null) {
                    fw.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

