/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nashorn.execution.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.nashorn.execution.NashornPlatform;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.ui.support.FileSensitiveActions;
import org.openide.awt.DynamicMenuContent;
import org.openide.filesystems.FileObject;
import org.openide.util.ContextAwareAction;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.util.actions.Presenter;

abstract class ExecJSAction
extends AbstractAction
implements ContextAwareAction,
ActionListener,
ChangeListener {
    protected static final Action NO_ACTION = ExecJSAction.createNoAction();
    private final FileObject js;

    protected ExecJSAction(String name) {
        this.putValue("Name", name);
        this.js = null;
        this.setEnabled(true);
    }

    protected ExecJSAction(String name, FileObject js, String command) {
        this.putValue("Name", name);
        this.js = js;
        KeyStroke actionKeyStroke = ExecJSAction.getActionKeyStroke(command);
        this.putValue("AcceleratorKey", actionKeyStroke);
        this.setEnabled(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JavaPlatform javaPlatform = NashornPlatform.getDefault().getPlatform();
        if (javaPlatform == null) {
            return;
        }
        FileObject file = this.getCurrentFile();
        if (file == null) {
            return;
        }
        try {
            this.exec(javaPlatform, file);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (UnsupportedOperationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private FileObject getCurrentFile() {
        if (this.js != null) {
            return this.js;
        }
        return (FileObject)Utilities.actionsGlobalContext().lookup(FileObject.class);
    }

    protected abstract void exec(JavaPlatform var1, FileObject var2) throws IOException, UnsupportedOperationException;

    @Override
    public void stateChanged(ChangeEvent e) {
        JavaPlatform platform = NashornPlatform.getDefault().getPlatform();
        this.setEnabled(platform != null);
    }

    protected static KeyStroke getActionKeyStroke(String command) {
        Action fileCommandAction = FileSensitiveActions.fileCommandAction((String)command, (String)"name", null);
        if (fileCommandAction != null) {
            return (KeyStroke)fileCommandAction.getValue("AcceleratorKey");
        }
        return null;
    }

    protected static boolean isEnabledAction(String command, FileObject fo, Lookup actionContext) {
        ActionProvider ap;
        Project p = ExecJSAction.findProject(fo);
        if (p != null && (ap = (ActionProvider)p.getLookup().lookup(ActionProvider.class)) != null && ap.getSupportedActions() != null && Arrays.asList(ap.getSupportedActions()).contains(command)) {
            return ap.isActionEnabled(command, actionContext);
        }
        return false;
    }

    private static Project findProject(FileObject fo) {
        return FileOwnerQuery.getOwner((FileObject)fo);
    }

    private static Action createNoAction() {
        return new NoAction();
    }

    private static final class NoAction
    implements Action,
    Presenter.Popup {
        private NoItem NO_ITEM = new NoItem();

        private NoAction() {
        }

        @Override
        public Object getValue(String key) {
            return null;
        }

        @Override
        public void putValue(String key, Object value) {
        }

        @Override
        public void setEnabled(boolean b) {
        }

        @Override
        public boolean isEnabled() {
            return false;
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener listener) {
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener listener) {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            throw new UnsupportedOperationException("Not supported.");
        }

        public JMenuItem getPopupPresenter() {
            return this.NO_ITEM;
        }

        private static class NoItem
        extends JMenuItem
        implements DynamicMenuContent {
            private NoItem() {
            }

            public JComponent[] getMenuPresenters() {
                return new JComponent[0];
            }

            public JComponent[] synchMenuPresenters(JComponent[] items) {
                return items;
            }
        }
    }
}

