/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.visualeditor.querybuilder;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.KeyboardFocusManager;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.sql.support.SQLIdentifiers;
import org.netbeans.modules.db.sql.visualeditor.Log;
import org.netbeans.modules.db.sql.visualeditor.QueryEditorUILogger;
import org.netbeans.modules.db.sql.visualeditor.api.VisualSQLEditor;
import org.netbeans.modules.db.sql.visualeditor.api.VisualSQLEditorMetaData;
import org.netbeans.modules.db.sql.visualeditor.parser.ParseException;
import org.netbeans.modules.db.sql.visualeditor.parser.TokenMgrError;
import org.netbeans.modules.db.sql.visualeditor.querybuilder.CondNode;
import org.netbeans.modules.db.sql.visualeditor.querybuilder.JoinNode;
import org.netbeans.modules.db.sql.visualeditor.querybuilder.ParameterizedQueryDialog;
import org.netbeans.modules.db.sql.visualeditor.querybuilder.QueryBuilderGraphFrame;
import org.netbeans.modules.db.sql.visualeditor.querybuilder.QueryBuilderMetaData;
import org.netbeans.modules.db.sql.visualeditor.querybuilder.QueryBuilderPane;
import org.netbeans.modules.db.sql.visualeditor.querybuilder.QueryModel;
import org.netbeans.modules.db.sql.visualeditor.querybuilder.TableNode;
import org.netbeans.modules.db.sql.visualeditor.querymodel.Column;
import org.netbeans.modules.db.sql.visualeditor.querymodel.ColumnProvider;
import org.netbeans.modules.db.sql.visualeditor.querymodel.JoinTable;
import org.netbeans.modules.db.sql.visualeditor.querymodel.OrderBy;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.actions.DeleteAction;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.ActionPerformer;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class QueryBuilder
extends TopComponent
implements ClipboardOwner,
KeyListener,
ColumnProvider {
    QueryBuilderPane _queryBuilderPane;
    QueryModel _queryModel;
    boolean _updateModel = true;
    boolean _graphicsEnabled = true;
    boolean _updateText = true;
    SQLIdentifiers.Quoter quoter;
    private String lastQuery;
    private boolean firstTimeGenerateText = true;
    private String _parseErrorMessage = null;
    private boolean DEBUG = false;
    private DatabaseConnection dbconn;
    private String statement;
    private QueryBuilderMetaData qbMetaData;
    private VisualSQLEditor vse;
    private SQLException lastException = null;
    private final transient DeleteActionPerformer deleteActionPerformer = new DeleteActionPerformer();
    final transient CopyCutActionPerformer copyActionPerformer = new CopyCutActionPerformer(true);
    final transient CopyCutActionPerformer cutActionPerformer = new CopyCutActionPerformer(false);

    public static Component open(DatabaseConnection dbconn, String statement, VisualSQLEditorMetaData metadata, VisualSQLEditor vse) {
        QueryBuilder qb;
        Log.getLogger().entering("QueryBuilder", "open");
        QueryEditorUILogger.logEditorOpened();
        Connection conn = dbconn.getJDBCConnection();
        if (conn == null) {
            ConnectionManager.getDefault().showConnectionDialog(dbconn);
        }
        if (dbconn.getJDBCConnection() == null) {
            return null;
        }
        QueryBuilder.showBusyCursor(true);
        try {
            qb = new QueryBuilder(dbconn, statement, metadata, vse);
        }
        catch (SQLException sqle) {
            qb = null;
        }
        final QueryBuilder queryBuilder = qb;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (queryBuilder != null) {
                    queryBuilder.open();
                    queryBuilder.requestActive();
                }
                QueryBuilder.showBusyCursor(false);
            }
        });
        queryBuilder.getTextAreaFocusInvokeLater();
        return queryBuilder;
    }

    private QueryBuilder(DatabaseConnection dbconn, String statement, VisualSQLEditorMetaData metadata, VisualSQLEditor vse) throws SQLException {
        Log.getLogger().entering("QueryBuilder", "constructor");
        this.dbconn = dbconn;
        this.statement = statement;
        this.vse = vse;
        this.qbMetaData = metadata == null ? new QueryBuilderMetaData(dbconn, this) : new QueryBuilderMetaData(metadata, this);
        this.quoter = SQLIdentifiers.createQuoter((DatabaseMetaData)this.getConnection().getMetaData());
        String title = dbconn.getName();
        this.setName(title);
        this.setDisplayName(title);
        this.setLayout(new BorderLayout());
        ImageIcon imgIcon = new ImageIcon(this.getClass().getResource("/org/netbeans/modules/db/sql/visualeditor/resources/query-editor-tab.png"));
        if (imgIcon != null) {
            this.setIcon(imgIcon.getImage());
        }
        this._queryBuilderPane = new QueryBuilderPane(this);
        this.add(this._queryBuilderPane);
        this.addKeyListener(this);
    }

    public boolean isSchemaName(String schemaName) {
        return this.qbMetaData.isSchemaName(schemaName);
    }

    public boolean isTableName(String tableName) {
        return this.qbMetaData.isTableName(tableName);
    }

    public boolean isColumnName(String columnName) {
        return this.qbMetaData.isColumnName(columnName);
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    boolean isSelectionEmpty() {
        Node[] nodes = this.getActivatedNodes();
        return nodes == null || nodes.length == 0;
    }

    private boolean isActivated() {
        return this == TopComponent.getRegistry().getActivated();
    }

    public int getPersistenceType() {
        return 2;
    }

    public String preferredID() {
        return "QueryEditor";
    }

    public void activateActions() {
        if (this.isSelectionEmpty()) {
            this.disableDelete();
        } else {
            this.enableDelete();
        }
        this.disableCutCopy();
    }

    public void deactivateActions() {
        if (this.deleteActionPerformer != null) {
            // empty if block
        }
    }

    void enableDelete() {
        if (!this.isActivated()) {
            return;
        }
        this.deleteActionPerformer.setEnabled(true);
    }

    void disableDelete() {
        if (!this.isActivated()) {
            return;
        }
        this.deleteActionPerformer.setEnabled(false);
        DeleteAction da = (DeleteAction)SystemAction.get(DeleteAction.class);
        da.setEnabled(false);
    }

    void disableCutCopy() {
        if (this.DEBUG) {
            System.out.println(" disableCutCopy called. \n");
        }
        this.cutActionPerformer.setEnabled(false);
        this.copyActionPerformer.setEnabled(false);
    }

    private void deleteSelection() {
        KeyboardFocusManager kbfm;
        Component c;
        if (this.DEBUG) {
            System.out.println(" deleteSelection called. \n");
        }
        if ((c = (kbfm = KeyboardFocusManager.getCurrentKeyboardFocusManager()).getFocusOwner()) != null) {
            for (Container p = c.getParent(); p != null; p = p.getParent()) {
                if (!(p instanceof QueryBuilderGraphFrame)) continue;
                Node[] nodes = this.getActivatedNodes();
                if (nodes == null || nodes.length == 0) {
                    return;
                }
                for (int i = 0; i < nodes.length; ++i) {
                    if (nodes[i] instanceof CondNode) {
                        this._queryBuilderPane.getQueryBuilderGraphFrame().removeNode((CondNode)nodes[i]);
                        continue;
                    }
                    if (nodes[i] instanceof JoinNode) {
                        this._queryBuilderPane.getQueryBuilderGraphFrame().removeNode((JoinNode)nodes[i]);
                        continue;
                    }
                    if (!(nodes[i] instanceof TableNode)) continue;
                    this._queryBuilderPane.getQueryBuilderGraphFrame().removeNode((TableNode)nodes[i]);
                }
            }
        }
    }

    private void installActions(ActionMap map, InputMap keys) {
        map.put("delete", this.deleteActionPerformer);
        map.put("copy-to-clipboard", this.copyActionPerformer);
        map.put("cut-to-clipboard", this.cutActionPerformer);
        keys.put(KeyStroke.getKeyStroke("DELETE"), "delete");
    }

    void getGraphFrameCanvasFocus() {
        this._queryBuilderPane.getQueryBuilderGraphFrame().getCanvasFocus();
    }

    void getTextAreaFocusInvokeLater() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                QueryBuilder.this._queryBuilderPane.getQueryBuilderSqlTextArea().requestFocus(true);
                QueryBuilder.this._queryBuilderPane.getQueryBuilderSqlTextArea().requestFocusInWindow();
            }
        });
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.handleKeyPress(e);
    }

    public void handleKeyPress(KeyEvent e) {
        if (e.isAltDown()) {
            int code = e.getKeyCode();
            switch (code) {
                case 49: {
                    if (this.DEBUG) {
                        System.out.println(" Alt + 1 pressed. ");
                    }
                    this.getGraphFrameCanvasFocus();
                    break;
                }
                case 50: {
                    if (this.DEBUG) {
                        System.out.println(" Alt + 2 pressed. ");
                    }
                    if (this._queryBuilderPane.getQueryBuilderInputTable().getRowCount() <= 0) break;
                    this._queryBuilderPane.getQueryBuilderInputTable().setRowSelectionInterval(0, 0);
                    this._queryBuilderPane.getQueryBuilderInputTable().requestFocus(true);
                    break;
                }
                case 51: {
                    if (this.DEBUG) {
                        System.out.println(" Alt + 3 pressed. ");
                    }
                    this._queryBuilderPane.getQueryBuilderSqlTextArea().requestFocus(true);
                    break;
                }
                case 52: {
                    if (this.DEBUG) {
                        System.out.println(" Alt + 4 pressed. ");
                    }
                    this._queryBuilderPane.getQueryBuilderResultTable().requestFocus(true);
                }
            }
        }
    }

    String checkTableName(String tableName) throws SQLException {
        return this.qbMetaData.checkTableName(tableName);
    }

    String checkFullTableName(String fullTableName) throws SQLException {
        return this.qbMetaData.checkFullTableName(fullTableName);
    }

    String checkColumnName(String tableName, String columnName) throws SQLException {
        return this.qbMetaData.checkColumnName(tableName, columnName);
    }

    boolean checkColumnNameForTable(Column col, String tableName) {
        return this.qbMetaData.checkColumnNameForTable(col, tableName);
    }

    boolean checkTableColumnName(Column col) throws SQLException {
        return this.qbMetaData.checkTableColumnName(col);
    }

    boolean populate(String query, boolean forceParse) {
        Log.getLogger().entering("QueryBuilder", "populate", query);
        if (!forceParse && query.trim().equals(this._queryBuilderPane.getQueryBuilderSqlTextArea().getText().trim())) {
            Log.getLogger().finest("  skipping populate(), no change");
            return true;
        }
        if (query.trim().equals(this.lastQuery)) {
            Log.getLogger().finest("  skipping populate(), no change");
            return true;
        }
        this.lastQuery = new String(query.trim());
        try {
            this.parseQuery(query);
            if (!this.checkQuery()) {
                return false;
            }
            this._queryBuilderPane.getQueryBuilderGraphFrame().setQBGFEnabled(true);
            this._queryBuilderPane.setQueryBuilderInputTableEnabled(true);
            this._queryBuilderPane.getQueryBuilderGraphFrame().setTableColumnValidity(false);
            this._queryBuilderPane.getQueryBuilderGraphFrame().setGroupBy(this._queryModel.hasGroupBy());
            this._graphicsEnabled = true;
        }
        catch (ParseException pe) {
            Log.getLogger().severe("Parse error: " + pe.getLocalizedMessage());
            this.promptForContinuation(pe.getMessage(), query);
            return false;
        }
        catch (TokenMgrError tme) {
            Log.getLogger().severe("Parse error: " + tme.getLocalizedMessage());
            this.promptForContinuation(tme.getMessage(), query);
            return false;
        }
        catch (SQLException sqe) {
            this.lastException = sqe;
            Log.getLogger().severe("Parse error: " + sqe.getLocalizedMessage());
            this.promptForContinuation(sqe.getMessage(), query);
            return false;
        }
        this._parseErrorMessage = null;
        this.generate();
        this.saveSqlCommand();
        this._queryBuilderPane.getQueryBuilderSqlTextArea().requestFocus();
        return true;
    }

    private boolean promptForContinuation(String msg, String query) {
        Object[] options = new Object[]{NbBundle.getMessage(QueryBuilder.class, (String)"CONTINUE"), NbBundle.getMessage(QueryBuilder.class, (String)"CANCEL")};
        if (this._queryBuilderPane.getQueryBuilderSqlTextArea().queryChanged()) {
            int val = JOptionPane.showOptionDialog((Component)((Object)this), msg + "\n\n" + NbBundle.getMessage(QueryBuilder.class, (String)"PARSE_ERROR_MESSAGE") + NbBundle.getMessage(QueryBuilder.class, (String)"PARSE_ERROR_MESSAGE_PROMPT"), NbBundle.getMessage(QueryBuilder.class, (String)"PARSE_ERROR"), 0, 3, null, options, options[0]);
            if (val == 1) {
                Log.getLogger().info("Query execution canceled");
                this._queryBuilderPane.getQueryBuilderSqlTextArea().restoreLastGoodQuery();
                this._queryBuilderPane.getQueryBuilderGraphFrame().setQBGFEnabled(true);
                this._queryBuilderPane.setQueryBuilderInputTableEnabled(true);
                this._graphicsEnabled = true;
                this._parseErrorMessage = null;
            } else {
                this._parseErrorMessage = NbBundle.getMessage(QueryBuilder.class, (String)"PARSE_ERROR_MESSAGE");
                this.disableVisualEditing(query);
            }
        } else {
            this._parseErrorMessage = NbBundle.getMessage(QueryBuilder.class, (String)"PARSE_ERROR_MESSAGE");
            this.disableVisualEditing(query);
        }
        return false;
    }

    private void disableVisualEditing(String query) {
        this._graphicsEnabled = false;
        this._queryBuilderPane.clear();
        this._queryBuilderPane.getQueryBuilderGraphFrame().setQBGFEnabled(false);
        this._queryBuilderPane.setQueryBuilderInputTableEnabled(false);
        String command = this.getSqlCommand();
        if (query != null && query.trim().length() != 0) {
            this.setSqlText(query);
            this.setSqlCommand(query);
        } else {
            this.setSqlText(command);
        }
    }

    private boolean checkQuery() throws SQLException {
        if (this.getSqlText() != null || this._queryBuilderPane.getQueryBuilderGraphFrame().checkTableColumnValidity()) {
            if (!this.checkFrom()) {
                return false;
            }
            this._queryModel.replaceStar(this);
            if (!this.checkSelect()) {
                return false;
            }
            if (!this.checkWhere()) {
                return false;
            }
            if (!this.checkGroupBy()) {
                return false;
            }
            if (!this.checkHaving()) {
                return false;
            }
            if (!this.checkOrderBy()) {
                return false;
            }
        } else {
            this._queryModel.replaceStar(this);
        }
        return true;
    }

    private boolean checkFrom() throws SQLException {
        if (this.DEBUG) {
            System.out.println("checkFrom called... \n ");
        }
        if (this._queryModel.getFrom() != null) {
            List fromTables = this._queryModel.getFrom().getTableList();
            for (int i = 0; i < fromTables.size(); ++i) {
                String fromTableName = ((JoinTable)fromTables.get(i)).getFullTableName();
                String fromTableSpec = ((JoinTable)fromTables.get(i)).getTableSpec();
                String checkedFullTableName = this.checkFullTableName(fromTableName);
                if (this.DEBUG) {
                    System.out.println("checkFullTableName called, fromTableName: " + fromTableName + " returns: " + checkedFullTableName + " \n ");
                }
                if (checkedFullTableName == null) {
                    this.showTableColumnNameError(fromTableName);
                    return false;
                }
                if (!checkedFullTableName.equals(fromTableName)) {
                    if (this.DEBUG) {
                        System.out.println(" fromTableName = " + fromTableName + " fromTableSpec = " + fromTableSpec + " \n");
                    }
                    this._queryModel.getFrom().setTableSpec(fromTableSpec, checkedFullTableName);
                }
                ArrayList fromColumns = new ArrayList();
                ((JoinTable)fromTables.get(i)).getReferencedColumns(fromColumns);
                for (int j = 0; j < fromColumns.size(); ++j) {
                    Column fromColumn = (Column)fromColumns.get(j);
                    if (this.checkTableColumnName(fromColumn)) continue;
                    this.showTableColumnNameError(fromColumn.getColumnName());
                    return false;
                }
            }
        }
        return true;
    }

    private boolean checkSelect() throws SQLException {
        if (this.DEBUG) {
            System.out.println("checkSelect called. _queryModel.getSelect() = " + this._queryModel.getSelect());
        }
        if (this._queryModel.getSelect() != null) {
            ArrayList<Column> selectColumns = new ArrayList<Column>();
            this._queryModel.getSelect().getReferencedColumns(selectColumns);
            if (!this.checkColumns(selectColumns)) {
                return false;
            }
        }
        return true;
    }

    private boolean checkWhere() throws SQLException {
        if (this.DEBUG) {
            System.out.println("checkWhere called... ");
        }
        if (this._queryModel.getWhere() != null) {
            ArrayList<Column> whereColumns = new ArrayList<Column>();
            this._queryModel.getWhere().getReferencedColumns(whereColumns);
            if (!this.checkColumns(whereColumns)) {
                return false;
            }
        }
        return true;
    }

    private boolean checkGroupBy() throws SQLException {
        if (this.DEBUG) {
            System.out.println("checkGroupBy called... ");
        }
        if (this._queryModel.getGroupBy() != null) {
            ArrayList<Column> groupByColumns = new ArrayList<Column>();
            this._queryModel.getGroupBy().getReferencedColumns(groupByColumns);
            if (!this.checkColumns(groupByColumns)) {
                return false;
            }
        }
        return true;
    }

    private boolean checkHaving() throws SQLException {
        if (this.DEBUG) {
            System.out.println("checkHaving called... ");
        }
        if (this._queryModel.getHaving() != null) {
            ArrayList<Column> havingColumns = new ArrayList<Column>();
            this._queryModel.getHaving().getReferencedColumns(havingColumns);
            if (!this.checkColumns(havingColumns)) {
                return false;
            }
        }
        return true;
    }

    private boolean checkOrderBy() throws SQLException {
        OrderBy orderBy;
        if (this.DEBUG) {
            System.out.println("checkOrderBy called... ");
        }
        if ((orderBy = this._queryModel.getOrderBy()) != null) {
            ArrayList<Column> orderByColumns = new ArrayList<Column>();
            for (int i = 0; i < orderBy.getSortSpecificationCount(); ++i) {
                Column sortColumn = orderBy.getSortSpecification(i).getColumn();
                orderByColumns.add(sortColumn);
            }
            if (!this.checkColumns(orderByColumns)) {
                return false;
            }
        }
        return true;
    }

    private boolean checkColumns(List<Column> columns) throws SQLException {
        Log.getLogger().entering("QueryBuilder", "checkColumns");
        for (int i = 0; i < columns.size(); ++i) {
            Column column = columns.get(i);
            String columnTableSpec = column.getTableSpec();
            String columnFullTableName = column.getFullTableName();
            if (columnFullTableName == null && this._queryModel.getFrom() != null) {
                List fromTables = this._queryModel.getFrom().getTableList();
                boolean found = false;
                for (int j = 0; j < fromTables.size(); ++j) {
                    String fromTableName = ((JoinTable)fromTables.get(j)).getFullTableName();
                    String fromTableSpec = ((JoinTable)fromTables.get(j)).getTableSpec();
                    if (this.DEBUG) {
                        System.out.println(" checkColumns called  fromTableName = " + fromTableName + " fromTableSpec = " + fromTableSpec);
                    }
                    if (!this.checkColumnNameForTable(column, fromTableSpec)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    this.showTableColumnNameError(column.getColumnName());
                    return false;
                }
            }
            if (this.checkTableColumnName(column)) continue;
            this.showTableColumnNameError(column.getColumnName());
            return false;
        }
        return true;
    }

    private void showTableColumnNameError(String error) {
        String msg = NbBundle.getMessage(QueryBuilder.class, (String)"TABLE_COLUMN_NAME_ERROR");
        NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)(error + " : " + msg + "\n\n"), 0);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
        this._parseErrorMessage = error + " : " + msg + "\n\n";
        String query = this.getSqlText();
        this.disableVisualEditing(query);
    }

    private void parseQuery(String query) throws ParseException {
        Log.getLogger().entering("QueryBuilder", "parseQuery", query);
        if (this._queryModel == null) {
            this._queryModel = new QueryModel(this.quoter);
        }
        this._queryModel.parse(query);
    }

    private void saveSqlCommand() {
        String query = this.getSqlText();
        if (!query.equals(this.getSqlCommand())) {
            Log.getLogger().finest("QB:  setting sql command to: " + query);
            this.setSqlCommand(query);
        }
    }

    void setSqlCommand(String query) {
        this.vse.setStatement(query);
    }

    String getSqlCommand() {
        return this.vse.getStatement();
    }

    String getConnectionInfo() {
        String conn = "";
        try {
            conn = this.getConnection().getMetaData().getURL();
        }
        catch (SQLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return conn;
    }

    Connection getConnection() {
        Connection conn = this.dbconn.getJDBCConnection();
        if (conn == null) {
            ConnectionManager.getDefault().showConnectionDialog(this.dbconn);
            conn = this.dbconn.getJDBCConnection();
            if (conn == null) {
                String msg = NbBundle.getMessage(QueryBuilder.class, (String)"CANNOT_ESTABLISH_CONNECTION");
                NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)(msg + "\n\n"), 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
            }
        }
        return conn;
    }

    void closeQB() {
    }

    List getColumnNames(String fullTableName) throws SQLException {
        return this.qbMetaData.getColumnNames(fullTableName);
    }

    @Override
    public void getColumnNames(String fullTableName, List columnNames) {
        this.qbMetaData.getColumnNames(fullTableName, columnNames);
    }

    List getImportedKeyColumns(String fullTableName) throws SQLException {
        return this.qbMetaData.getImportedKeyColumns(fullTableName);
    }

    List<String> getAllTables() throws SQLException {
        return this.qbMetaData.getAllTables();
    }

    List getPrimaryKeys(String fullTableName) throws SQLException {
        return this.qbMetaData.getPrimaryKeys(fullTableName);
    }

    List getForeignKeys(String fullTableName) throws SQLException {
        return this.qbMetaData.getForeignKeys(fullTableName);
    }

    String[] findForeignKey(String oldFullTableName, String newFullTableName, List foreignKeys) {
        return this.qbMetaData.findForeignKey(oldFullTableName, newFullTableName, foreignKeys);
    }

    String[] findForeignKey(String fullTableName1, String colName1, String fullTableName2, String colName2) throws SQLException {
        return this.qbMetaData.findForeignKey(fullTableName1, colName1, fullTableName2, colName2);
    }

    void executeQuery(String query) {
        Log.getLogger().entering("QueryBuilder", "executeQuery", query);
        String sqlCommand = this.getSqlText();
        ResultSet result = null;
        Connection connection = null;
        PreparedStatement myStatement = null;
        QueryBuilder.showBusyCursor(true);
        boolean canExecute = true;
        ParameterMetaData pmd = null;
        int paramCount = 0;
        try {
            connection = this.getConnection();
            if (connection == null) {
                canExecute = false;
            } else {
                myStatement = connection.prepareStatement(sqlCommand);
                pmd = myStatement.getParameterMetaData();
                paramCount = pmd.getParameterCount();
                if (this.DEBUG) {
                    System.out.println(" Parameter Count  = " + paramCount);
                    for (int i = 1; i <= paramCount; ++i) {
                        System.out.println(" Parameter Type  = " + pmd.getParameterType(i));
                        System.out.println(" Parameter Type Name = " + pmd.getParameterTypeName(i));
                    }
                }
            }
        }
        catch (SQLException e) {
            this.reportDatabaseError(e);
            canExecute = false;
        }
        catch (AbstractMethodError e) {
            Log.getLogger().severe("Error occurred when trying to retrieve table information: " + e);
            String title = NbBundle.getMessage(QueryBuilder.class, (String)"PROCESSING_ERROR");
            JOptionPane.showMessageDialog((Component)((Object)this), e.toString() + "\n\n", title, 0);
            canExecute = false;
        }
        if (canExecute && this._queryModel != null) {
            if (this.getParseErrorMessage() == null && this._queryModel.isParameterized()) {
                ArrayList list = new ArrayList();
                this._queryModel.getParameterizedPredicates(list);
                String[] parameters = new String[list.size()];
                String[] values = new String[list.size()];
                for (int i = 0; i < parameters.length; ++i) {
                    parameters[i] = new String((String)list.get(i));
                }
                ParameterizedQueryDialog pqDlg = new ParameterizedQueryDialog(parameters, true);
                if (pqDlg.getReturnStatus() == 1) {
                    values = pqDlg.getParameterValues();
                    try {
                        for (int i = 0; i < values.length; ++i) {
                            if (this.DEBUG) {
                                System.out.println(" command  = " + sqlCommand);
                                System.out.println("PreparedStatement i = " + i + " values = " + values[i]);
                            }
                            myStatement.setObject(i + 1, (Object)values[i], pmd.getParameterType(i + 1));
                        }
                    }
                    catch (SQLException e) {
                        if (this.isUnsupportedFeature(e)) {
                            Log.getLogger().log(Level.FINE, null, e);
                            String msg = NbBundle.getMessage(QueryBuilder.class, (String)"PARAMETERS_NOT_SUPPORTED");
                            this.reportProcessingError(msg);
                        } else {
                            this.reportDatabaseError(e);
                        }
                        canExecute = false;
                    }
                } else {
                    canExecute = false;
                }
            } else if (paramCount != 0) {
                ParameterizedQueryDialog pqDlg;
                int i;
                if (this.DEBUG) {
                    System.out.println(" param count = " + paramCount);
                }
                String[] parameters = new String[paramCount];
                String[] values = new String[paramCount];
                if (this.DEBUG) {
                    System.out.println(" parameters size  = " + parameters.length);
                    System.out.println(" values size  = " + values.length);
                }
                for (i = 0; i < paramCount; ++i) {
                    parameters[i] = new String("Parameter " + Integer.valueOf(i).toString());
                }
                if (this.DEBUG) {
                    for (i = 0; i < parameters.length; ++i) {
                        System.out.println(" parameter  = " + parameters[i]);
                    }
                }
                if ((pqDlg = new ParameterizedQueryDialog(parameters, true)).getReturnStatus() == 1) {
                    values = pqDlg.getParameterValues();
                    try {
                        for (int i2 = 0; i2 < values.length; ++i2) {
                            if (this.DEBUG) {
                                System.out.println(" command  = " + sqlCommand);
                                System.out.println("PreparedStatement i = " + i2 + " values = " + values[i2]);
                            }
                            myStatement.setObject(i2 + 1, (Object)values[i2], pmd.getParameterType(i2 + 1));
                        }
                    }
                    catch (SQLException e) {
                        this.reportDatabaseError(e);
                        canExecute = false;
                    }
                } else {
                    canExecute = false;
                }
            }
        }
        if (canExecute) {
            try {
                boolean hasResults = myStatement.execute();
                if (hasResults) {
                    result = myStatement.getResultSet();
                    this._queryBuilderPane.getQueryBuilderResultTable().displayResultSet(result);
                    result.close();
                }
            }
            catch (SQLException e) {
                this.reportDatabaseError(e);
            }
        }
        try {
            if (myStatement != null) {
                myStatement.close();
            }
        }
        catch (SQLException se) {
            Log.getLogger().finest("Error Closing statement: " + se.getLocalizedMessage());
        }
        QueryBuilder.showBusyCursor(false);
        Log.getLogger().finest("Returning from QueryBuilder.executeQuery");
    }

    void generate() {
        Log.getLogger().entering("QueryBuilder", "generate");
        this._updateText = false;
        try {
            this._queryBuilderPane.clear();
            this.generateGraph();
        }
        finally {
            this._updateText = true;
        }
        this.generateText();
    }

    private void generateGraph() {
        if (this._graphicsEnabled) {
            this._queryBuilderPane.getQueryBuilderGraphFrame().generateGraph(this._queryModel);
        }
    }

    void generateText() {
        if (this._graphicsEnabled) {
            this.setSqlText(this._queryModel.genText());
            if (!this.firstTimeGenerateText) {
                this.saveSqlCommand();
            } else {
                this.firstTimeGenerateText = false;
            }
        }
    }

    QueryModel getQueryModel() {
        return this._queryModel;
    }

    QueryBuilderPane getQueryBuilderPane() {
        return this._queryBuilderPane;
    }

    public VisualSQLEditor getVisualSQLEditor() {
        return this.vse;
    }

    private String getSqlText() {
        return this._queryBuilderPane.getQueryBuilderSqlTextArea().getText();
    }

    private void setSqlText(String text) {
        this._queryBuilderPane.getQueryBuilderSqlTextArea().setText(text);
    }

    private boolean isParameterized() {
        return this._queryModel.isParameterized();
    }

    public QueryBuilderMetaData getMetaData() {
        return this.qbMetaData;
    }

    protected void componentShowing() {
        Log.getLogger().entering("QueryBuilder", "componentShowing");
        String command = this.getSqlCommand();
        if (this._queryModel == null) {
            this._queryModel = new QueryModel(this.quoter);
        }
        Log.getLogger().finest("  * command=" + command);
        if (command == null || command.trim().length() == 0) {
            Log.getLogger().finest("QBShowing command is null");
            this.setVisible(true);
            this.repaint();
            String msg = NbBundle.getMessage(QueryBuilder.class, (String)"EMPTY_QUERY_ADD_TABLE");
            NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)(msg + "\n\n"), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
            this._queryBuilderPane.getQueryBuilderGraphFrame().addTable();
        } else {
            String queryText = this.getSqlText();
            if (queryText == null || !command.trim().equalsIgnoreCase(queryText.trim())) {
                this.populate(command, false);
                this.setVisible(true);
                this.repaint();
            }
        }
        this.activateActions();
        this._queryBuilderPane.getQueryBuilderSqlTextArea().requestFocus();
        if (this.DEBUG) {
            System.out.println(" _queryBuilderPane.getQueryBuilderSqlTextArea().requestFocus () called. ");
        }
    }

    protected void componentHidden() {
        String queryText;
        Log.getLogger().entering("QueryBuilder", "componentHidden");
        String command = this.getSqlCommand();
        if (!(command == null || command.trim().length() == 0 || (queryText = this.getSqlText()) != null && command.trim().equalsIgnoreCase(queryText.trim()))) {
            if (this._graphicsEnabled) {
                boolean good = this.populate(queryText, true);
                if (!good) {
                    this.setSqlCommand(queryText);
                }
            } else {
                this.setSqlCommand(queryText);
            }
        }
        this.deactivateActions();
    }

    protected void componentOpened() {
        Log.getLogger().entering("QueryBuilder", "componentOpened");
        this.activateActions();
        ActionMap map = this.getActionMap();
        InputMap keys = this.getInputMap(1);
        this.installActions(map, keys);
    }

    protected void componentClosed() {
        Log.getLogger().entering("QueryBuilder", "componentClosed");
        this.deactivateActions();
        this.closeQB();
        this.lastQuery = null;
    }

    private boolean isUnsupportedFeature(SQLException e) {
        return e.getErrorCode() == 17023 || "S1C00".equals(e.getSQLState());
    }

    private void reportProcessingError(String msg) {
        String title = NbBundle.getMessage(QueryBuilder.class, (String)"PROCESSING_ERROR");
        JOptionPane.showMessageDialog((Component)((Object)this), msg + "\n\n", title, 0);
    }

    private void reportDatabaseError(SQLException e) {
        Log.getLogger().log(Level.FINE, null, e);
        String msg = this.isUnsupportedFeature(e) ? NbBundle.getMessage(QueryBuilder.class, (String)"UNSUPPORTED_FEATURE") : e.getLocalizedMessage();
        this.reportProcessingError(msg);
    }

    String getParseErrorMessage() {
        return this._parseErrorMessage;
    }

    static void showBusyCursor(final boolean busy) {
        if (SwingUtilities.isEventDispatchThread()) {
            QueryBuilder.doShowBusyCursor(busy);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    QueryBuilder.doShowBusyCursor(busy);
                }
            });
        }
    }

    private static void doShowBusyCursor(boolean busy) {
        JFrame mainWindow = (JFrame)WindowManager.getDefault().getMainWindow();
        if (busy) {
            RepaintManager.currentManager(mainWindow).paintDirtyRegions();
            mainWindow.getGlassPane().setCursor(Cursor.getPredefinedCursor(3));
            mainWindow.getGlassPane().setVisible(true);
            mainWindow.repaint();
        } else {
            mainWindow.getGlassPane().setVisible(false);
            mainWindow.getGlassPane().setCursor(null);
            mainWindow.repaint();
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("projrave_ui_elements_editors_about_query_editor");
    }

    class CopyCutActionPerformer
    extends AbstractAction
    implements ActionPerformer {
        boolean isCopy;

        public CopyCutActionPerformer(boolean b) {
            this.isCopy = b;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.performAction(null);
        }

        public void performAction(SystemAction action) {
        }
    }

    class DeleteActionPerformer
    extends AbstractAction
    implements ActionPerformer {
        DeleteActionPerformer() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.performAction(null);
        }

        public void performAction(SystemAction action) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    QueryBuilder.this.deleteSelection();
                }
            });
        }
    }
}

