/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.validation.api.builtin.stringvalidation;

import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;
import org.netbeans.validation.api.Problems;
import org.netbeans.validation.api.builtin.stringvalidation.StringValidator;
import org.openide.util.NbBundle;

final class IsANumberValidator
extends StringValidator {
    private Locale locale;

    IsANumberValidator() {
        this((Locale)null);
    }

    IsANumberValidator(Locale l) {
        this.locale = l;
    }

    @Override
    public void validate(Problems problems, String compName, String model) {
        ParsePosition p = new ParsePosition(0);
        NumberFormat.getNumberInstance(this.locale == null ? Locale.getDefault() : this.locale).parse(model, p);
        if (model.length() != p.getIndex() || p.getErrorIndex() != -1) {
            try {
                Double.valueOf(model);
                if (model.length() != model.trim().length()) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException e) {
                problems.add(NbBundle.getMessage(IsANumberValidator.class, (String)"NOT_A_NUMBER", (Object)model, (Object)compName));
            }
        }
    }
}

