/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.ui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleIcon;
import javax.swing.Icon;
import javax.swing.JButton;
import org.eclipse.lsp4j.MessageActionItem;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.ShowMessageRequestParams;
import org.netbeans.modules.java.lsp.server.protocol.QuickPickItem;
import org.netbeans.modules.java.lsp.server.protocol.ShowInputBoxParams;
import org.netbeans.modules.java.lsp.server.protocol.ShowQuickPickParams;
import org.netbeans.modules.java.lsp.server.ui.Bundle;
import org.netbeans.modules.java.lsp.server.ui.UIContext;
import org.openide.NotifyDescriptor;
import org.openide.awt.Actions;

class NotifyDescriptorAdapter {
    private static final Logger LOG = Logger.getLogger(NotifyDescriptorAdapter.class.getName());
    private final UIContext client;
    private final NotifyDescriptor descriptor;
    private final Map<MessageActionItem, Object> item2Option = new LinkedHashMap<MessageActionItem, Object>();
    private final Map<String, Object> text2Option = new HashMap<String, Object>();
    private final Map<Object, List<ActionListener>> optionListeners = new HashMap<Object, List<ActionListener>>();
    private final Map<Object, JButton> option2Button = new HashMap<Object, JButton>();
    private static final Set<String> warnedClasses = new HashSet<String>();
    private ShowMessageRequestParams request;
    private static final Object[] YES_NO_CANCEL = new Object[]{NotifyDescriptor.YES_OPTION, NotifyDescriptor.NO_OPTION, NotifyDescriptor.CANCEL_OPTION};
    private static final Object[] YES_NO = new Object[]{NotifyDescriptor.YES_OPTION, NotifyDescriptor.NO_OPTION};
    private static final Object[] OK_CANCEL = new Object[]{NotifyDescriptor.OK_OPTION, NotifyDescriptor.CANCEL_OPTION};
    private static final Object[] JUST_OK = new Object[]{NotifyDescriptor.OK_OPTION};

    public NotifyDescriptorAdapter(NotifyDescriptor descriptor, UIContext client) {
        this.descriptor = descriptor;
        this.client = client;
    }

    private MessageType translateMessageType() {
        switch (this.descriptor.getMessageType()) {
            case 0: {
                return MessageType.Error;
            }
            case 2: {
                return MessageType.Warning;
            }
            case -1: 
            case 1: 
            case 3: {
                return MessageType.Info;
            }
        }
        return MessageType.Log;
    }

    private String translateText(String original) {
        if (!original.startsWith("<html>")) {
            return original;
        }
        return original.replaceAll("<p/>|</p>|<br>", "\n").replaceAll("<[^>]*>", "").replace("&nbsp;", " ").trim();
    }

    public String getAccessibleDescription(Object o) {
        if (!(o instanceof Accessible)) {
            return null;
        }
        AccessibleContext ac = ((Accessible)o).getAccessibleContext();
        String s = ac.getAccessibleDescription();
        if (s != null && !"N/A".equals(s)) {
            return s;
        }
        return ac.getAccessibleName();
    }

    private ShowMessageRequestParams createShowMessageRequest() {
        if (this.request != null) {
            return this.request;
        }
        Object msg = this.descriptor.getMessage();
        String displayText = null;
        displayText = msg instanceof String ? msg.toString() : this.getAccessibleDescription(msg);
        if (displayText == null) {
            return null;
        }
        this.mapDescriptorOptions();
        ShowMessageRequestParams request = new ShowMessageRequestParams();
        request.setMessage(this.translateText(displayText));
        request.setActions(this.getActionItems());
        request.setType(this.translateMessageType());
        this.request = request;
        return this.request;
    }

    public Object actionToOption(MessageActionItem item) {
        return this.item2Option.get(item);
    }

    public List<MessageActionItem> getActionItems() {
        return new ArrayList<MessageActionItem>(this.item2Option.keySet());
    }

    private void addMessageItem(MessageActionItem item, Object option) {
        this.item2Option.put(item, option);
        this.text2Option.put(item.getTitle(), option);
    }

    private String mapDescriptorOption(Object option) {
        if (option == NotifyDescriptor.CANCEL_OPTION) {
            return Bundle.OPTION_Cancel();
        }
        if (option == NotifyDescriptor.NO_OPTION) {
            return Bundle.OPTION_No();
        }
        if (option == NotifyDescriptor.YES_OPTION) {
            return Bundle.OPTION_Yes();
        }
        if (option == NotifyDescriptor.OK_OPTION) {
            return Bundle.OPTION_OK();
        }
        if (option instanceof Component) {
            return null;
        }
        if (option != null) {
            return option.toString();
        }
        return null;
    }

    private void mapDescriptorOptions() {
        Object[] options = this.descriptor.getOptions();
        if (options == null) {
            switch (this.descriptor.getOptionType()) {
                case -1: 
                case 2: {
                    options = OK_CANCEL;
                    break;
                }
                case 1: {
                    options = YES_NO_CANCEL;
                    break;
                }
                case 0: {
                    options = YES_NO;
                    break;
                }
                default: {
                    options = JUST_OK;
                }
            }
        }
        for (Object o : options) {
            String text = o instanceof JButton ? this.addButtonItem((JButton)o) : (o instanceof Icon ? this.addIconItem((Icon)o) : this.mapDescriptorOption(o));
            if (text != null) {
                this.addMessageItem(new MessageActionItem(Actions.cutAmpersand((String)text)), o);
                continue;
            }
            this.reportUnknownOption(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportUnknownOption(Object o) {
        Throwable t = new Throwable();
        StackTraceElement[] stack = t.getStackTrace();
        if (stack.length >= 7) {
            String callerClass = stack[6].getClassName();
            Set<String> set = warnedClasses;
            synchronized (set) {
                if (!warnedClasses.add(callerClass)) {
                    return;
                }
            }
        }
        LOG.log(Level.WARNING, new Throwable(), () -> "Unhandled option " + o + " for descriptor: " + this.descriptor);
    }

    private String addButtonItem(JButton button) {
        if (!button.isVisible()) {
            return null;
        }
        String t = button.getText();
        List<ActionListener> ll = Arrays.asList(button.getActionListeners());
        if (!ll.isEmpty()) {
            this.optionListeners.put(button, ll);
        }
        return t;
    }

    private String addIconItem(Icon icon) {
        if (icon instanceof AccessibleIcon) {
            return ((AccessibleIcon)((Object)icon)).getAccessibleIconDescription();
        }
        return null;
    }

    public Object clientNotify() {
        try {
            return this.clientNotifyLater().get();
        }
        catch (InterruptedException | ExecutionException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public CompletableFuture<Object> clientNotifyLater() {
        return ((CompletableFuture)this.clientNotifyCompletion().thenApply(d -> d.getValue())).exceptionally(t -> {
            if (t instanceof CompletionException) {
                t = t.getCause();
            }
            if (!(t instanceof CancellationException)) {
                LOG.log(Level.WARNING, "Exception occurred for {0}", this.descriptor);
                LOG.log(Level.WARNING, "Exception stacktrace", (Throwable)t);
            }
            return null;
        });
    }

    public <T extends NotifyDescriptor> CompletableFuture<T> clientNotifyCompletion() {
        if (this.descriptor instanceof NotifyDescriptor.InputLine) {
            NotifyDescriptor.InputLine inp = (NotifyDescriptor.InputLine)this.descriptor;
            ShowInputBoxParams params = new ShowInputBoxParams();
            params.setPrompt(this.descriptor.getTitle());
            params.setValue(inp.getInputText());
            params.setPassword(this.descriptor instanceof NotifyDescriptor.PasswordLine);
            CompletableFuture<String> newText = this.client.showInputBox(params);
            Ctrl ctrl = new Ctrl(newText);
            ((CompletableFuture)newText.thenAccept(item -> {
                if (item == null) {
                    this.descriptor.setValue(NotifyDescriptor.CLOSED_OPTION);
                    ctrl.completeExceptionally(new CancellationException());
                } else {
                    inp.setInputText(item);
                    this.descriptor.setValue(NotifyDescriptor.OK_OPTION);
                    ctrl.complete(this.descriptor);
                }
            })).exceptionally(t -> {
                if (t instanceof CompletionException) {
                    t = t.getCause();
                }
                ctrl.completeExceptionally((Throwable)t);
                return null;
            });
            return ctrl;
        }
        if (this.descriptor instanceof NotifyDescriptor.QuickPick) {
            NotifyDescriptor.QuickPick qp = (NotifyDescriptor.QuickPick)this.descriptor;
            HashMap<QuickPickItem, NotifyDescriptor.QuickPick.Item> items = new HashMap<QuickPickItem, NotifyDescriptor.QuickPick.Item>();
            for (NotifyDescriptor.QuickPick.Item item2 : qp.getItems()) {
                items.put(new QuickPickItem(item2.getLabel(), item2.getDescription(), null, item2.isSelected(), null), item2);
            }
            ShowQuickPickParams params = new ShowQuickPickParams(qp.getTitle(), qp.isMultipleSelection(), new ArrayList<QuickPickItem>(items.keySet()));
            CompletableFuture<List<QuickPickItem>> qpF = this.client.showQuickPick(params);
            Ctrl ctrl = new Ctrl(qpF);
            ((CompletableFuture)qpF.thenAccept(selected -> {
                if (selected == null) {
                    this.descriptor.setValue(NotifyDescriptor.CLOSED_OPTION);
                    ctrl.completeExceptionally(new CancellationException());
                } else {
                    for (Map.Entry entry : items.entrySet()) {
                        ((NotifyDescriptor.QuickPick.Item)entry.getValue()).setSelected(selected.contains(entry.getKey()));
                    }
                    this.descriptor.setValue(NotifyDescriptor.OK_OPTION);
                    ctrl.complete(this.descriptor);
                }
            })).exceptionally(t -> {
                if (t instanceof CompletionException) {
                    t = t.getCause();
                }
                ctrl.completeExceptionally((Throwable)t);
                return null;
            });
            return ctrl;
        }
        ShowMessageRequestParams params = this.createShowMessageRequest();
        if (params == null) {
            this.descriptor.setValue(NotifyDescriptor.CLOSED_OPTION);
            CompletableFuture<NotifyDescriptor> x = new CompletableFuture<NotifyDescriptor>();
            x.complete(this.descriptor);
            return x;
        }
        CompletableFuture<MessageActionItem> resultItem = this.client.showMessageRequest(this.request);
        Ctrl ctrl = new Ctrl(resultItem);
        ((CompletableFuture)((CompletableFuture)resultItem.thenApply(this::processActivatedOption)).thenAccept(o -> {
            this.descriptor.setValue(o);
            if (o == NotifyDescriptor.CLOSED_OPTION || o == NotifyDescriptor.CANCEL_OPTION) {
                ctrl.completeExceptionally(new CancellationException());
            } else {
                ctrl.complete(this.descriptor);
            }
        })).exceptionally(t -> {
            if (t instanceof CompletionException) {
                t = ((CompletionException)t).getCause();
            }
            ctrl.completeExceptionally((Throwable)t);
            return null;
        });
        return ctrl;
    }

    MessageActionItem handleClientException(Throwable t) {
        return null;
    }

    Object processActivatedOption(MessageActionItem item) {
        Object option = this.selectActivatedOption(item);
        List<ActionListener> ll = this.optionListeners.get(option);
        if (ll != null) {
            ActionEvent e = new ActionEvent(option, 1001, item.getTitle());
            for (ActionListener l : ll) {
                try {
                    l.actionPerformed(e);
                }
                catch (RuntimeException ex) {
                    LOG.log(Level.SEVERE, "Error occurred during actionListener dispatch", ex);
                }
            }
        }
        return option;
    }

    Object selectActivatedOption(MessageActionItem item) {
        if (item == null) {
            return NotifyDescriptor.CLOSED_OPTION;
        }
        Object option = this.item2Option.get(item);
        if (option == null) {
            option = this.text2Option.get(item.getTitle());
        }
        if (option == null) {
            LOG.log(Level.WARNING, "Unknown client response received: {0}, the valid options were: {1}", new Object[]{item.getTitle(), this.item2Option.keySet().stream().map(MessageActionItem::getTitle).collect(Collectors.toList())});
            return NotifyDescriptor.CLOSED_OPTION;
        }
        return option;
    }

    class Ctrl<T>
    extends CompletableFuture<T> {
        private final CompletableFuture clientFuture;

        public Ctrl(CompletableFuture clientFuture) {
            this.clientFuture = clientFuture;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            boolean b;
            boolean bl = b = !this.isDone();
            if (b) {
                Object v = NotifyDescriptorAdapter.this.descriptor.getValue();
                if (v != NotifyDescriptor.CANCEL_OPTION && v != NotifyDescriptor.CLOSED_OPTION) {
                    NotifyDescriptorAdapter.this.descriptor.setValue(NotifyDescriptor.CANCEL_OPTION);
                }
                b &= this.clientFuture.cancel(mayInterruptIfRunning);
            }
            return super.cancel(mayInterruptIfRunning) || b;
        }
    }
}

