/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.explorer;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lsp4j.jsonrpc.services.JsonSegment;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.LanguageClientAware;
import org.netbeans.modules.java.lsp.server.explorer.NodeLookupContextValues;
import org.netbeans.modules.java.lsp.server.explorer.PathFinder;
import org.netbeans.modules.java.lsp.server.explorer.TreeItem;
import org.netbeans.modules.java.lsp.server.explorer.TreeNodeRegistry;
import org.netbeans.modules.java.lsp.server.explorer.TreeNodeRegistryImpl;
import org.netbeans.modules.java.lsp.server.explorer.TreeViewProvider;
import org.netbeans.modules.java.lsp.server.explorer.api.ConfigureExplorerParams;
import org.netbeans.modules.java.lsp.server.explorer.api.CreateExplorerParams;
import org.netbeans.modules.java.lsp.server.explorer.api.FindPathParams;
import org.netbeans.modules.java.lsp.server.explorer.api.GetResourceParams;
import org.netbeans.modules.java.lsp.server.explorer.api.NodeChangedParams;
import org.netbeans.modules.java.lsp.server.explorer.api.NodeOperationParams;
import org.netbeans.modules.java.lsp.server.explorer.api.ResourceData;
import org.netbeans.modules.java.lsp.server.explorer.api.TreeViewService;
import org.netbeans.modules.java.lsp.server.protocol.NbCodeLanguageClient;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

@JsonSegment(value="nodes")
public class LspTreeViewServiceImpl
implements TreeViewService,
LanguageClientAware {
    private static final Logger LOG = Logger.getLogger(LspTreeViewServiceImpl.class.getName());
    private final Lookup sessionLookup;
    private final TreeNodeRegistryImpl treeService;
    private NbCodeLanguageClient langClient;

    public LspTreeViewServiceImpl(Lookup sessionLookup) {
        this.sessionLookup = sessionLookup;
        this.treeService = new TreeNodeRegistryImpl(sessionLookup){

            @Override
            protected void notifyItemChanged(NodeChangedParams itemId) {
                if (LspTreeViewServiceImpl.this.langClient != null) {
                    LOG.log(Level.FINER, "Firing item {0} changed", itemId);
                    LspTreeViewServiceImpl.this.langClient.notifyNodeChange(itemId);
                }
            }
        };
    }

    public TreeNodeRegistry getNodeRegistry() {
        return this.treeService;
    }

    public void connect(LanguageClient client) {
        this.langClient = (NbCodeLanguageClient)client;
    }

    @Override
    public CompletableFuture<Void> configure(ConfigureExplorerParams par) {
        TreeViewProvider tvp = this.treeService.providerOf(par.getRootNodeId());
        CompletableFuture<Void> f = new CompletableFuture<Void>();
        if (tvp == null) {
            f.completeExceptionally(new IllegalArgumentException("Invalid root ID: " + par.getRootNodeId()));
            return f;
        }
        try {
            NodeLookupContextValues vals = NodeLookupContextValues.nodeLookup(par.getExportClasses());
            tvp.setClientProvider(vals);
            f.complete(null);
        }
        catch (IllegalArgumentException ex) {
            f.completeExceptionally(ex);
        }
        return f;
    }

    public void nodesCollapsed(int parentId) {
        TreeViewProvider p = this.treeService.providerOf(parentId);
        p.childrenCollapsed(parentId);
    }

    public CompletableFuture<Boolean> nodesDelete(NodeOperationParams params) {
        int nodeId = params.getNodeId();
        CompletableFuture<Boolean> ret = new CompletableFuture<Boolean>();
        TreeViewProvider p = this.treeService.providerOf(nodeId);
        if (p == null) {
            ret.complete(false);
            return ret;
        }
        Node n = p.findNode(nodeId);
        if (n != null && n.canDestroy()) {
            try {
                n.destroy();
                ret.complete(true);
            }
            catch (IOException ex) {
                ret.completeExceptionally(ex);
            }
        } else {
            ret.complete(false);
        }
        return ret;
    }

    @Override
    public CompletableFuture<TreeItem> info(NodeOperationParams params) {
        int nodeId = params.getNodeId();
        LOG.log(Level.FINER, "> info({0})", nodeId);
        TreeViewProvider tvp = this.treeService.providerOf(nodeId);
        return tvp.getTreeItem(nodeId).toCompletableFuture();
    }

    @Override
    public CompletableFuture<TreeItem> explorerManager(CreateExplorerParams params) {
        String id = params.getExplorerId();
        return this.treeService.createProvider(id).thenCompose(tv -> tv.getRootInfo()).toCompletableFuture();
    }

    @Override
    public CompletableFuture<int[]> getChildren(NodeOperationParams params) {
        int id = params.getNodeId();
        LOG.log(Level.FINER, "> children({0})", id);
        TreeViewProvider tvp = this.treeService.providerOf(id);
        return tvp.getChildren(id).toCompletableFuture();
    }

    @Override
    public void notifyCollapsed(NodeOperationParams params) {
    }

    @Override
    public CompletableFuture<Boolean> delete(NodeOperationParams params) {
        Node n;
        int id = params.getNodeId();
        LOG.log(Level.FINER, "> delete({0})", id);
        TreeViewProvider tvp = this.treeService.providerOf(id);
        if (tvp != null && (n = tvp.findNode(id)) != null && n.canDestroy()) {
            return CompletableFuture.supplyAsync(() -> {
                try {
                    n.destroy();
                    return true;
                }
                catch (IOException ex) {
                    throw new CompletionException(ex);
                }
            });
        }
        return CompletableFuture.completedFuture(false);
    }

    @Override
    public CompletableFuture<ResourceData> getResource(GetResourceParams params) {
        URI uri = params.getUri();
        if (params.getAcceptEncodings() != null && !Arrays.asList(params.getAcceptEncodings()).contains("base64")) {
            throw new IllegalArgumentException("Base64 encoding must be accepted.");
        }
        return CompletableFuture.completedFuture(this.treeService.imageContents(uri));
    }

    @Override
    public CompletableFuture<int[]> findPath(FindPathParams params) {
        Object toSelect = params.getSelectData();
        LOG.log(Level.FINER, "> findPath(fromId = {0}, select = {1})", new Object[]{params.getRootNodeId(), toSelect});
        TreeViewProvider tvp = this.treeService.providerOf(params.getRootNodeId());
        if (tvp == null) {
            return null;
        }
        Node rootNode = tvp.getExplorerManager().getRootContext();
        for (PathFinder finder : tvp.getLookup().lookupAll(PathFinder.class)) {
            Node target = finder.findPath(rootNode, toSelect);
            if (target == null) continue;
            return this.constructPath(tvp, rootNode, target);
        }
        return CompletableFuture.completedFuture(null);
    }

    private static int[] toIntArray(List<Integer> wrappers) {
        int[] ret = new int[wrappers.size()];
        int idx = 0;
        for (Integer i : wrappers) {
            ret[idx++] = i;
        }
        return ret;
    }

    CompletableFuture<int[]> constructLevel(TreeViewProvider tvp, Node from, Node node, List<Integer> collectedIds) {
        if (node == null) {
            return CompletableFuture.completedFuture(null);
        }
        CompletionStage<Void> idStage = tvp.getNodeId(node).thenAccept(id -> collectedIds.add((Integer)id));
        CompletionStage levelStage = idStage.thenCompose(v -> {
            if (node == from) {
                Collections.reverse(collectedIds);
                return CompletableFuture.completedFuture(LspTreeViewServiceImpl.toIntArray(collectedIds));
            }
            return tvp.getParent(node).thenCompose(n -> this.constructLevel(tvp, from, (Node)n, collectedIds));
        });
        return levelStage.toCompletableFuture();
    }

    CompletableFuture<int[]> constructPath(TreeViewProvider tvp, Node from, Node to) {
        ArrayList<Integer> collectedIds = new ArrayList<Integer>();
        return this.constructLevel(tvp, from, to, collectedIds);
    }
}

