/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.modules.Places;
import org.openide.util.Exceptions;

public final class URITranslator {
    private static final URITranslator INSTANCE = new URITranslator();
    private final Map<String, String> uriFromCacheMap = new LRUCacheMap();
    private final Map<String, String> uriToCacheMap = new LRUCacheMap();

    public static URITranslator getDefault() {
        return INSTANCE;
    }

    public synchronized String uriToLSP(String lspUri) {
        return this.uriFromCacheMap.computeIfAbsent(lspUri, uri -> {
            FileObject file;
            URL url;
            URI uriUri = URI.create(uri);
            try {
                url = uriUri.toURL();
            }
            catch (MalformedURLException ex) {
                return uri;
            }
            if (FileUtil.isArchiveArtifact((URL)url)) {
                file = URLMapper.findFileObject((URL)url);
                if (file == null) {
                    return uri;
                }
                File cacheDir = URITranslator.getCacheDir();
                cacheDir.mkdirs();
                File segments = new File(cacheDir, "segments");
                Properties props = new Properties();
                try (FileInputStream in2 = new FileInputStream(segments);){
                    props.load(in2);
                }
                catch (IOException in2) {
                    // empty catch block
                }
                FileObject archive = FileUtil.getArchiveFile((FileObject)file);
                String archiveString = archive.toURL().toString();
                File foundSegment = null;
                for (String segment : props.stringPropertyNames()) {
                    if (!archiveString.equals(props.getProperty(segment))) continue;
                    foundSegment = new File(cacheDir, segment);
                    break;
                }
                if (foundSegment == null) {
                    int i = 0;
                    while (props.getProperty("s" + i) != null) {
                        ++i;
                    }
                    foundSegment = new File(cacheDir, "s" + i);
                    props.put("s" + i, archiveString);
                    try (FileOutputStream in = new FileOutputStream(segments);){
                        props.store(in, "");
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
                File cache = new File(foundSegment, FileUtil.getRelativePath((FileObject)FileUtil.getArchiveRoot((FileObject)archive), (FileObject)file));
                cache.getParentFile().mkdirs();
                if (file.isFolder()) {
                    if (cache.exists() && cache.isFile() && !cache.delete()) {
                        return uri;
                    }
                    cache.mkdir();
                    return cache.toURI().toString();
                }
                if (file.isData()) {
                    String string;
                    if (cache.exists() && cache.isDirectory()) {
                        FileUtil.toFileObject((File)cache).delete();
                    }
                    FileOutputStream out = new FileOutputStream(cache);
                    try {
                        ((OutputStream)out).write(file.asBytes());
                        string = cache.toURI().toString();
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                ((OutputStream)out).close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                    ((OutputStream)out).close();
                    return string;
                }
            }
            if (uriUri.getScheme().equals("nbfs")) {
                file = URLMapper.findFileObject((URL)url);
                if (file == null) {
                    return uri;
                }
                try {
                    String txt = file.asText("UTF-8");
                    try (OutputStream os = file.getOutputStream();){
                        os.write(txt.getBytes(StandardCharsets.UTF_8));
                    }
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                try {
                    uri = URLMapper.findURL((FileObject)file, (int)1).toURI().toString();
                }
                catch (URISyntaxException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            return uri;
        });
    }

    public synchronized String uriFromLSP(String nbUri) {
        return this.uriToCacheMap.computeIfAbsent(nbUri, uri -> {
            URI uriUri = URI.create(uri);
            File cacheDir = URITranslator.getCacheDir();
            URI relative = cacheDir.toURI().relativize(uriUri);
            if (relative == null) return uri;
            if (!new File(cacheDir, relative.toString()).canRead()) return uri;
            String segmentAndPath = relative.toString();
            int slash = segmentAndPath.indexOf(47);
            String segment = segmentAndPath.substring(0, slash);
            String path = segmentAndPath.substring(slash + 1);
            File segments = new File(cacheDir, "segments");
            Properties props = new Properties();
            try (FileInputStream in = new FileInputStream(segments);){
                props.load(in);
                String archiveUri = props.getProperty(segment);
                FileObject archive = URLMapper.findFileObject((URL)URI.create(archiveUri).toURL());
                archive = archive != null ? FileUtil.getArchiveRoot((FileObject)archive) : null;
                FileObject file = archive != null ? archive.getFileObject(path) : null;
                if (file == null) return uri;
                String string = file.toURI().toString();
                return string;
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            return uri;
        });
    }

    public static File getCacheDir() {
        return Places.getCacheSubfile((String)"java-server");
    }

    private static class LRUCacheMap
    extends LinkedHashMap<String, String> {
        private static final int MAX_SIZE = 2048;

        LRUCacheMap() {
            super(32, 0.75f, true);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, String> eldest) {
            return this.size() > 2048;
        }
    }
}

