/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.wizard.library;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import org.netbeans.spi.project.libraries.LibraryImplementation;

class VolumeContentModel
extends AbstractListModel {
    private LibraryImplementation impl;
    private String volumeType;
    private List content;

    public VolumeContentModel(LibraryImplementation impl, String volumeType) {
        this.impl = impl;
        this.volumeType = volumeType;
        List l = this.impl.getContent(volumeType);
        this.content = l != null ? new ArrayList(l) : new ArrayList();
    }

    @Override
    public int getSize() {
        return this.content.size();
    }

    @Override
    public Object getElementAt(int index) {
        if (index < 0 || index >= this.content.size()) {
            throw new IllegalArgumentException();
        }
        return this.content.get(index);
    }

    public void addResource(URL resource) {
        this.content.add(resource);
        int index = this.content.size() - 1;
        this.impl.setContent(this.volumeType, this.content);
        this.fireIntervalAdded(this, index, index);
    }

    public void removeResources(int[] indices) {
        for (int i = indices.length - 1; i >= 0; --i) {
            this.content.remove(indices[i]);
        }
        this.impl.setContent(this.volumeType, this.content);
        this.fireIntervalRemoved(this, indices[0], indices[indices.length - 1]);
    }

    public void moveUp(int[] indices) {
        for (int i = 0; i < indices.length; ++i) {
            Object value = this.content.remove(indices[i]);
            this.content.add(indices[i] - 1, value);
        }
        this.impl.setContent(this.volumeType, this.content);
        this.fireContentsChanged(this, indices[0] - 1, indices[indices.length - 1]);
    }

    public void moveDown(int[] indices) {
        for (int i = indices.length - 1; i >= 0; --i) {
            Object value = this.content.remove(indices[i]);
            this.content.add(indices[i] + 1, value);
        }
        this.impl.setContent(this.volumeType, this.content);
        this.fireContentsChanged(this, indices[0], indices[indices.length - 1] + 1);
    }
}

