/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.client;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.j2ee.dd.api.client.AppClient;
import org.netbeans.modules.j2ee.dd.api.client.DDProvider;
import org.netbeans.modules.j2ee.dd.api.common.RootInterface;
import org.netbeans.modules.j2ee.dd.impl.client.AppClientProxy;
import org.netbeans.modules.j2ee.dd.impl.client.ClientParseUtils;
import org.netbeans.modules.j2ee.dd.impl.common.DDUtils;
import org.netbeans.modules.j2ee.ddloaders.catalog.EnterpriseCatalog;
import org.netbeans.modules.j2ee.ddloaders.client.ClientDataLoader;
import org.netbeans.modules.j2ee.ddloaders.client.ClientDataNode;
import org.netbeans.modules.j2ee.ddloaders.client.DDChangeEvent;
import org.netbeans.modules.j2ee.ddloaders.client.DDChangeListener;
import org.netbeans.modules.j2ee.ddloaders.client.DDChangesPanel;
import org.netbeans.modules.j2ee.ddloaders.multiview.DDMultiViewDataObject;
import org.netbeans.modules.j2ee.ddloaders.web.DDDataObject;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.xml.multiview.XmlMultiViewDataObject;
import org.netbeans.modules.xml.multiview.XmlMultiViewElement;
import org.netbeans.spi.xml.cookies.CheckXMLSupport;
import org.netbeans.spi.xml.cookies.DataObjectAdapters;
import org.netbeans.spi.xml.cookies.ValidateXMLSupport;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataLoaderPool;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiFileLoader;
import org.openide.loaders.OperationAdapter;
import org.openide.loaders.OperationEvent;
import org.openide.loaders.OperationListener;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ClientDataObject
extends DDMultiViewDataObject
implements DDChangeListener,
ChangeListener,
PropertyChangeListener {
    private transient AppClient appClient;
    private transient FileObject[] srcRoots;
    private Vector<DDChangeEvent> updates;
    private transient RequestProcessor.Task updateTask;
    public static final String PROP_DOCUMENT_DTD = "documentDTD";
    private OperationListener operationListener = new OperationAdapter(){

        public void operationDelete(OperationEvent ev) {
        }
    };

    public ClientDataObject(FileObject pf, ClientDataLoader loader) throws DataObjectExistsException {
        super(pf, (MultiFileLoader)loader);
        this.init(pf, loader);
    }

    private void init(FileObject fo, ClientDataLoader loader) {
        InputSource in = DataObjectAdapters.inputSource((DataObject)this);
        CheckXMLSupport checkCookie = new CheckXMLSupport(in);
        this.getCookieSet().add((Node.Cookie)checkCookie);
        ValidateXMLSupport validateCookie = new ValidateXMLSupport(in);
        this.getCookieSet().add((Node.Cookie)validateCookie);
        Project project = FileOwnerQuery.getOwner((FileObject)this.getPrimaryFile());
        if (project != null) {
            Sources sources = ProjectUtils.getSources((Project)project);
            sources.addChangeListener((ChangeListener)this);
        }
        this.refreshSourceFolders();
        this.addPropertyChangeListener(this);
    }

    private void refreshSourceFolders() {
        ArrayList<FileObject> srcRootList = new ArrayList<FileObject>();
        Project project = FileOwnerQuery.getOwner((FileObject)this.getPrimaryFile());
        if (project != null) {
            Sources sources = ProjectUtils.getSources((Project)project);
            SourceGroup[] groups = sources.getSourceGroups("java");
            for (int i = 0; i < groups.length; ++i) {
                if (WebModule.getWebModule((FileObject)groups[i].getRootFolder()) == null) continue;
                srcRootList.add(groups[i].getRootFolder());
                DataLoaderPool.getDefault().removeOperationListener(this.operationListener);
                DataLoaderPool.getDefault().addOperationListener(this.operationListener);
            }
        }
        this.srcRoots = srcRootList.toArray(new FileObject[srcRootList.size()]);
    }

    protected String getEditorMimeType() {
        return "text/x-dd-client";
    }

    public static XmlMultiViewElement createXmlMultiViewElement(Lookup lookup) {
        return new XmlMultiViewElement((XmlMultiViewDataObject)lookup.lookup(XmlMultiViewDataObject.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deploymentChange(DDChangeEvent evt) {
        ClientDataObject clientDataObject = this;
        synchronized (clientDataObject) {
            if (this.updates == null) {
                this.updates = new Vector();
            }
            this.updates.addElement(evt);
        }
        if (this.updateTask == null) {
            this.updateTask = RequestProcessor.getDefault().post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Vector changes = null;
                    ClientDataObject clientDataObject = ClientDataObject.this;
                    synchronized (clientDataObject) {
                        if (!ClientDataObject.this.isValid()) {
                            return;
                        }
                        if (ClientDataObject.this.updates != null) {
                            changes = ClientDataObject.this.updates;
                            ClientDataObject.this.updates = null;
                        }
                    }
                    if (changes != null) {
                        ClientDataObject.this.showDDChangesDialog(changes);
                    }
                }
            }, 2000, 1);
        } else {
            this.updateTask.schedule(2000);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.refreshSourceFolders();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("document_valid".equals(evt.getPropertyName())) {
            ((ClientDataNode)this.getNodeDelegate()).iconChanged();
        }
    }

    protected String getPrefixMark() {
        return "<application-client";
    }

    @Override
    protected void validateDocument() throws IOException {
        this.parseDocument(false);
    }

    @Override
    protected void parseDocument() throws IOException {
        block3: {
            if (this.appClient == null || ((AppClientProxy)this.appClient).getOriginal() == null) {
                try {
                    this.appClient = DDProvider.getDefault().getDDRoot(this.getPrimaryFile());
                }
                catch (IOException e) {
                    if (this.appClient != null) break block3;
                    this.appClient = new AppClientProxy(null, null);
                }
            }
        }
        this.parseDocument(true);
    }

    @Override
    protected boolean isModelCreated() {
        return this.appClient != null && ((AppClientProxy)this.appClient).getOriginal() != null;
    }

    @Override
    protected boolean isDocumentParseable() {
        return 2 != this.getAppClient().getStatus();
    }

    @Override
    protected RootInterface getDDModel() {
        return this.getAppClient();
    }

    protected Node createNodeDelegate() {
        return new ClientDataNode(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showDDChangesDialog(List changes) {
        final Dialog[] confirmChangesDialog = new Dialog[]{null};
        final JButton processButton = new JButton(NbBundle.getMessage(DDDataObject.class, (String)"LAB_processButton"));
        processButton.setMnemonic(NbBundle.getMessage(DDDataObject.class, (String)"LAB_processButton_Mnemonic").charAt(0));
        processButton.setToolTipText(NbBundle.getMessage(DDDataObject.class, (String)"ACS_processButtonA11yDesc"));
        JButton processAllButton = new JButton(NbBundle.getMessage(DDDataObject.class, (String)"LAB_processAllButton"));
        processAllButton.setMnemonic(NbBundle.getMessage(DDDataObject.class, (String)"LAB_processAllButton_Mnemonic").charAt(0));
        processAllButton.setToolTipText(NbBundle.getMessage(DDDataObject.class, (String)"ACS_processAllButtonA11yDesc"));
        JButton closeButton = new JButton(NbBundle.getMessage(DDDataObject.class, (String)"LAB_closeButton"));
        closeButton.setMnemonic(NbBundle.getMessage(DDDataObject.class, (String)"LAB_closeButton_Mnemonic").charAt(0));
        closeButton.setToolTipText(NbBundle.getMessage(DDDataObject.class, (String)"ACS_closeButtonA11yDesc"));
        final Object[] options = new Object[]{processButton, processAllButton};
        final Object[] additionalOptions = new Object[]{closeButton};
        WebModule wm = WebModule.getWebModule((FileObject)this.getPrimaryFile());
        String fsname = "";
        if (wm != null) {
            fsname = wm.getContextPath();
        }
        String caption = NbBundle.getMessage(DDDataObject.class, (String)"MSG_SynchronizeCaption", (Object)fsname);
        final DDChangesPanel connectionPanel = new DDChangesPanel(caption, processButton);
        DialogDescriptor confirmChangesDescriptor = new DialogDescriptor((Object)connectionPanel, NbBundle.getMessage(DDDataObject.class, (String)"LAB_ConfirmDialog"), true, options, (Object)processButton, 1, HelpCtx.DEFAULT_HELP, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Component root;
                if (e.getSource() instanceof Component && !(root = SwingUtilities.getRoot((Component)e.getSource())).isDisplayable()) {
                    return;
                }
                if (options[0].equals(e.getSource())) {
                    int max;
                    int min = connectionPanel.changesList.getMinSelectionIndex();
                    for (int i = max = connectionPanel.changesList.getMaxSelectionIndex(); i >= min; --i) {
                        if (!connectionPanel.changesList.isSelectedIndex(i)) continue;
                        DDChangeEvent ev = (DDChangeEvent)connectionPanel.listModel.getElementAt(i);
                        ClientDataObject.this.processDDChangeEvent(ev);
                        connectionPanel.listModel.removeElementAt(i);
                    }
                    if (connectionPanel.listModel.isEmpty()) {
                        confirmChangesDialog[0].setVisible(false);
                    } else {
                        processButton.setEnabled(false);
                    }
                } else if (options[1].equals(e.getSource())) {
                    Enumeration en = connectionPanel.listModel.elements();
                    while (en.hasMoreElements()) {
                        ClientDataObject.this.processDDChangeEvent((DDChangeEvent)en.nextElement());
                    }
                    confirmChangesDialog[0].setVisible(false);
                    connectionPanel.setChanges(null);
                } else if (additionalOptions[0].equals(e.getSource())) {
                    confirmChangesDialog[0].setVisible(false);
                    connectionPanel.setChanges(null);
                }
            }
        });
        confirmChangesDescriptor.setAdditionalOptions(additionalOptions);
        processButton.setEnabled(false);
        processAllButton.requestFocus();
        connectionPanel.setChanges(changes);
        try {
            confirmChangesDialog[0] = DialogDisplayer.getDefault().createDialog(confirmChangesDescriptor);
            confirmChangesDialog[0].setVisible(true);
        }
        finally {
            confirmChangesDialog[0].dispose();
        }
    }

    private void processDDChangeEvent(DDChangeEvent evt) {
        System.err.println("ClientDataObject.processDDChangeEvent");
        if (!this.isValid()) {
            return;
        }
    }

    private void parseDocument(boolean updateWebApp) throws IOException {
        AppClientProxy webAppProxy = (AppClientProxy)this.appClient;
        try {
            SAXParseException error = ClientParseUtils.parse((InputSource)new InputSource(this.createReader()), (EntityResolver)new EnterpriseCatalog());
            this.setSaxError(error);
            String version = ClientParseUtils.getVersion((InputSource)new InputSource(this.createReader()));
            AppClientProxy app = new AppClientProxy(DDUtils.createAppClient((InputStream)this.createInputStream(), (String)version), version);
            if (updateWebApp) {
                String webAppProxyVersion;
                String string = webAppProxyVersion = webAppProxy.getVersion() != null ? webAppProxy.getVersion().toString() : "";
                if (version.equals(webAppProxyVersion) && webAppProxy.getOriginal() != null) {
                    this.appClient.merge((RootInterface)app, 3);
                } else if (app.getOriginal() != null) {
                    webAppProxy = app;
                    this.appClient = webAppProxy;
                }
            }
            webAppProxy.setStatus(error != null ? 1 : 0);
            webAppProxy.setError(error);
        }
        catch (SAXException ex) {
            webAppProxy.setStatus(2);
            if (ex instanceof SAXParseException) {
                webAppProxy.setError((SAXParseException)ex);
            } else if (ex.getException() instanceof SAXParseException) {
                webAppProxy.setError((SAXParseException)ex.getException());
            }
            this.setSaxError(ex);
        }
    }

    public AppClient getAppClient() {
        if (this.appClient == null) {
            try {
                this.appClient = this.createWebApp();
            }
            catch (IOException ex) {
                Logger.getLogger("global").log(Level.INFO, null, ex);
            }
        }
        return this.appClient;
    }

    private AppClient createWebApp() throws IOException {
        AppClient webApp = DDProvider.getDefault().getDDRoot(this.getPrimaryFile());
        if (webApp != null) {
            this.setSaxError(webApp.getError());
        }
        return webApp;
    }
}

