/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryparser.xml.builders;

import org.apache.lucene.queryparser.xml.DOMUtils;
import org.apache.lucene.queryparser.xml.ParserException;
import org.apache.lucene.queryparser.xml.QueryBuilder;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.w3c.dom.Element;

public class NumericRangeQueryBuilder
implements QueryBuilder {
    @Override
    public Query getQuery(Element e) throws ParserException {
        String field = DOMUtils.getAttributeWithInheritanceOrFail(e, "fieldName");
        String lowerTerm = DOMUtils.getAttribute(e, "lowerTerm", null);
        String upperTerm = DOMUtils.getAttribute(e, "upperTerm", null);
        boolean lowerInclusive = DOMUtils.getAttribute(e, "includeLower", true);
        boolean upperInclusive = DOMUtils.getAttribute(e, "includeUpper", true);
        int precisionStep = DOMUtils.getAttribute(e, "precisionStep", 16);
        String type = DOMUtils.getAttribute(e, "type", "int");
        try {
            NumericRangeQuery filter;
            if (type.equalsIgnoreCase("int")) {
                filter = NumericRangeQuery.newIntRange((String)field, (int)precisionStep, (Integer)(lowerTerm == null ? null : Integer.valueOf(lowerTerm)), (Integer)(upperTerm == null ? null : Integer.valueOf(upperTerm)), (boolean)lowerInclusive, (boolean)upperInclusive);
            } else if (type.equalsIgnoreCase("long")) {
                filter = NumericRangeQuery.newLongRange((String)field, (int)precisionStep, (Long)(lowerTerm == null ? null : Long.valueOf(lowerTerm)), (Long)(upperTerm == null ? null : Long.valueOf(upperTerm)), (boolean)lowerInclusive, (boolean)upperInclusive);
            } else if (type.equalsIgnoreCase("double")) {
                filter = NumericRangeQuery.newDoubleRange((String)field, (int)precisionStep, (Double)(lowerTerm == null ? null : Double.valueOf(lowerTerm)), (Double)(upperTerm == null ? null : Double.valueOf(upperTerm)), (boolean)lowerInclusive, (boolean)upperInclusive);
            } else if (type.equalsIgnoreCase("float")) {
                filter = NumericRangeQuery.newFloatRange((String)field, (int)precisionStep, (Float)(lowerTerm == null ? null : Float.valueOf(lowerTerm)), (Float)(upperTerm == null ? null : Float.valueOf(upperTerm)), (boolean)lowerInclusive, (boolean)upperInclusive);
            } else {
                throw new ParserException("type attribute must be one of: [long, int, double, float]");
            }
            return filter;
        }
        catch (NumberFormatException nfe) {
            throw new ParserException("Could not parse lowerTerm or upperTerm into a number", nfe);
        }
    }
}

