/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.web;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.AnnotatedBeanDefinitionReader;
import org.springframework.test.context.ContextConfigurationAttributes;
import org.springframework.test.context.support.AnnotationConfigContextLoaderUtils;
import org.springframework.test.context.web.AbstractGenericWebContextLoader;
import org.springframework.test.context.web.WebMergedContextConfiguration;
import org.springframework.util.ObjectUtils;
import org.springframework.web.context.support.GenericWebApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationConfigWebContextLoader
extends AbstractGenericWebContextLoader {
    private static final Log logger = LogFactory.getLog(AnnotationConfigWebContextLoader.class);

    @Override
    public void processContextConfiguration(ContextConfigurationAttributes configAttributes) {
        if (ObjectUtils.isEmpty((Object[])configAttributes.getClasses()) && this.isGenerateDefaultLocations()) {
            Class<?>[] defaultConfigClasses = this.detectDefaultConfigurationClasses(configAttributes.getDeclaringClass());
            configAttributes.setClasses(defaultConfigClasses);
        }
    }

    protected Class<?>[] detectDefaultConfigurationClasses(Class<?> declaringClass) {
        return AnnotationConfigContextLoaderUtils.detectDefaultConfigurationClasses(declaringClass);
    }

    @Override
    protected String[] modifyLocations(Class<?> clazz, String ... locations) {
        throw new UnsupportedOperationException("AnnotationConfigWebContextLoader does not support the modifyLocations(Class, String...) method");
    }

    @Override
    protected String[] generateDefaultLocations(Class<?> clazz) {
        throw new UnsupportedOperationException("AnnotationConfigWebContextLoader does not support the generateDefaultLocations(Class) method");
    }

    @Override
    protected String getResourceSuffix() {
        throw new UnsupportedOperationException("AnnotationConfigWebContextLoader does not support the getResourceSuffix() method");
    }

    @Override
    protected void loadBeanDefinitions(GenericWebApplicationContext context, WebMergedContextConfiguration webMergedConfig) {
        Object[] annotatedClasses = webMergedConfig.getClasses();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Registering annotated classes: " + ObjectUtils.nullSafeToString((Object[])annotatedClasses)));
        }
        new AnnotatedBeanDefinitionReader((BeanDefinitionRegistry)context).register((Class[])annotatedClasses);
    }
}

