/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.parser;

import com.sun.tools.javac.parser.JavaTokenizer;
import com.sun.tools.javac.parser.ScannerFactory;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.util.Position;
import java.nio.CharBuffer;
import java.util.Arrays;
import java.util.regex.Pattern;

public class JavadocTokenizer
extends JavaTokenizer {
    final ScannerFactory fac;

    protected JavadocTokenizer(ScannerFactory fac, CharBuffer cb) {
        super(fac, cb);
        this.fac = fac;
    }

    protected JavadocTokenizer(ScannerFactory fac, char[] array, int length) {
        super(fac, array, length);
        this.fac = fac;
    }

    @Override
    protected Tokens.Comment processComment(int pos, int endPos, Tokens.Comment.CommentStyle style) {
        char[] buf = this.getRawCharacters(pos, endPos);
        return new JavadocComment(style, this.fac, buf, pos);
    }

    @Override
    public Position.LineMap getLineMap() {
        char[] buf = this.getRawCharacters();
        return Position.makeLineMap(buf, buf.length, true);
    }

    protected static class JavadocComment
    extends JavaTokenizer.BasicComment {
        private static final Pattern DEPRECATED_PATTERN = Pattern.compile("(?sm).*^\\s*@deprecated( |$).*");
        private String docComment = null;
        private final StringBuilder sb;
        OffsetMap offsetMap = new OffsetMap();

        JavadocComment(Tokens.Comment.CommentStyle cs, ScannerFactory sf, char[] array, int offset) {
            super(cs, sf, array, offset);
            this.sb = new StringBuilder();
        }

        protected void put(char ch) {
            this.offsetMap.add(this.sb.length(), this.offsetPosition());
            this.sb.append(ch);
        }

        protected void putCodePoint(int codePoint) {
            this.offsetMap.add(this.sb.length(), this.offsetPosition());
            this.sb.appendCodePoint(codePoint);
        }

        protected void put() {
            if (this.isSurrogate()) {
                this.putCodePoint(this.getCodepoint());
            } else {
                this.put(this.get());
            }
        }

        @Override
        public String getText() {
            if (!this.scanned && this.cs == Tokens.Comment.CommentStyle.JAVADOC) {
                this.scanDocComment();
            }
            return this.docComment;
        }

        @Override
        public int getSourcePos(int pos) {
            if (pos == -1) {
                return -1;
            }
            if (pos < 0 || pos > this.docComment.length()) {
                throw new StringIndexOutOfBoundsException(String.valueOf(pos));
            }
            return this.offsetMap.getSourcePos(pos);
        }

        @Override
        protected void scanDocComment() {
            try {
                boolean firstLine = true;
                this.accept("/*");
                this.skip('*');
                if (this.is('/')) {
                    this.docComment = "";
                    return;
                }
                if (this.isOneOf('\n', '\r')) {
                    this.accept('\r');
                    this.accept('\n');
                    firstLine = false;
                }
                block4: while (this.isAvailable()) {
                    int begin_pos = this.position();
                    this.skipWhitespace();
                    if (this.is('*')) {
                        this.skip('*');
                        if (this.accept('/')) {
                            break;
                        }
                    } else if (!firstLine) {
                        this.reset(begin_pos);
                    }
                    while (this.isAvailable()) {
                        if (this.accept("*/")) break block4;
                        if (this.isOneOf('\n', '\r')) {
                            this.put('\n');
                            this.accept('\r');
                            this.accept('\n');
                            break;
                        }
                        if (this.is('\f')) {
                            this.next();
                            break;
                        }
                        this.put();
                        this.next();
                    }
                    firstLine = false;
                }
                if (this.sb.length() > 0) {
                    int i;
                    for (i = this.sb.length() - 1; i > -1 && this.sb.charAt(i) == '*'; --i) {
                    }
                    this.sb.setLength(i + 1);
                    this.docComment = this.sb.toString();
                } else {
                    this.docComment = "";
                }
            }
            finally {
                this.scanned = true;
                if (this.docComment != null && DEPRECATED_PATTERN.matcher(this.docComment).matches()) {
                    this.deprecatedFlag = true;
                }
            }
        }
    }

    static class OffsetMap {
        private static final int SB_OFFSET = 0;
        private static final int POS_OFFSET = 1;
        private static final int NOFFSETS = 2;
        private int[] map = new int[128];
        private int size = 0;

        OffsetMap() {
        }

        boolean shouldAdd(int sbOffset, int posOffset) {
            return sbOffset - this.lastSBOffset() != posOffset - this.lastPosOffset();
        }

        void add(int sbOffset, int posOffset) {
            if (this.size == 0 || this.shouldAdd(sbOffset, posOffset)) {
                this.ensure(2);
                this.map[this.size + 0] = sbOffset;
                this.map[this.size + 1] = posOffset;
                this.size += 2;
            }
        }

        private int lastSBOffset() {
            return this.size == 0 ? 0 : this.map[this.size - 2 + 0];
        }

        private int lastPosOffset() {
            return this.size == 0 ? 0 : this.map[this.size - 2 + 1];
        }

        private void ensure(int need) {
            int grow;
            need += this.size;
            for (grow = this.map.length; need > grow; grow <<= 1) {
            }
            if (grow < this.map.length) {
                throw new IndexOutOfBoundsException();
            }
            if (grow != this.map.length) {
                this.map = Arrays.copyOf(this.map, grow);
            }
        }

        int getSourcePos(int pos) {
            if (this.size == 0) {
                return -1;
            }
            int start = 0;
            int end = this.size / 2;
            while (start < end - 1) {
                int index = (start + end) / 2;
                int indexScaled = index * 2;
                if (this.map[indexScaled + 0] < pos) {
                    start = index;
                    continue;
                }
                if (this.map[indexScaled + 0] == pos) {
                    return this.map[indexScaled + 1];
                }
                end = index;
            }
            int startScaled = start * 2;
            return this.map[startScaled + 1] + (pos - this.map[startScaled + 0]);
        }
    }
}

