/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.object;

import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.object.CoreLocations;
import com.oracle.truffle.object.DynamicObjectImpl;
import com.oracle.truffle.object.LocationImpl;
import com.oracle.truffle.object.ObjectStorageOptions;
import com.oracle.truffle.object.ShapeImpl;
import java.io.PrintStream;

public class DynamicObjectBasic
extends DynamicObjectImpl {
    private long primitive1;
    private long primitive2;
    private long primitive3;
    private Object object1;
    private Object object2;
    private Object object3;
    private Object object4;
    private Object[] objext;
    private long[] primext;
    static final BasicObjectFieldLocation[] OBJECT_FIELD_LOCATIONS;
    static final BasicLongFieldLocation[] PRIMITIVE_FIELD_LOCATIONS;
    static final BasicObjectFieldLocation OBJECT_ARRAY_LOCATION;
    static final BasicObjectFieldLocation PRIMITIVE_ARRAY_LOCATION;

    protected DynamicObjectBasic(Shape shape) {
        super(shape);
    }

    @Override
    protected final void initialize(Shape shape) {
        assert (this.getObjectStore(shape) == null);
        int capacity = ((ShapeImpl)shape).getObjectArrayCapacity();
        if (capacity != 0) {
            this.setObjectStore(new Object[capacity], shape);
        }
        if (((ShapeImpl)shape).getPrimitiveArrayCapacity() != 0) {
            this.setPrimitiveStore(new long[((ShapeImpl)shape).getPrimitiveArrayCapacity()], shape);
        }
    }

    @Override
    protected final void growObjectStore(Shape oldShape, Shape newShape) {
        int newObjectArrayCapacity;
        int oldObjectArrayCapacity = ((ShapeImpl)oldShape).getObjectArrayCapacity();
        if (oldObjectArrayCapacity != (newObjectArrayCapacity = ((ShapeImpl)newShape).getObjectArrayCapacity())) {
            this.growObjectStoreIntl(oldObjectArrayCapacity, newObjectArrayCapacity, oldShape);
        }
    }

    private void growObjectStoreIntl(int oldObjectArrayCapacity, int newObjectArrayCapacity, Shape newShape) {
        Object[] newObjectStore = new Object[newObjectArrayCapacity];
        if (oldObjectArrayCapacity != 0) {
            assert (oldObjectArrayCapacity < newObjectArrayCapacity);
            Object[] oldObjectStore = this.getObjectStore(newShape);
            for (int i = 0; i < oldObjectArrayCapacity; ++i) {
                newObjectStore[i] = oldObjectStore[i];
            }
        }
        this.setObjectStore(newObjectStore, newShape);
    }

    @Override
    protected final void growPrimitiveStore(Shape oldShape, Shape newShape) {
        assert (((ShapeImpl)newShape).hasPrimitiveArray());
        int oldPrimitiveCapacity = ((ShapeImpl)oldShape).getPrimitiveArrayCapacity();
        int newPrimitiveCapacity = ((ShapeImpl)newShape).getPrimitiveArrayCapacity();
        if (newPrimitiveCapacity == 0) {
            this.setPrimitiveStore(null, newShape);
        } else if (oldPrimitiveCapacity != newPrimitiveCapacity) {
            this.growPrimitiveStoreIntl(oldPrimitiveCapacity, newPrimitiveCapacity, oldShape);
        }
    }

    private void growPrimitiveStoreIntl(int oldPrimitiveCapacity, int newPrimitiveCapacity, Shape newShape) {
        long[] newPrimitiveArray = new long[newPrimitiveCapacity];
        if (oldPrimitiveCapacity != 0) {
            long[] oldPrimitiveArray = this.getPrimitiveStore(newShape);
            for (int i = 0; i < Math.min(oldPrimitiveCapacity, newPrimitiveCapacity); ++i) {
                newPrimitiveArray[i] = oldPrimitiveArray[i];
            }
        }
        this.setPrimitiveStore(newPrimitiveArray, newShape);
    }

    @Override
    protected final void resizeObjectStore(Shape oldShape, Shape newShape) {
        Object[] newObjectStore = null;
        int destinationCapacity = ((ShapeImpl)newShape).getObjectArrayCapacity();
        if (destinationCapacity != 0) {
            newObjectStore = new Object[destinationCapacity];
            int sourceCapacity = ((ShapeImpl)oldShape).getObjectArrayCapacity();
            if (sourceCapacity != 0) {
                Object[] oldObjectStore = this.getObjectStore(newShape);
                for (int i = 0; i < Math.min(sourceCapacity, destinationCapacity); ++i) {
                    newObjectStore[i] = oldObjectStore[i];
                }
            }
        }
        this.setObjectStore(newObjectStore, newShape);
    }

    private Object[] getObjectStore(Shape currentShape) {
        return this.objext;
    }

    private void setObjectStore(Object[] newArray, Shape currentShape) {
        this.objext = newArray;
    }

    private long[] getPrimitiveStore(Shape currentShape) {
        return this.primext;
    }

    private void setPrimitiveStore(long[] newArray, Shape currentShape) {
        this.primext = newArray;
    }

    @Override
    protected final void resizePrimitiveStore(Shape oldShape, Shape newShape) {
        assert (((ShapeImpl)newShape).hasPrimitiveArray());
        long[] newPrimitiveArray = null;
        int destinationCapacity = ((ShapeImpl)newShape).getPrimitiveArrayCapacity();
        if (destinationCapacity != 0) {
            newPrimitiveArray = new long[destinationCapacity];
            int sourceCapacity = ((ShapeImpl)oldShape).getPrimitiveArrayCapacity();
            if (sourceCapacity != 0) {
                long[] oldPrimitiveArray = this.getPrimitiveStore(newShape);
                for (int i = 0; i < Math.min(sourceCapacity, destinationCapacity); ++i) {
                    newPrimitiveArray[i] = oldPrimitiveArray[i];
                }
            }
        }
        this.setPrimitiveStore(newPrimitiveArray, newShape);
    }

    private boolean checkSetShape(Shape oldShape, Shape newShape) {
        Shape currentShape = this.getShape();
        assert (oldShape != newShape) : "Wrong old shape assumption?";
        assert (newShape != currentShape) : "Redundant shape change? shape=" + currentShape;
        assert (oldShape == currentShape || oldShape.getParent() == currentShape) : "Out-of-order shape change?\nparentShape=" + currentShape + "\noldShape=" + oldShape + "\nnewShape=" + newShape;
        return true;
    }

    @Override
    protected final boolean checkExtensionArrayInvariants(Shape newShape) {
        assert (this.getShape() == newShape);
        assert (this.getObjectStore(newShape) == null && ((ShapeImpl)newShape).getObjectArrayCapacity() == 0 || this.getObjectStore(newShape) != null && this.getObjectStore(newShape).length == ((ShapeImpl)newShape).getObjectArrayCapacity());
        if (((ShapeImpl)newShape).hasPrimitiveArray()) assert (this.getPrimitiveStore(newShape) == null && ((ShapeImpl)newShape).getPrimitiveArrayCapacity() == 0 || this.getPrimitiveStore(newShape) != null && this.getPrimitiveStore(newShape).length == ((ShapeImpl)newShape).getPrimitiveArrayCapacity());
        return true;
    }

    @Override
    protected final DynamicObject cloneWithShape(Shape currentShape) {
        assert (this.getShape() == currentShape);
        DynamicObjectBasic clone = (DynamicObjectBasic)super.clone();
        if (this.getObjectStore(currentShape) != null) {
            clone.setObjectStore((Object[])this.getObjectStore(currentShape).clone(), currentShape);
        }
        if (((ShapeImpl)currentShape).hasPrimitiveArray() && this.getPrimitiveStore(currentShape) != null) {
            clone.setPrimitiveStore((long[])this.getPrimitiveStore(currentShape).clone(), currentShape);
        }
        return clone;
    }

    @Override
    protected final void reshape(ShapeImpl newShape) {
        ShapeImpl oldShape = (ShapeImpl)this.getShape();
        ShapeImpl commonAncestor = ShapeImpl.findCommonAncestor(oldShape, newShape);
        if (ObjectStorageOptions.TraceReshape) {
            int limit = 200;
            PrintStream out = System.out;
            out.printf("RESHAPE\nOLD %s\nNEW %s\nLCA %s\nDIFF %s\n---\n", oldShape.toStringLimit(limit), newShape.toStringLimit(limit), commonAncestor.toStringLimit(limit), ShapeImpl.diff(oldShape, newShape));
        }
        DynamicObject original = this.cloneWithShape(oldShape);
        this.setShapeAndGrow(oldShape, newShape);
        assert (!newShape.hasPrimitiveArray() || newShape.getPrimitiveArrayCapacity() != 0 || this.getPrimitiveStore(newShape) == null);
        this.copyProperties(original, commonAncestor);
        assert (this.checkExtensionArrayInvariants(newShape));
    }

    static /* synthetic */ Object[] access$702(DynamicObjectBasic x0, Object[] x1) {
        x0.objext = x1;
        return x1;
    }

    static /* synthetic */ long[] access$802(DynamicObjectBasic x0, long[] x1) {
        x0.primext = x1;
        return x1;
    }

    static {
        int index = 0;
        PRIMITIVE_FIELD_LOCATIONS = new BasicLongFieldLocation[]{new BasicLongFieldLocation(index++){

            @Override
            public long getLong(DynamicObject store, boolean condition) {
                return ((DynamicObjectBasic)store).primitive1;
            }

            @Override
            public void setLong(DynamicObject store, long value, boolean condition) {
                ((DynamicObjectBasic)store).primitive1 = value;
            }
        }, new BasicLongFieldLocation(index++){

            @Override
            public long getLong(DynamicObject store, boolean condition) {
                return ((DynamicObjectBasic)store).primitive2;
            }

            @Override
            public void setLong(DynamicObject store, long value, boolean condition) {
                ((DynamicObjectBasic)store).primitive2 = value;
            }
        }, new BasicLongFieldLocation(index++){

            @Override
            public long getLong(DynamicObject store, boolean condition) {
                return ((DynamicObjectBasic)store).primitive3;
            }

            @Override
            public void setLong(DynamicObject store, long value, boolean condition) {
                ((DynamicObjectBasic)store).primitive3 = value;
            }
        }};
        index = 0;
        OBJECT_FIELD_LOCATIONS = new BasicObjectFieldLocation[]{new BasicObjectFieldLocation(index++){

            @Override
            public Object get(DynamicObject store, boolean condition) {
                return ((DynamicObjectBasic)store).object1;
            }

            @Override
            public void setInternal(DynamicObject store, Object value, boolean condition) {
                ((DynamicObjectBasic)store).object1 = value;
            }
        }, new BasicObjectFieldLocation(index++){

            @Override
            public Object get(DynamicObject store, boolean condition) {
                return ((DynamicObjectBasic)store).object2;
            }

            @Override
            public void setInternal(DynamicObject store, Object value, boolean condition) {
                ((DynamicObjectBasic)store).object2 = value;
            }
        }, new BasicObjectFieldLocation(index++){

            @Override
            public Object get(DynamicObject store, boolean condition) {
                return ((DynamicObjectBasic)store).object3;
            }

            @Override
            public void setInternal(DynamicObject store, Object value, boolean condition) {
                ((DynamicObjectBasic)store).object3 = value;
            }
        }, new BasicObjectFieldLocation(index++){

            @Override
            public Object get(DynamicObject store, boolean condition) {
                return ((DynamicObjectBasic)store).object4;
            }

            @Override
            public void setInternal(DynamicObject store, Object value, boolean condition) {
                ((DynamicObjectBasic)store).object4 = value;
            }
        }};
        OBJECT_ARRAY_LOCATION = new BasicObjectFieldLocation(index++){

            public Object[] get(DynamicObject store, boolean condition) {
                return ((DynamicObjectBasic)store).objext;
            }

            @Override
            public void setInternal(DynamicObject store, Object value, boolean condition) {
                DynamicObjectBasic.access$702((DynamicObjectBasic)store, (Object[])value);
            }
        };
        PRIMITIVE_ARRAY_LOCATION = new BasicObjectFieldLocation(index++){

            public long[] get(DynamicObject store, boolean condition) {
                return ((DynamicObjectBasic)store).primext;
            }

            @Override
            public void setInternal(DynamicObject store, Object value, boolean condition) {
                DynamicObjectBasic.access$802((DynamicObjectBasic)store, (long[])value);
            }
        };
    }

    static abstract class BasicObjectFieldLocation
    extends CoreLocations.SimpleObjectFieldLocation {
        protected BasicObjectFieldLocation(int index) {
            super(index);
        }

        @Override
        public final Class<? extends DynamicObject> getDeclaringClass() {
            return DynamicObjectBasic.class;
        }
    }

    static abstract class BasicLongFieldLocation
    extends CoreLocations.SimpleLongFieldLocation {
        protected BasicLongFieldLocation(int index) {
            super(index);
        }

        @Override
        public final Class<? extends DynamicObject> getDeclaringClass() {
            return DynamicObjectBasic.class;
        }

        @Override
        public final int primitiveFieldCount() {
            return 1;
        }

        @Override
        public final void accept(LocationImpl.LocationVisitor locationVisitor) {
            locationVisitor.visitPrimitiveField(this.getIndex(), 1);
        }
    }
}

