/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.literal;

import com.oracle.truffle.regex.RegexLanguage;
import com.oracle.truffle.regex.literal.LiteralRegexExecRootNode;
import com.oracle.truffle.regex.tregex.parser.ast.RegexAST;
import com.oracle.truffle.regex.tregex.parser.ast.visitors.PreCalcResultVisitor;

public final class LiteralRegexEngine {
    public static LiteralRegexExecRootNode createNode(RegexLanguage language, RegexAST ast) {
        if (ast.isLiteralString()) {
            return LiteralRegexEngine.createLiteralNode(language, ast);
        }
        return null;
    }

    private static LiteralRegexExecRootNode createLiteralNode(RegexLanguage language, RegexAST ast) {
        PreCalcResultVisitor preCalcResultVisitor = PreCalcResultVisitor.run(ast, true);
        boolean caret = ast.getRoot().startsWithCaret();
        boolean dollar = ast.getRoot().endsWithDollar();
        if (ast.getRoot().getMinPath() == 0) {
            if (caret) {
                if (dollar) {
                    return new LiteralRegexExecRootNode.EmptyEquals(language, ast, preCalcResultVisitor);
                }
                return new LiteralRegexExecRootNode.EmptyStartsWith(language, ast, preCalcResultVisitor);
            }
            if (dollar) {
                return new LiteralRegexExecRootNode.EmptyEndsWith(language, ast, preCalcResultVisitor);
            }
            return new LiteralRegexExecRootNode.EmptyIndexOf(language, ast, preCalcResultVisitor);
        }
        if (caret) {
            if (dollar) {
                return new LiteralRegexExecRootNode.Equals(language, ast, preCalcResultVisitor);
            }
            return new LiteralRegexExecRootNode.StartsWith(language, ast, preCalcResultVisitor);
        }
        if (dollar) {
            return new LiteralRegexExecRootNode.EndsWith(language, ast, preCalcResultVisitor);
        }
        if (ast.getFlags().isSticky()) {
            return new LiteralRegexExecRootNode.RegionMatches(language, ast, preCalcResultVisitor);
        }
        if (preCalcResultVisitor.getLiteral().length() <= 64) {
            return new LiteralRegexExecRootNode.IndexOfString(language, ast, preCalcResultVisitor);
        }
        return null;
    }
}

