/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.repository;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.client.GitProgressSupport;
import org.netbeans.modules.git.ui.repository.Bundle;
import org.netbeans.modules.git.ui.repository.RepositoryInfo;
import org.netbeans.modules.git.ui.repository.Revision;
import org.netbeans.modules.git.ui.repository.RevisionDialog;
import org.netbeans.modules.git.ui.repository.RevisionInfoPanelController;
import org.netbeans.modules.git.ui.repository.RevisionPicker;
import org.netbeans.modules.git.utils.GitUtils;

public class RevisionDialogController
implements ActionListener,
DocumentListener,
PropertyChangeListener,
ListSelectionListener {
    private final RevisionDialog panel;
    private final File repository;
    private final RevisionInfoPanelController infoPanelController;
    private final PropertyChangeSupport support;
    public static final String PROP_VALID = "RevisionDialogController.valid";
    public static final String PROP_REVISION_ACCEPTED = "RevisionDialogController.revisionAccepted";
    private boolean valid;
    private final Timer t;
    private boolean internally;
    private final File[] roots;
    private String revisionString;
    private String mergingInto;
    private Revision revisionInfo;
    private DefaultListModel<Object> branchModel;

    public RevisionDialogController(File repository, File[] roots, String initialRevision) {
        this(repository, roots);
        this.panel.revisionField.setText(initialRevision);
        this.panel.revisionField.setCaretPosition(this.panel.revisionField.getText().length());
        this.panel.revisionField.moveCaretPosition(0);
        this.hideFields(new JComponent[]{this.panel.lblBranch, this.panel.branchesPanel});
    }

    public RevisionDialogController(File repository, File[] roots, Map<String, GitBranch> branches, String defaultBranchName) {
        this(repository, roots);
        this.hideFields(new JComponent[]{this.panel.lblRevision, this.panel.revisionField, this.panel.btnSelectRevision});
        this.setModel(branches, defaultBranchName);
    }

    private RevisionDialogController(File repository, File[] roots) {
        this.infoPanelController = new RevisionInfoPanelController(repository);
        this.panel = new RevisionDialog(this.infoPanelController.getPanel());
        this.repository = repository;
        this.roots = roots;
        this.support = new PropertyChangeSupport(this);
        this.t = new Timer(500, this);
        this.t.stop();
        this.revisionString = this.panel.revisionField.getText();
        this.infoPanelController.loadInfo(this.revisionString);
        this.attachListeners();
    }

    public RevisionDialog getPanel() {
        return this.panel;
    }

    public void setEnabled(boolean enabled) {
        this.panel.btnSelectRevision.setEnabled(enabled);
        this.panel.revisionField.setEnabled(enabled);
    }

    public Revision getRevision() {
        return this.revisionInfo == null ? new Revision(this.revisionString, this.revisionString) : this.revisionInfo;
    }

    public void addPropertyChangeListener(PropertyChangeListener list) {
        this.support.addPropertyChangeListener(list);
    }

    public void removePropertyChangeListener(PropertyChangeListener list) {
        this.support.removePropertyChangeListener(list);
    }

    public void setMergingInto(String revision) {
        this.mergingInto = revision;
        this.infoPanelController.displayMergedStatus(revision);
    }

    private void attachListeners() {
        this.panel.btnSelectRevision.addActionListener(this);
        this.panel.revisionField.getDocument().addDocumentListener(this);
        this.panel.lstBranches.addListSelectionListener(this);
        this.panel.lstBranches.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getSource() == ((RevisionDialogController)RevisionDialogController.this).panel.lstBranches && e.getClickCount() == 2 && RevisionDialogController.this.revisionInfo != null) {
                    e.consume();
                    RevisionDialogController.this.support.firePropertyChange(RevisionDialogController.PROP_REVISION_ACCEPTED, null, RevisionDialogController.this.revisionInfo);
                }
            }
        });
        this.infoPanelController.addPropertyChangeListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.panel.btnSelectRevision) {
            this.openRevisionPicker();
        } else if (e.getSource() == this.t) {
            this.t.stop();
            this.infoPanelController.loadInfo(this.revisionString);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting() && e.getSource() == this.panel.lstBranches) {
            this.selectedBranchChanged();
        }
    }

    private void openRevisionPicker() {
        RevisionPicker picker = new RevisionPicker(this.repository, this.roots);
        picker.displayMergedStatus(this.mergingInto);
        if (picker.open()) {
            Revision selectedRevision = picker.getRevision();
            this.internally = true;
            try {
                this.panel.revisionField.setText(selectedRevision.getRevision());
                this.panel.revisionField.setCaretPosition(0);
            }
            finally {
                this.internally = false;
            }
            if (!selectedRevision.getRevision().equals(this.revisionString)) {
                this.revisionString = selectedRevision.getRevision();
                this.updateRevision();
            }
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.revisionChanged();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.revisionChanged();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    private void setValid(boolean flag, Revision revision) {
        boolean oldValue = this.valid;
        this.valid = flag;
        this.revisionInfo = revision;
        if (this.valid != oldValue) {
            this.support.firePropertyChange(PROP_VALID, oldValue, this.valid);
        }
    }

    private void revisionChanged() {
        if (!this.internally) {
            this.revisionString = this.panel.revisionField.getText();
            this.updateRevision();
        }
    }

    private void updateRevision() {
        this.setValid(false, null);
        this.t.restart();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName() == "RevisionInfoPanelController.valid") {
            this.setValid(Boolean.TRUE.equals(evt.getNewValue()), this.infoPanelController.getInfo());
        }
    }

    private void hideFields(JComponent[] fields) {
        for (JComponent field : fields) {
            field.setVisible(false);
        }
    }

    private void setModel(Map<String, GitBranch> branches, String toSelectBranchName) {
        if (branches.isEmpty()) {
            this.loadBranches(toSelectBranchName);
            return;
        }
        final ArrayList<Revision.BranchReference> branchList = new ArrayList<Revision.BranchReference>(branches.size());
        ArrayList<Revision.BranchReference> remoteBranchList = new ArrayList<Revision.BranchReference>(branches.size());
        Revision.BranchReference activeBranch = null;
        for (Map.Entry<String, GitBranch> e : branches.entrySet()) {
            GitBranch branch = e.getValue();
            Revision.BranchReference rev = null;
            if (branch.isRemote()) {
                rev = new Revision.BranchReference(branch);
                remoteBranchList.add(rev);
            } else if (branch.getName() != "(no branch)") {
                rev = new Revision.BranchReference(branch);
                branchList.add(rev);
            }
            if (rev == null || (toSelectBranchName == null || !toSelectBranchName.equals(branch.getName())) && (toSelectBranchName != null || !branch.isActive())) continue;
            activeBranch = rev;
        }
        Comparator<Revision> comp = new Comparator<Revision>(){

            @Override
            public int compare(Revision b1, Revision b2) {
                return b1.getRevision().compareTo(b2.getRevision());
            }
        };
        Collections.sort(branchList, comp);
        Collections.sort(remoteBranchList, comp);
        branchList.addAll(remoteBranchList);
        final Revision.BranchReference toSelect = activeBranch;
        this.branchModel = new DefaultListModel();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (branchList.isEmpty()) {
                    RevisionDialogController.this.branchModel.addElement(Bundle.MSG_RevisionDialog_noBranches());
                } else {
                    for (Revision rev : branchList) {
                        RevisionDialogController.this.branchModel.addElement(rev);
                    }
                }
                ((RevisionDialogController)RevisionDialogController.this).panel.lstBranches.setModel(RevisionDialogController.this.branchModel);
                ((RevisionDialogController)RevisionDialogController.this).panel.lstBranches.setCellRenderer(new DefaultListCellRenderer(){

                    @Override
                    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                        return super.getListCellRendererComponent((JList<?>)list, value instanceof Revision ? ((Revision)value).getRevision() : value, index, isSelected, cellHasFocus);
                    }
                });
                if (toSelect != null) {
                    ((RevisionDialogController)RevisionDialogController.this).panel.lstBranches.setSelectedValue(toSelect, true);
                }
                RevisionDialogController.this.selectedBranchChanged();
                if (!branchList.isEmpty()) {
                    GitUtils.attachQuickSearch(branchList, ((RevisionDialogController)RevisionDialogController.this).panel.branchesPanel, ((RevisionDialogController)RevisionDialogController.this).panel.lstBranches, RevisionDialogController.this.branchModel, new GitUtils.SearchCallback<Revision>(){

                        @Override
                        public boolean contains(Revision rev, String needle) {
                            return rev.getRevision().toLowerCase().contains(needle.toLowerCase());
                        }
                    });
                }
            }
        });
    }

    private void selectedBranchChanged() {
        Object activeBranch = this.panel.lstBranches.getSelectedValue();
        if (activeBranch instanceof Revision) {
            this.revisionString = ((Revision)activeBranch).getRevision();
            this.setValid(this.valid, (Revision)activeBranch);
            this.t.restart();
        } else {
            this.revisionString = activeBranch instanceof Revision ? ((Revision)activeBranch).getRevision() : Bundle.MSG_RevisionDialog_noBranches();
            this.updateRevision();
        }
    }

    private void loadBranches(final String defaultBranch) {
        DefaultListModel<String> model = new DefaultListModel<String>();
        model.addElement(Bundle.RevisionDialogController_loadingBranches());
        this.panel.lstBranches.setModel(model);
        this.panel.lstBranches.setEnabled(false);
        new GitProgressSupport.NoOutputLogging(){

            @Override
            protected void perform() {
                final Map<String, GitBranch> branches = RepositoryInfo.getInstance(RevisionDialogController.this.repository).getBranches();
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ((RevisionDialogController)RevisionDialogController.this).panel.lstBranches.setEnabled(true);
                        RevisionDialogController.this.setModel(branches.isEmpty() ? Collections.singletonMap("(no branch)", GitBranch.NO_BRANCH_INSTANCE) : branches, defaultBranch);
                    }
                });
            }
        }.start(Git.getInstance().getRequestProcessor(this.repository), this.repository, Bundle.RevisionDialogController_loadingBranches());
    }
}

