/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.js.parser.ir;

import com.oracle.js.parser.ir.BaseNode;
import com.oracle.js.parser.ir.Expression;
import com.oracle.js.parser.ir.LexicalContext;
import com.oracle.js.parser.ir.Node;
import com.oracle.js.parser.ir.visitor.NodeVisitor;
import com.oracle.js.parser.ir.visitor.TranslatorNodeVisitor;

public final class AccessNode
extends BaseNode {
    private final String property;

    public AccessNode(long token, int finish, Expression base, String property) {
        super(token, finish, base, false, false);
        this.property = property;
    }

    private AccessNode(AccessNode accessNode, Expression base, String property, boolean isFunction, boolean isSuper) {
        super(accessNode, base, isFunction, isSuper);
        this.property = property;
    }

    @Override
    public Node accept(NodeVisitor<? extends LexicalContext> visitor) {
        if (visitor.enterAccessNode(this)) {
            return visitor.leaveAccessNode(this.setBase((Expression)this.base.accept(visitor)));
        }
        return this;
    }

    @Override
    public <R> R accept(TranslatorNodeVisitor<? extends LexicalContext, R> visitor) {
        return visitor.enterAccessNode(this);
    }

    @Override
    public void toString(StringBuilder sb, boolean printType) {
        boolean needsParen = this.tokenType().needsParens(this.getBase().tokenType(), true);
        if (needsParen) {
            sb.append('(');
        }
        this.base.toString(sb, printType);
        if (needsParen) {
            sb.append(')');
        }
        sb.append('.');
        sb.append(this.property);
    }

    public String getProperty() {
        return this.property;
    }

    private AccessNode setBase(Expression base) {
        if (this.base == base) {
            return this;
        }
        return new AccessNode(this, base, this.property, this.isFunction(), this.isSuper());
    }

    @Override
    public AccessNode setIsFunction() {
        if (this.isFunction()) {
            return this;
        }
        return new AccessNode(this, this.base, this.property, true, this.isSuper());
    }

    @Override
    public AccessNode setIsSuper() {
        if (this.isSuper()) {
            return this;
        }
        return new AccessNode(this, this.base, this.property, this.isFunction(), true);
    }
}

