/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.php.rename;

import java.io.IOException;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.php.rename.RenamePanel;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUIBypass;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class PHPRenameFileRefactoringUI
implements RefactoringUI,
RefactoringUIBypass {
    private final AbstractRefactoring refactoring;
    private RenamePanel panel;
    private final FileObject file;
    private String newName;

    public PHPRenameFileRefactoringUI(FileObject file) {
        this.file = file;
        this.newName = file.getName();
        this.refactoring = new RenameRefactoring(Lookups.fixed((Object[])new Object[]{file}));
    }

    public PHPRenameFileRefactoringUI(FileObject file, String newName) {
        this.file = file;
        this.newName = newName;
        this.refactoring = new RenameRefactoring(Lookups.fixed((Object[])new Object[]{file}));
    }

    public String getName() {
        return NbBundle.getMessage(PHPRenameFileRefactoringUI.class, (String)"LBL_Rename");
    }

    public String getDescription() {
        return NbBundle.getMessage(PHPRenameFileRefactoringUI.class, (String)"LBL_Rename_File");
    }

    public boolean isQuery() {
        return false;
    }

    public CustomRefactoringPanel getPanel(ChangeListener parent) {
        if (this.panel == null) {
            this.panel = new RenamePanel(this.newName, null, parent, NbBundle.getMessage(RenamePanel.class, (String)"LBL_Rename"), true, true);
        }
        return this.panel;
    }

    public Problem setParameters() {
        String panelName = this.panel.getNameValue();
        if (this.refactoring instanceof RenameRefactoring) {
            ((RenameRefactoring)this.refactoring).setNewName(panelName);
        }
        return this.refactoring.checkParameters();
    }

    public Problem checkParameters() {
        if (this.refactoring instanceof RenameRefactoring) {
            ((RenameRefactoring)this.refactoring).setNewName(this.panel.getNameValue());
        }
        return this.refactoring.fastCheckParameters();
    }

    public boolean hasParameters() {
        return true;
    }

    public AbstractRefactoring getRefactoring() {
        return this.refactoring;
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    public boolean isRefactoringBypassRequired() {
        return false;
    }

    public void doRefactoringBypass() throws IOException {
        DataObject dob = DataObject.find((FileObject)this.file);
        if (dob != null) {
            dob.rename(this.panel.getNameValue());
        }
    }
}

