/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.jdbc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import org.netbeans.lib.profiler.results.memory.PresoObjAllocCCTNode;
import org.netbeans.lib.profiler.ui.jdbc.JDBCTreeTableView;
import org.netbeans.lib.profiler.ui.jdbc.SQLFormatter;
import org.netbeans.lib.profiler.ui.swing.renderer.JavaNameRenderer;
import org.netbeans.modules.profiler.api.icons.Icons;

final class JDBCJavaNameRenderer
extends JavaNameRenderer {
    private static final Icon SQL_ICON = Icons.getIcon((String)"ProfilerIcons.SqlQuery");
    private static final Icon SQL_ICON_DISABLED = UIManager.getLookAndFeel().getDisabledIcon(null, SQL_ICON);
    private static final Icon LEAF_ICON = Icons.getIcon((String)"ProfilerIcons.NodeLeaf");
    private static final Icon LEAF_ICON_DISABLED = UIManager.getLookAndFeel().getDisabledIcon(null, LEAF_ICON);
    private final Icon icon;
    private final Icon iconDisabled;
    private String currentValue;
    private JLabel currentSQLRenderer;
    private static int CACHE_SIZE = 100;
    private List<String> sqlRenderersKeys;
    private Map<String, JLabel> sqlRenderersCache;

    public JDBCJavaNameRenderer() {
        this("ProfilerIcons.NodeReverse");
    }

    public JDBCJavaNameRenderer(String iconKey) {
        this.icon = Icons.getIcon((String)iconKey);
        this.iconDisabled = UIManager.getLookAndFeel().getDisabledIcon(null, this.icon);
    }

    @Override
    public void setValue(Object value, int row) {
        if (value instanceof PresoObjAllocCCTNode) {
            PresoObjAllocCCTNode node = (PresoObjAllocCCTNode)value;
            boolean filtered = node.isFiltered();
            this.currentValue = node.getNodeName();
            if (JDBCTreeTableView.isSQL(node)) {
                JDBCTreeTableView.SQLQueryNode sqlNode = (JDBCTreeTableView.SQLQueryNode)node;
                String htmlName = sqlNode.htmlName;
                if (htmlName == null) {
                    sqlNode.htmlName = htmlName = SQLFormatter.format(this.currentValue);
                }
                this.currentSQLRenderer = this.sqlRenderer(htmlName, filtered ? SQL_ICON_DISABLED : SQL_ICON);
            } else {
                if (filtered) {
                    this.setNormalValue("");
                    this.setBoldValue("");
                    this.setGrayValue(this.currentValue);
                } else {
                    super.setValue(this.currentValue, row);
                }
                if (node.isLeaf()) {
                    this.setIcon(filtered ? LEAF_ICON_DISABLED : LEAF_ICON);
                } else {
                    this.setIcon(filtered ? this.iconDisabled : this.icon);
                }
                this.currentSQLRenderer = null;
            }
        } else {
            super.setValue(value, row);
        }
    }

    @Override
    public JComponent getComponent() {
        return this.currentSQLRenderer != null ? this.currentSQLRenderer : super.getComponent();
    }

    @Override
    public String toString() {
        return this.currentValue;
    }

    private JLabel sqlRenderer(String text, Icon icon) {
        JLabel sqlRenderer;
        if (this.sqlRenderersCache == null) {
            this.sqlRenderersKeys = new ArrayList<String>(CACHE_SIZE);
            this.sqlRenderersCache = new HashMap<String, JLabel>(CACHE_SIZE);
        }
        if ((sqlRenderer = this.sqlRenderersCache.get(text)) == null) {
            if (this.sqlRenderersKeys.size() < CACHE_SIZE) {
                sqlRenderer = new DefaultTableCellRenderer();
            } else {
                String key = this.sqlRenderersKeys.remove(0);
                sqlRenderer = this.sqlRenderersCache.remove(key);
            }
            this.sqlRenderersKeys.add(text);
            this.sqlRenderersCache.put(text, sqlRenderer);
            sqlRenderer.setText(text);
        }
        sqlRenderer.setIcon(icon);
        return sqlRenderer;
    }
}

