/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.codeception;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.netbeans.modules.php.api.editor.PhpType;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.codeception.Bundle;
import org.netbeans.modules.php.codeception.commands.Codecept;
import org.netbeans.modules.php.codeception.coverage.CoverageProvider;
import org.netbeans.modules.php.codeception.create.TestCreator;
import org.netbeans.modules.php.codeception.locate.CodeceptionTestLocator;
import org.netbeans.modules.php.codeception.run.TestRunner;
import org.netbeans.modules.php.codeception.ui.customizer.CodeceptionCustomizer;
import org.netbeans.modules.php.spi.testing.PhpTestingProvider;
import org.netbeans.modules.php.spi.testing.create.CreateTestsResult;
import org.netbeans.modules.php.spi.testing.locate.Locations;
import org.netbeans.modules.php.spi.testing.locate.TestLocator;
import org.netbeans.modules.php.spi.testing.run.TestRunException;
import org.netbeans.modules.php.spi.testing.run.TestRunInfo;
import org.netbeans.modules.php.spi.testing.run.TestSession;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class CodeceptionTestingProvider
implements PhpTestingProvider {
    public static final String IDENTIFIER = "Codeception";
    private static final CodeceptionTestingProvider INSTANCE = new CodeceptionTestingProvider();

    public static CodeceptionTestingProvider getInstance() {
        return INSTANCE;
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public String getDisplayName() {
        return Bundle.CodeceptionTestingProvider_displayName();
    }

    public boolean isTestFile(PhpModule phpModule, FileObject fileObject) {
        if (!Codecept.isCodeceptionTestFile(fileObject.getNameExt())) {
            return false;
        }
        for (FileObject testDirectory : phpModule.getTestDirectories()) {
            if (!FileUtil.isParentOf((FileObject)testDirectory, (FileObject)fileObject)) continue;
            return true;
        }
        FileObject sourceDirectory = phpModule.getSourceDirectory();
        return sourceDirectory != null && FileUtil.isParentOf((FileObject)sourceDirectory, (FileObject)fileObject);
    }

    public boolean isTestCase(PhpModule phpModule, PhpType.Method method) {
        boolean isTest = Codecept.isTestClass(method.getPhpType().getName());
        if (!isTest && !Codecept.isCestClass(method.getPhpType().getName())) {
            return false;
        }
        return Codecept.isTestMethod(method.getName(), isTest);
    }

    public void runTests(PhpModule phpModule, TestRunInfo runInfo, TestSession testSession) throws TestRunException {
        new TestRunner(phpModule).runTests(runInfo, testSession);
        if (runInfo.isCoverageEnabled()) {
            testSession.setCoverage(new CoverageProvider().getCoverage());
        }
    }

    public TestLocator getTestLocator(PhpModule phpModule) {
        return new CodeceptionTestLocator(phpModule);
    }

    public CreateTestsResult createTests(PhpModule phpModule, List<FileObject> files, Map<String, Object> configurationPanelProperties) {
        return new TestCreator(phpModule).createTests(files, configurationPanelProperties);
    }

    public boolean isCoverageSupported(PhpModule phpModule) {
        return true;
    }

    public Locations.Line parseFileFromOutput(String line) {
        File file;
        Matcher matcher = Codecept.LINE_PATTERN.matcher(line);
        if (matcher.matches() && (file = new File(matcher.group(1))).isFile()) {
            FileObject fo = FileUtil.toFileObject((File)file);
            assert (fo != null);
            return new Locations.Line(fo, Integer.parseInt(matcher.group(2)));
        }
        return null;
    }

    public ProjectCustomizer.CompositeCategoryProvider createCustomizer(PhpModule phpModule) {
        return new CodeceptionCustomizer(phpModule);
    }
}

