/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.execute;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.gradle.api.execute.RunConfig;
import org.netbeans.modules.gradle.execute.GradlePlainEscapeProcessor;
import org.openide.windows.IOColors;
import org.openide.windows.InputOutput;

public class GradleColorEscapeProcessor
extends GradlePlainEscapeProcessor {
    private static final Pattern PROGRESS_PATTERN = Pattern.compile("> Building (\\d+)%(.*)");
    final ProgressHandle handle;
    StringBuilder statusLine = new StringBuilder(120);
    boolean append = true;
    boolean hasProgress;

    public GradleColorEscapeProcessor(InputOutput io, ProgressHandle handle, RunConfig cfg) {
        super(io, cfg, false);
        this.handle = handle;
    }

    @Override
    public void processCommand(String sequence, char command, int ... a) {
        if (a.length > 0) {
            int param = a[0];
            switch (command) {
                case 'm': {
                    switch (param) {
                        case 1: {
                            this.outType = IOColors.OutputType.LOG_DEBUG;
                            break;
                        }
                        case 22: {
                            this.outType = IOColors.OutputType.OUTPUT;
                            break;
                        }
                        case 31: {
                            this.outType = IOColors.OutputType.LOG_FAILURE;
                            break;
                        }
                        case 33: {
                            this.outType = IOColors.OutputType.LOG_WARNING;
                            break;
                        }
                        case 39: {
                            this.outType = IOColors.OutputType.OUTPUT;
                        }
                    }
                    break;
                }
                case 'D': {
                    if (this.statusLine == null) break;
                    this.statusLine.delete(this.statusLine.length() - param, this.statusLine.length());
                    break;
                }
                case 'A': {
                    this.append = true;
                    break;
                }
            }
        }
    }

    @Override
    public void processText(String text) {
        if (this.outType == IOColors.OutputType.LOG_DEBUG) {
            if (!text.startsWith("--")) {
                this.statusLine.append(text);
                this.processProgress();
            } else {
                this.outType = IOColors.OutputType.OUTPUT;
            }
        }
        if (this.outType != IOColors.OutputType.LOG_DEBUG) {
            String out = text;
            if (!this.append) {
                this.io.getOut().println();
            }
            boolean bl = this.append = !text.endsWith("\n");
            if (!this.append) {
                out = text.substring(0, text.length() - 1);
            }
            super.processText(out);
        }
    }

    private void processProgress() {
        Matcher matcher = PROGRESS_PATTERN.matcher(this.statusLine);
        if (matcher.matches()) {
            if (!this.hasProgress) {
                this.handle.switchToDeterminate(100);
                this.hasProgress = true;
            }
            String percent = matcher.group(1);
            String status = matcher.group(2);
            try {
                this.handle.progress(status, Integer.parseInt(percent));
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            this.handle.progress(this.statusLine.toString());
        }
    }
}

