/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.util.UIScale;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicToolBarUI;

public class FlatToolBarUI
extends BasicToolBarUI {
    private Border rolloverBorder;

    public static ComponentUI createUI(JComponent c) {
        return new FlatToolBarUI();
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.rolloverBorder = null;
    }

    @Override
    protected ContainerListener createToolBarContListener() {
        return new BasicToolBarUI.ToolBarContListener(){

            @Override
            public void componentAdded(ContainerEvent e) {
                super.componentAdded(e);
                Component c = e.getChild();
                if (c instanceof AbstractButton) {
                    c.setFocusable(false);
                }
            }

            @Override
            public void componentRemoved(ContainerEvent e) {
                super.componentRemoved(e);
                Component c = e.getChild();
                if (c instanceof AbstractButton) {
                    c.setFocusable(true);
                }
            }
        };
    }

    @Override
    protected Border createRolloverBorder() {
        return this.getRolloverBorder();
    }

    @Override
    protected Border createNonRolloverBorder() {
        return this.getRolloverBorder();
    }

    @Override
    protected Border getNonRolloverBorder(AbstractButton b) {
        return this.getRolloverBorder();
    }

    private Border getRolloverBorder() {
        if (this.rolloverBorder == null) {
            this.rolloverBorder = new FlatRolloverMarginBorder();
        }
        return this.rolloverBorder;
    }

    @Override
    public void setOrientation(int orientation) {
        Insets margin;
        Insets newMargin;
        if (orientation != this.toolBar.getOrientation() && !(newMargin = new Insets(margin.left, margin.top, margin.right, margin.bottom)).equals(margin = this.toolBar.getMargin())) {
            this.toolBar.setMargin(newMargin);
        }
        super.setOrientation(orientation);
    }

    private static class FlatRolloverMarginBorder
    extends EmptyBorder {
        public FlatRolloverMarginBorder() {
            super(UIManager.getInsets("ToolBar.buttonMargins"));
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            Insets margin;
            Insets insets2 = margin = c instanceof AbstractButton ? ((AbstractButton)c).getMargin() : null;
            if (margin == null || margin instanceof UIResource) {
                insets.top = this.top;
                insets.left = this.left;
                insets.bottom = this.bottom;
                insets.right = this.right;
            } else {
                insets.top = margin.top;
                insets.left = margin.left;
                insets.bottom = margin.bottom;
                insets.right = margin.right;
            }
            insets.top = UIScale.scale(insets.top);
            insets.left = UIScale.scale(insets.left);
            insets.bottom = UIScale.scale(insets.bottom);
            insets.right = UIScale.scale(insets.right);
            return insets;
        }
    }
}

