/*
 Copyright (c) The Growl Project, 2004-2005
 All rights reserved.

 Redistribution and use in source and binary forms, with or without modification,
 are permitted provided that the following conditions are met:

 1. Redistributions of source code must retain the above copyright
 notice, this list of conditions and the following disclaimer.
 2. Redistributions in binary form must reproduce the above copyright
 notice, this list of conditions and the following disclaimer in the
 documentation and/or other materials provided with the distribution.
 3. Neither the name of Growl nor the names of its contributors
 may be used to endorse or promote products derived from this software
 without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 OF THE POSSIBILITY OF SUCH DAMAGE.
*/
//
//  Message+GrowlMail.h
//  GrowlMail
//
//  Created by Ingmar Stein on 27.10.04.
//

#import "MailHeaders.h"

@interface Message(GrowlMail)
/*!
 * @brief Begin to show a Growl notification for this message
 *
 * This should be called on an auxiliary thread as it may block.
 *
 * This method calls part 2 on the main thread; you do not need to call part 2 yourself.
 */
- (void) GMShowNotificationPart1;
/*!
 * @brief Finish showing a Growl notification for this message
 *
 * Don't call this directly - call part 1 instead. Part 1 will call this on the main thread because it will get the attributed string for the message body, which may require going through WebKit (which will throw an exception if we call it on a secondary thread).
 *
 *	@param[in]	messageBody	The object containing the body of the message, which part 1 obtained.
 */
- (void) GMShowNotificationPart2:(MessageBody *)messageBody;
@end
