RCS_ID("$Id: FFImageWindowBorderless.m 512 2005-10-15 16:46:40Z ravemax $")

#import "FFImageWindowBorderless.h"

@implementation FFImageWindowBorderless

- (id)initWithLevel:(int)level {
	self = [super initWithContentRect:NSMakeRect(50.0, 50.0, 300.0, 200.0)
						 andStyleMask:NSBorderlessWindowMask];
	if (self) {
		[self setHasShadow:TRUE];
		[self setLevel:level];
		
		m_resizeMode = RESIZE_NONE;
	}
	return self;
}

- (void)adjustViewSize:(NSSize)size refresh:(FFRefresh)refresh
	   keepAspectRatio:(BOOL)aratio andCenter:(BOOL)center {

	[self adjustViewSize:size
				minWidth:BORDERLESS_FRAME_MIN_SIZE
				 refresh:refresh
				 keepAspectRatio:aratio
			   andCenter:center];
}


- (float)widgetHeight {
	return 0.0f;
}

- (void)mouseDragged:(NSEvent*)event {
	// Move
	if (m_resizeMode == RESIZE_NONE) { // Move the window
		[super mouseDragged:event];
		return;
	}

	// Resize
	float   dx  = [event deltaX];
	float   dy  = [event deltaY];
	NSRect  fr  = [self frame];

	switch (m_resizeMode) {
		case RESIZE_LEFT_TOP:
			fr.size.width   -= dx;
			fr.size.height  -= dy;
			fr.origin.x		+= dx;
			break;
		case RESIZE_LEFT_BOTTOM:
			fr.size.width   -= dx;
			fr.size.height  += dy;
			fr.origin.x		+= dx;
			fr.origin.y		-= dy;
			break;
		case RESIZE_RIGHT_TOP:
			fr.size.width   += dx;
			fr.size.height  -= dy;
			break;
		case RESIZE_RIGHT_BOTTOM:
			fr.size.width   += dx;
			fr.size.height  += dy;
			fr.origin.y		-= dy;
			break;
			
		// Dummy - else the gcc gives a warning
		case RESIZE_NONE: ;
	}
	
	if ((fr.size.width > BORDERLESS_FRAME_MIN_SIZE) && (fr.size.height > BORDERLESS_FRAME_MIN_SIZE))
		[self setFrame:fr display:TRUE];
}

- (void)mouseDown:(NSEvent*)event {
	NSPoint p = [event locationInWindow];
	NSRect	f = [self frame];
	
	if (p.x < RESIZE_EDGE_SIZE) {
		if (p.y < RESIZE_EDGE_SIZE)
			m_resizeMode = RESIZE_LEFT_BOTTOM;
		else if (p.y >= f.size.height - RESIZE_EDGE_SIZE)
			m_resizeMode = RESIZE_LEFT_TOP;
	} else if (p.x >= f.size.width - RESIZE_EDGE_SIZE) {
		if (p.y < RESIZE_EDGE_SIZE)
			m_resizeMode = RESIZE_RIGHT_BOTTOM;
		else if (p.y >= f.size.height - RESIZE_EDGE_SIZE)
			m_resizeMode = RESIZE_RIGHT_TOP;
	}
}

- (void)mouseUp:(NSEvent*)event {
	m_resizeMode = RESIZE_NONE;	
}

- (void)performClose:(id)sender {
	if (([self delegate] != nil) && 
		[[self delegate] respondsToSelector:@selector(windowShouldClose:)])
		[[self delegate] windowShouldClose:self];
	// do nothing
}

@end
