RCS_ID("$Id: FFToolbarUtil.m 495 2005-09-26 16:15:17Z ravemax $")

#import "FFToolbarUtil.h"

void addViewToToolbar(NSString* identifier,
					  NSMutableDictionary* itemDict,
					  NSView* view,
					  NSString* label, NSString* tooltip) {

	NSToolbarItem* tbi = [[NSToolbarItem alloc] initWithItemIdentifier:identifier];
	[tbi setLabel:label];
	[tbi setPaletteLabel:label];
	[tbi setToolTip:tooltip];
	[tbi setView:view];
	
	[tbi setMinSize:NSMakeSize(NSWidth([view frame]), NSHeight([view frame]))];
	[tbi setMaxSize:NSMakeSize(NSWidth([view frame]), NSHeight([view frame]))];
	
	[itemDict setObject:tbi forKey:identifier];	
}

// altImg may be nil
NSButton* createToolbarButton(NSString* identifier,
							  NSMutableDictionary* itemDict,
							  NSString* normalImg,
							  NSString* altImg,
							  id target, SEL action,
							  NSString* label, NSString* tooltip) {

	// Create the button
	NSButton* btn = [[NSButton alloc] init];
	[btn setButtonType:5];
	[btn setBordered:FALSE];
	[btn setImage:[NSImage imageNamed:normalImg]];
	if (altImg != nil)
		[btn setAlternateImage:[NSImage imageNamed:altImg]];
	[btn setTarget:target];
	[btn setAction:action];
	[btn sizeToFit];
	
	// Add
	addViewToToolbar(identifier, itemDict, btn, label, tooltip);
	
	// The button has to be released by the user
	return btn;
}

void createToolbarItem(NSString* identifier,
					   NSMutableDictionary* itemDict,
					   NSString* img,
					   id target, SEL action,
					   NSString* label, NSString* tooltip) {
	// Create
	NSToolbarItem* tbi = [[NSToolbarItem alloc] initWithItemIdentifier:identifier];
	[tbi setImage:[NSImage imageNamed:img]];
	[tbi setLabel:label];
	[tbi setPaletteLabel:label];
	[tbi setToolTip:tooltip];
	[tbi setTarget:target];
	[tbi setAction:action];
	
	[itemDict setObject:tbi forKey:identifier];
}
