RCS_ID("$Id: FFToolTip.m 495 2005-09-26 16:15:17Z ravemax $")

#import "FFToolTip.h"
#import "NSBezierPath_Additions.h"

@implementation FFToolTipView

#define BACKGROUND_COLOR	[NSColor colorWithCalibratedRed:0.0 green:0.0 blue:0.0 alpha:0.8]
#define	BG_RECTANGLE_RADIUS	8
#define BORDER_PADDING		5
#define TEXT_SPACING		2

- (id)initWithFrame:(NSRect)frameRect andDelegate:(id)delegate {
	self = [super initWithFrame:frameRect];
	if (self != nil) {
		//
		m_delegate	= delegate;
		m_bgCol		= [BACKGROUND_COLOR retain];
		m_lineLock	= [[NSLock alloc] init];
		
		// Font
		m_textAttribs = [[NSDictionary alloc] initWithObjectsAndKeys:
			[NSFont systemFontOfSize:12], NSFontAttributeName,
			[NSColor whiteColor], NSForegroundColorAttributeName,
			nil];

		m_bgPath	= nil;
		m_numLines	= 0;
	}
	return self;
}

- (void)_reset {
	if (m_bgPath != nil)
		[m_bgPath release];
	for (; m_numLines > 0; m_numLines--)
		[m_lines[m_numLines-1].text release];
}

- (void)dealloc {
	[m_textAttribs release];
	[m_bgCol release];
	[m_lineLock release];

	[self _reset];
	[super dealloc];
}

- (void)drawRect:(NSRect)rect {
	// Its now not allowed to modify the lines
	[m_lineLock lock];

	[m_bgCol set];
	[m_bgPath fill];
	
	int i;
	for (i = 0; i < m_numLines; i++)
		[m_lines[i].text drawAtPoint:m_lines[i].origin withAttributes:m_textAttribs];
	
	// Lines may changed now
	[m_lineLock unlock];
}

- (void)setLines:(va_list)vaLines {
	NSString*	text;
	int			i;
	NSSize		size;
	float		y = BORDER_PADDING;
	
	// Block drawing
	[m_lineLock lock];
	
	// Replace old w/ new lines
	[self _reset];
	while (text = va_arg(vaLines, NSString*)) {
		m_lines[m_numLines].text	= [text retain];
		m_numLines++;
		if (m_numLines == MAX_TOOLTIP_LINES)
			break;
	}

	// Calculate the line positions & frame size
	size.width = 0.0f;
	for (i = m_numLines - 1; i >= 0; i--) {
		m_lines[i].origin	= NSMakePoint(BORDER_PADDING, y);
	
		NSSize lineSize = [m_lines[i].text sizeWithAttributes:m_textAttribs];
		size.width = MAX(size.width, lineSize.width);
		y += lineSize.height + TEXT_SPACING;
	}
	
	// Create the background path
	size.width += 2 * BORDER_PADDING;
	size.height	= y + BORDER_PADDING;
	m_bgPath = [[NSBezierPath roundedRectangleWithWidth:size.width height:size.height
										 andEdgeRadius:BG_RECTANGLE_RADIUS] retain];
		
	// Resize 
	[m_lineLock	unlock];
	[[self window] setContentSize:size];
}

- (BOOL)acceptsFirstMouse:(NSEvent*)event {
	return TRUE;
}

- (void)mouseDown:(NSEvent *)event {
	if (m_delegate != nil)
		[m_delegate toolTipClicked];
}

@end

#pragma mark -

@implementation FFToolTip

- (id)initWithDelegate:(id)delegate {
	self = [super init];
	if (self != nil) {
		m_win = [[NSWindow alloc] initWithContentRect:NSMakeRect(100, 100, 100, 100)
											styleMask:NSBorderlessWindowMask
											  backing:NSBackingStoreBuffered
												defer:YES];
		
		m_view	= [[FFToolTipView alloc] initWithFrame:[m_win frame]
										   andDelegate:delegate];
		[m_view setAutoresizingMask:(NSViewWidthSizable | NSViewHeightSizable)];
		[m_win setContentView:m_view];
		[m_win setBackgroundColor:[NSColor clearColor]];
		[m_win setOpaque:FALSE];
	}			
	return self;
}

- (void)dealloc {
	[m_win release];
	[m_view release];
	[super dealloc];
}

- (void)showWithLinesAtLocation:(NSPoint)location, ... {
	va_list vaLines;
	va_start(vaLines, location);
	[m_view setLines:vaLines];
	va_end(vaLines);
	
	// Center the tooltip around the specified location
	NSSize fsize = [m_win frame].size;
	location.x -= fsize.width / 2;
	location.y -= fsize.height / 2;
	[m_win setFrameOrigin:location];

	// Show it
	[m_win orderFront:self];
}

- (void)hide {
	[m_win orderOut:self];
}

@end
