RCS_ID("$Id: FFPrefsController.m 458 2005-07-16 19:27:58Z ravemax $")

#import "FFPrefsController.h"
#import <string.h>
#import "FFPreferences.h"
#import "FFApplication.h"
#import "FFInputEvent.h"
#import "FFInputEventOVNode.h"
#import "FFInputEventSheet.h"
#import "FFMainController.h"
#import "FFButtonCell.h"
#import "NSPopUpButton_Additions.h"

// Internal used NSToolbar categorys - allows to access the toolbar view
@interface NSToolbar (NSToolbarPrivate)
- (NSView*)_toolbarView;
@end

#pragma mark -

@implementation FFPrefsController

// Input event outline view column identifiers
static NSString* EventColIdent	= @"event";
static NSString* ActionColIdent	= @"action";
static NSString* ChangeColIdent	= @"change";
static NSString* RemoveColIdent	= @"remove";
static NSString* AddColIdent	= @"add";

// ToolbarItem identifiers & labels
static NSString* ToolbarItemIdents[NUM_OF_PREF_VIEWS] = {
	@"General",
	@"Image list",
	@"Panning",
	@"Input",
	@"Advanced"	
};

static NSString* ToolbarItemLabels[NUM_OF_PREF_VIEWS]; // Filled in initialize

// ToolbarItem dictionary keys
static NSString* ViewKey	= @"view";
static NSString* ItemKey	= @"item";

#pragma mark Initialization, awakeFromNib & cleanup

+ (void)initialize {
	ToolbarItemLabels[0] = FFTR(@"General");
	ToolbarItemLabels[1] = FFTR(@"Image list");
	ToolbarItemLabels[2] = FFTR(@"Panning");
	ToolbarItemLabels[3] = FFTR(@"Input");
	ToolbarItemLabels[4] = FFTR(@"Advanced");
}

- (id)initWithPreferences:(FFPreferences*)prefs {
	self = [super init];
	if (self != nil) {
		m_prefs				= prefs; // weak
		m_inputOVRootNode	= nil;

		// Load the nib
		if (![NSBundle loadNibNamed:@"Prefs" owner:self]) {
			NSLog(@"Pref.nib not found!");
			exit(-1);
		}
	}
	return self;
}

- (void)dealloc {
	int i;

	[[NSNotificationCenter defaultCenter] removeObserver:self];
		
	[m_inputOVRootNode release];
	for (i = 1; i < 4; i++) {
		[m_inputOVBgCols[i][0] release]; // even 
		[m_inputOVBgCols[i][1] release]; // odd
	}

	[m_toolbarItems release];
	[m_toolbar release];
	[m_toolbarIdents release];
	
	[super dealloc];
}

- (NSToolbarItem*)_toolbarItemWithIdent:(NSString*)ident andLabel:(NSString*)label {
	NSToolbarItem*	tbitem = [[NSToolbarItem alloc] initWithItemIdentifier:ident];
	
	[tbitem setLabel:label];
	[tbitem setImage:[NSImage imageNamed:ident]];
	[tbitem setTarget:self];
	[tbitem setAction:@selector(_toolbarItemClicked:)];
	
	return [tbitem autorelease];
}

- (void)_setupToolbarAndViews {
	// Toolbar items
	m_toolbarItems = [[NSDictionary alloc] initWithObjectsAndKeys:
		#define TBITEM(VIEW, IDENT, LABEL) \
			[NSDictionary dictionaryWithObjectsAndKeys: \
				VIEW, ViewKey, \
				[self _toolbarItemWithIdent:IDENT andLabel:LABEL], ItemKey, \
				nil], \
			IDENT
		
		TBITEM(m_viewGeneral,	ToolbarItemIdents[0], ToolbarItemLabels[0]),
		TBITEM(m_viewImageList, ToolbarItemIdents[1], ToolbarItemLabels[1]),
		TBITEM(m_viewPanning,	ToolbarItemIdents[2], ToolbarItemLabels[2]),
		TBITEM(m_viewInput,		ToolbarItemIdents[3], ToolbarItemLabels[3]),
		TBITEM(m_viewAdvanced,	ToolbarItemIdents[4], ToolbarItemLabels[4]),
		nil];
	
	m_toolbarIdents	= [[NSArray alloc] initWithObjects:ToolbarItemIdents count:NUM_OF_PREF_VIEWS];
	
	// Toolbar
	m_toolbar = [[NSToolbar alloc] initWithIdentifier:@"main"];
	[m_toolbar setDelegate:self];
	[m_window setToolbar:m_toolbar];
	
	// Default : General
	[self _setNewContentView:m_viewGeneral withLabel:ToolbarItemLabels[0]];
	[m_toolbar setSelectedItemIdentifier:ToolbarItemIdents[0]];
}

- (void)_setupOutlets {
	[m_generalSaveOpts setState:[m_prefs saveOpts]];
	[m_generalZoomFactor setFloatValue:[m_prefs zoomFactor]];
	[m_generalBorderlessWin setState:[m_prefs borderlessWin]];
	[m_generalWinLevel setEnabled:[m_prefs borderlessWin]];
	if ([m_prefs winLevel] == NSNormalWindowLevel)
		[m_generalWinLevel selectItemAtIndex:0];
	else if ([m_prefs winLevel] == NSSubmenuWindowLevel)
		[m_generalWinLevel selectItemAtIndex:1];
	else
		[m_generalWinLevel selectItemAtIndex:2];
	[m_generalWinBackgroundAuto setState:[m_prefs winBackgroundAuto]];
	[m_generalWinBackgroundCol setColor:[m_prefs winBackgroundColor]];
	[m_generalWinBackgroundCol setEnabled:![m_prefs winBackgroundAuto]];
	[m_generalSlideshowTime setDoubleValue:[m_prefs slideshowTime]];
	[self slideshowTimeModified:nil];
	[m_generalKeepMouseHidden setState:[m_prefs keepMouseHidden]];
	[m_generalDoublePageAligment selectItemWithTag:[m_prefs doublePageAlignment]];
	[m_generalMagLensWidthText setIntValue:[m_prefs magnifyingLensWidth]];
	[m_generalMagLensHeightText setIntValue:[m_prefs magnifyingLensHeight]];
	
	[m_listWrap selectItemAtIndex:(int)[m_prefs listWrap]];
	[m_listDirRoot setStringValue:[m_prefs directoryRoot]];
	[m_listTrashDelete setState:[m_prefs trashDelete]];
	[m_listWinHiddenOnStartup setState:[m_prefs listWinHiddenOnStartup]];
	[m_listThumbWidthText setIntValue:[m_prefs thumbWidth]];
	[m_listThumbHeightText setIntValue:[m_prefs thumbHeight]];
	
	[m_panHoldCtrl setState:[m_prefs ctrlForPanning]];
	[m_panRelative setState:[m_prefs relativePanning]];
	[m_panNormalShift setIntValue:(int)[m_prefs normalCursorShift]];
	[m_panNormalShiftText setIntValue:(int)[m_prefs normalCursorShift]];
	[m_panAcceleratedShift setIntValue:(int)[m_prefs acceleratedCursorShift]];
	[m_panAcceleratedShiftText setIntValue:(int)[m_prefs acceleratedCursorShift]];	
	[m_panWheelSpeedup setFloatValue:[m_prefs mouseWheelSpeedup]];
	[m_panWheelSpeedUpText setFloatValue:[m_prefs mouseWheelSpeedup]];
	
	[m_advRingBufSize setIntValue:[m_prefs ringBufferSize]];
	[m_advFetchDistance setIntValue:[m_prefs fetchDistance]];
	[self ringBufSizeModified:nil];
	[self fetchDistanceModified:nil];
}

- (FFInputEventOVNode*)_createOVNodesForMenu:(NSMenu*)menu 
									   level:(int)level
									isOddRow:(BOOL)isOddRow
								 actionNodes:(FFInputEventOVNode*[])actionNodes {
	
	FFInputEventOVNode*	superNode, 	*node; 
	NSEnumerator*		en;
	NSMenuItem*			item;
	BOOL				odd = FALSE;
	
	superNode = [FFInputEventOVNode nodeWithTitle:[menu title] 
							   andBackgroundColor:m_inputOVBgCols[level][(int)isOddRow]];	
	
	en	= [[menu itemArray] objectEnumerator];	
	while (item = [en nextObject]) {
		// Submenu
		if ([item hasSubmenu]) {
			if (([item submenu] == [NSApp servicesMenu]) || // Don't include the service menu
				([item tag] == MENU_FORMAT)) // Don't include the "Format" menu
				continue;
			
			[superNode addSubnode:[self _createOVNodesForMenu:[item submenu] level:(level+1) 
													 isOddRow:odd actionNodes:actionNodes]]; // recursion
																							 // Menuitem
		} else {
			if ([item isSeparatorItem] || ([item tag] == NO_MENU_ACTION)) // Skip separators
				continue;
			
			node = [FFInputEventOVNode nodeWithTitle:[item title]
									 backgroundColor:m_inputOVBgCols[level+1][odd]
										   andAction:[item tag]];
			[superNode addSubnode:node];
			actionNodes[[item tag]] = node;
		}
		odd ^= TRUE;
	}
	
	return superNode;
}

- (void)_insertInputEventsIntoActionNodes:(FFInputEventOVNode*[])actionNodes {
	NSEnumerator*		en	= [m_prefs inputEventEnumerator];
	FFInputEvent*		ev;
	FFInputEventOVNode*	node, *newNode;
	
	while (ev = [en nextObject]) {
		node = actionNodes[[ev action]]; // also "nil" if the action was removed
		
		if ([node event] != nil) { // Not the first event for this action
			newNode = [FFInputEventOVNode nodeWithTitle:@""
										backgroundColor:[node backgroundColor]
											  andAction:[ev action]];
			[node insertNodeAfterThisNode:newNode];
			[newNode setEvent:ev];
			actionNodes[[ev action]] = newNode;
		} else
			[node setEvent:ev];
	}
}

- (void)_setupInputEvents {
	FFInputEventOVNode* lastNodeOfAction[ABOVE_LAST_MENU_ACTION];
	NSArray*			altRowCols;
	
	// The background colors ([0][x] = root	
	altRowCols = [NSColor controlAlternatingRowBackgroundColors];	
	
	m_inputOVBgCols[1][0]	= [[altRowCols objectAtIndex:0] retain];
	m_inputOVBgCols[1][1]	= [[altRowCols objectAtIndex:1] retain];
	m_inputOVBgCols[2][0]	= [[m_inputOVBgCols[1][0] shadowWithLevel:0.1] retain];
	m_inputOVBgCols[2][1]	= [[m_inputOVBgCols[1][1] shadowWithLevel:0.1] retain];
	m_inputOVBgCols[3][0]	= [[m_inputOVBgCols[2][0] shadowWithLevel:0.1] retain];
	m_inputOVBgCols[3][1]	= [[m_inputOVBgCols[2][1] shadowWithLevel:0.1] retain];
	
	// Spacing
	[m_inputEventsOV setIntercellSpacing:NSMakeSize(1.0, 0.0)];
	
	// Build the node tree out of the main menu
	memset(lastNodeOfAction, nil, sizeof(FFInputEventOVNode*)*ABOVE_LAST_MENU_ACTION);
	m_inputOVRootNode = [[self _createOVNodesForMenu:[NSApp mainMenu] level:0 isOddRow:FALSE
										 actionNodes:lastNodeOfAction] retain];
	[self _insertInputEventsIntoActionNodes:lastNodeOfAction];
	[m_inputEventsOV reloadData];
}

- (void)awakeFromNib {
	[m_window setDelegate:self];
	m_nc = [NSNotificationCenter defaultCenter];
	
	[self _setupToolbarAndViews];
	[self _setupOutlets];
	[self _setupInputEvents];
	
	[m_window center];
}

- (void)show {
	[m_prefs setNeedToSave:TRUE];
	[m_window makeKeyAndOrderFront:self];	
}

// Something I wanted to try out ... small speedup
+ (FFPrefsController*)showWithExitingController:(FFPrefsController*)controller 
								 andPreferences:(FFPreferences*)prefs {
	FFPrefsController* ctrl;
	
	// Shown for the first time
	if (controller == nil)
		ctrl = [[self alloc] initWithPreferences:prefs];
	else
		ctrl = controller;
	
	[ctrl show];			
	return ctrl;
	
}

- (IBAction)saveOptsToggled:(id)sender {
	[m_prefs setSaveOpts:[sender state]];
}

- (IBAction)ringBufSizeModified:(id)sender {
	int maxFd, rbs;
	
	// Update text and prefs
	rbs = [m_advRingBufSize intValue];
	[m_advRingBufSizeText setIntValue:rbs];
	[m_prefs setRingBufferSize:rbs];
	
	// Update fetch distance (value & max)
	maxFd = (rbs-1) >> 1;
	if ([m_advFetchDistance intValue] > maxFd) {
		[m_advFetchDistance setIntValue:maxFd];
		[m_advFetchDistanceText setIntValue:maxFd]; // No idea why updating the stepper isn't enough
		[m_prefs setFetchDistance:maxFd];
	}
	[m_advFetchDistance setMaxValue:maxFd];	
}

- (IBAction)fetchDistanceModified:(id)sender {
	int fd = [m_advFetchDistance intValue];
	[m_advFetchDistanceText setIntValue:fd];
	[m_prefs setFetchDistance:fd];
}

- (IBAction)slideshowTimeModified:(id)sender {
	[m_generalSlideshowTimeText setIntValue:[m_generalSlideshowTime intValue]];
	[m_prefs setSlideshowTime:[m_generalSlideshowTime doubleValue]];
}

- (IBAction)controlPanningToggled:(id)sender {
	[m_prefs setCtrlForPanning:[sender state]];
}

- (IBAction)relativePanningToggled:(id)sender {
	[m_prefs setRelativePanning:[sender state]];
}

- (IBAction)borderlessWindowToggled:(id)sender {
	BOOL on = ([m_generalBorderlessWin state] == NSOnState);
	[m_prefs setBorderlessWin:on];
	[m_generalWinLevel setEnabled:on];
}

- (IBAction)windowLevelModified:(id)sender {
	int idx = [m_generalWinLevel indexOfSelectedItem];
	
	if (idx == 0)
		[m_prefs setWinLevel:NSNormalWindowLevel];
	else if (idx == 1)
		[m_prefs setWinLevel:NSSubmenuWindowLevel];
	else
		[m_prefs setWinLevel:kCGDesktopWindowLevel];
//		[m_prefs setWinLevel:(NSNormalWindowLevel - 1)];
}

- (IBAction)listWrapModified:(id)sender {
	int sel = [m_listWrap indexOfSelectedItem];
	if (sel != -1)
		[m_prefs setListWrap:(FFPrefListWrap)sel];
}

- (IBAction)trashDeleteToggled:(id)sender {
	[m_prefs setTrashDelete:([m_listTrashDelete state] == NSOnState)];
}

- (void)_dirRootOpenPanelDidEnd:(NSOpenPanel*)panel 
					 returnCode:(int)returnCode contextInfo:(void*)contextInfo {
	if (returnCode == NSCancelButton)
		return;
	[m_listDirRoot setStringValue:[panel filename]];
	[m_prefs setDirectoryRoot:[panel filename]];
}

- (IBAction)changeDirectoryRoot:(id)sender {
	NSOpenPanel* op = [NSOpenPanel openPanel];
	[op setCanChooseDirectories:TRUE];
	[op setCanChooseFiles:FALSE];
		
	[op beginSheetForDirectory:[m_prefs directoryRoot] file:nil types:nil 
				modalForWindow:m_window modalDelegate:self
				didEndSelector:@selector(_dirRootOpenPanelDidEnd:returnCode:contextInfo:) 
				   contextInfo:NULL];
}

- (IBAction)wheelSpeedupModified:(id)sender {
	float   su = [m_panWheelSpeedup floatValue];
	[m_panWheelSpeedUpText setFloatValue:su];
	[m_prefs setMouseWheelSpeedup:su];
}

- (IBAction)normalShiftModified:(id)sender {
	int cs = [m_panNormalShift intValue];
	[m_panNormalShiftText setIntValue:cs];
	[m_prefs setNormalCursorShift:(unsigned)cs];
}

- (IBAction)acceleratedShiftModified:(id)sender {
	int cs = [m_panAcceleratedShift intValue];
	[m_panAcceleratedShiftText setIntValue:cs];
	[m_prefs setAcceleratedCursorShift:(unsigned)cs];
}

- (IBAction)keepMouseHiddenToggled:(id)sender {
	[m_prefs setKeepMouseHidden:([m_generalKeepMouseHidden	state] == NSOnState)];
}

- (IBAction)listWinHiddenToggled:(id)sender {
	[m_prefs setListWinHiddenOnStartup:([m_listWinHiddenOnStartup state] == NSOnState)];
}

- (IBAction)windowBackgroundAutoToggled:(id)sender {
	BOOL autoOn = [m_generalWinBackgroundAuto state] == NSOnState;
	[m_prefs setWinBackgroundAuto:autoOn];
	[m_generalWinBackgroundCol setEnabled:!autoOn];
}

- (IBAction)windowBackgroundColorModified:(id)sender {
	[m_prefs setWinBackgroundColor:[m_generalWinBackgroundCol color]];
}

- (IBAction)doublePageAlignmentModified:(id)sender {
	[m_prefs setDoublePageAlignment:[m_generalDoublePageAligment tagOfSelectedItem]];
}

- (IBAction)addInputEvent:(id)sender {
	[self _addInputEvent];
}

- (IBAction)removeInputEvent:(id)sender {
	[self _removeInputEvent];
}

- (IBAction)changeInputEvent:(id)sender {
	[self _changeInputEvent];
}

- (IBAction)collapseInputEvents:(id)sender {
	NSEnumerator*		en = [m_inputOVRootNode subnodeEnumerator];
	FFInputEventOVNode*	node;
	
	while (node = [en nextObject])
		if ([m_inputEventsOV isExpandable:node])
			[m_inputEventsOV collapseItem:node collapseChildren:TRUE];
}

- (IBAction)expandInputEvents:(id)sender { // why isn't this in the framework?
	NSEnumerator*		en = [m_inputOVRootNode subnodeEnumerator];
	FFInputEventOVNode*	node;
	
	while (node = [en nextObject])
		if ([m_inputEventsOV isExpandable:node])
			[m_inputEventsOV expandItem:node expandChildren:TRUE];
}

#pragma mark -
#pragma mark NSWindow delegate methods

- (void)windowWillClose:(NSNotification*)notification {
	[m_prefs save];
	[m_prefs setNeedToSave:FALSE];
}

- (void)windowDidBecomeMain:(NSNotification*)notification {
	[NSApp setForwardAll:TRUE];
}

- (void)windowDidResignMain:(NSNotification*)not {
	[NSApp setForwardAll:FALSE];
}

#pragma mark -
#pragma mark Toolbar methods 

- (NSToolbarItem*)toolbar:(NSToolbar*)tb itemForItemIdentifier:(NSString*)ident 
	willBeInsertedIntoToolbar:(BOOL)flag {
	return [[m_toolbarItems objectForKey:ident] objectForKey:ItemKey];
}

- (NSArray*)toolbarAllowedItemIdentifiers:(NSToolbar*)tb {
	return m_toolbarIdents;
}

- (NSArray*)toolbarDefaultItemIdentifiers:(NSToolbar*)tb {
	return m_toolbarIdents;
 }

- (NSArray*)toolbarSelectableItemIdentifiers:(NSToolbar*)tb {
	return m_toolbarIdents;
}

#pragma mark -
#pragma mark Change content view

- (void)_setNewContentView:(NSView*)view withLabel:(NSString*)label {
	float	newWinHt;
	NSRect 	winFrame, newFrame;
	
	// Already set
	if ([m_window contentView] == view)
		return;

	// Calculate new frame
	newWinHt = NSHeight([view frame]);
	if ([[m_window toolbar] isVisible])
		newWinHt += NSHeight([[[m_window toolbar] _toolbarView] frame]);

	winFrame = [NSWindow contentRectForFrameRect:[m_window frame] styleMask:[m_window styleMask]];
	newFrame = [NSWindow frameRectForContentRect:NSMakeRect(NSMinX(winFrame), NSMaxY(winFrame) - newWinHt,  NSWidth(winFrame), newWinHt) styleMask:[m_window styleMask]];

	// Update the window title
	[m_window setTitle:[FFTR(@"Preferences: ") stringByAppendingString:label]];

	// Set view and resize frame
	[m_window setContentView:view];
	[m_window setFrame:newFrame display:TRUE animate:TRUE];
}

- (void)_toolbarItemClicked:(id)sender {
	NSString* ident	= [sender itemIdentifier];
	NSString* label	= ToolbarItemLabels[[m_toolbarIdents indexOfObject:ident]];
	
	[self _setNewContentView:[[m_toolbarItems objectForKey:ident] objectForKey:ViewKey]
		withLabel:label];
}

#pragma mark -
#pragma mark TextField delegate methods

- (void)controlTextDidChange:(NSNotification*)not {
	NSTextField* tf = [not object];
	
	// Zoom factor
	if (tf == m_generalZoomFactor) {
		float zf = [tf floatValue];
		if (zf > 0.0f)
			[m_prefs setZoomFactor:zf];

	} else {
		int val = [tf intValue];
		if (val > 0) {
			if (tf == m_generalMagLensWidthText) {
				[m_prefs setMagnifyingLensWidth:val];
				[m_prefs setMagnifyingLensHeight:val];
				[m_generalMagLensHeightText setIntValue:val];
			} else if (tf == m_generalMagLensHeightText) {
				[m_prefs setMagnifyingLensHeight:val];
			} else if (tf == m_listThumbWidthText) {
				[m_prefs setThumbWidth:val];
				[m_prefs setThumbHeight:val];
				[m_listThumbHeightText setIntValue:val];
			} else if (tf == m_listThumbHeightText) {
				[m_prefs setThumbHeight:val];
			}
		}
	}
}

#pragma mark -
#pragma mark Input event outlineview datasource methods

- (int)outlineView:(NSOutlineView*)ov numberOfChildrenOfItem:(id)item {
	if (item == nil) // root
		return [m_inputOVRootNode numberOfSubnodes];
	return ([item hasSubnodes] ? [item numberOfSubnodes]  : 0);
}

- (BOOL)outlineView:(NSOutlineView*)ov isItemExpandable:(id)item {
	return [item hasSubnodes];
}

- (id)outlineView:(NSOutlineView*)ov child:(int)index ofItem:(id)item {
	if (item == nil) // root
		return [m_inputOVRootNode subnodeAtIndex:index];
	return [item subnodeAtIndex:index];
}

- (id)outlineView:(NSOutlineView*)ov objectValueForTableColumn:(NSTableColumn*)col byItem:(id)item {
	if ([[col identifier] isEqualToString:ActionColIdent])
		return [item title];
	if ([[col identifier] isEqualToString:EventColIdent])
		return [item eventAsString];
	
	if ([[col identifier] isEqualToString:AddColIdent])
		return @"+";
	
	return nil; // Buttons
}

#pragma mark -
#pragma mark Input event outlineView delegate methods

- (void)outlineView:(NSOutlineView*)ov willDisplayCell:(id)cell forTableColumn:(NSTableColumn*)col item:(id)item {
	if (![[col identifier] isEqualToString:ActionColIdent] &&
		![[col identifier] isEqualToString:EventColIdent]) {

		if ([item hasSubnodes])
			[cell setHidden:TRUE];
		else if (([item event] == nil) && (![[col identifier] isEqualToString:AddColIdent]))
			[cell setHidden:TRUE]; // No event assigned yet
		else {
			[cell setHidden:FALSE];
			[cell setRepresentedObject:item];
		}
	} else
		[cell setDrawsBackground:TRUE];

	[cell setBackgroundColor:[item backgroundColor]];
}

- (BOOL)outlineView:(NSOutlineView*)ov shouldSelectItem:(id)item {
	return TRUE;
}

#pragma mark -
#pragma mark Input event modification methods

- (void)_fixNewEvent:(FFInputEvent*)newEvent selectedNode:(FFInputEventOVNode*)node {
	NSString*	script;
	
	[newEvent setAction:[node action]];
	if ([newEvent isAssignedToScript]) {
		for (;;) {
			script = [node title];
			if (![script isEqualToString:@""])
				break;
			
			node = [node previousNode];
		}
		[newEvent setScript:script];
	}
}

- (void)_addInputEvent {
	FFInputEvent* newEvent	= [m_inputEventSheet getEventWithWindow:m_window andInputEvent:nil];

	// Accept clicked
	if (newEvent != nil) {
		FFInputEventOVNode* node, *newNode;
		BOOL isNewNode;
		
		node = [m_inputEventsOV itemAtRow:[m_inputEventsOV selectedRow]];
		[self _fixNewEvent:newEvent selectedNode:node];

		FFLOG(4, @"new Event(add) = %@", newEvent)
		
		// Insert node
		if (![newEvent isAssignedToScript])
			isNewNode = ([[node superNode] numberOfSubnodesWithEventAndAction:[node action]] > 0);
		else
			isNewNode = ([[node superNode] numberOfSubnodesWithEventAndTitle:[node title]] > 0);

		if (isNewNode) {
			newNode = [FFInputEventOVNode nodeWithTitle:@""
										backgroundColor:[node backgroundColor]
											  andAction:[node action]];
			[newNode setEvent:newEvent];
			[node insertNodeAfterThisNode:newNode];

			// Keep event order
			[m_prefs insertInputEvent:newEvent after:[node event]];

		// Assign event to (empty) node
		} else {
			[node setEvent:newEvent];
			[m_prefs addInputEvent:newEvent];
		}

		// Update the OV
		[m_inputEventsOV reloadItem:[node superNode] reloadChildren:TRUE];
	}
}

- (void)_removeInputEvent {
	FFInputEventOVNode* node, *superNode;
		
	node		= [m_inputEventsOV itemAtRow:[m_inputEventsOV selectedRow]];
	superNode	= [node superNode];

	[m_prefs removeInputEvent:[node event]];
	if ([superNode numberOfSubnodesWithEventAndAction:[node action]] == 1) // Don't remove the row
		[node resetEvent];
	else
		[superNode removeSubnode:node];
	
	[m_inputEventsOV reloadItem:superNode reloadChildren:TRUE];
}

- (void)_changeInputEvent {
	FFInputEventOVNode* node	= [m_inputEventsOV itemAtRow:[m_inputEventsOV selectedRow]];
	FFInputEvent* newEvent		= [m_inputEventSheet getEventWithWindow:m_window andInputEvent:[node event]];

	// Accept clicked
	if (newEvent != nil) {
		[self _fixNewEvent:newEvent selectedNode:node];

		FFLOG(4, @"new Event(change) = %@", newEvent)		
		
		[m_prefs replaceInputEvent:[node event] with:newEvent];
		[node setEvent:newEvent];
		[m_inputEventsOV reloadItem:node]; 
	}
}

@end
