// $Id: FFInputEventSheet.h 407 2005-06-08 20:33:42Z ravemax $

@class FFInputEvent;

@interface FFInputEventSheet : NSObject {
	// Outlet : General
    IBOutlet NSWindow*		m_win;
    IBOutlet NSMatrix*		m_type;
    IBOutlet NSTextField*	m_warning;
    IBOutlet NSButton*		m_acceptButton;

	// Outlet : Key
    IBOutlet NSButton*		m_keyModCmd;
    IBOutlet NSButton*		m_keyModShift;
    IBOutlet NSButton*		m_keyModOpt;
    IBOutlet NSButton*		m_keyModCtrl;
    IBOutlet NSButton*		m_keyModNum;
    IBOutlet NSTextField*	m_keyEquiv;
    IBOutlet NSPopUpButton*	m_keySpecial;
	
	// Outlet : Button
    IBOutlet NSButton*		m_btnModShift;
    IBOutlet NSButton*		m_btnModOpt;
    IBOutlet NSButton*		m_btnModCtrl;
    IBOutlet NSPopUpButton*	m_btnButton;
	
	// Outlet : Speech
    IBOutlet NSTextField*	m_spCommand;
	
	// Internal
	FFInputEvent*			m_curEvent;
	NSArray*				m_specialKeyIndexToKey;
	NSSpeechSynthesizer*	m_synth;
}

// Don't call directly!
- (IBAction)widgetModified:(id)sender;
- (IBAction)accept:(id)sender;
- (IBAction)cancel:(id)sender;
- (IBAction)testCommand:(id)sender;

// Exported methods
- (FFInputEvent*)getEventWithWindow:(NSWindow*)win andInputEvent:(FFInputEvent*)event;

@end
