// $Id: FFTile.h 559 2006-08-20 14:15:11Z ravemax $

#import <OpenGL/gl.h>

#define NO_TEXTURE	UINT_MAX

@interface FFTile : NSObject {
@public
	GLuint		width, height;
	float		x, y;
@private
	GLuint		m_texName;

	// Only set if the creation of the texture fails during loading
	GLubyte*	m_texData;
	GLint		m_texRowLen, m_texSkipPx, m_texSkipRows;
}

// Must be called within an existing context
- (id)initWithData:(GLubyte*)data dataWidth:(GLuint)dataWidth
			 dataX:(GLint)dataX dataY:(GLint)dataY
			 width:(GLuint)wd height:(GLuint)ht
		  initialX:(float)ix initialY:(float)iy;

// All necessary GL option have to set already
// Must be called within an existing context
- (void)draw;

// Single line, no line break
- (NSString*)description;

@end
