// $Id: FFPageView.h 595 2006-09-30 19:11:14Z ravemax $

#import <OpenGL/gl.h>
#import <OpenGL/glext.h>

typedef enum {
	ALIGNMENT_TOP = 0,
	ALIGNMENT_CENTER,
	ALIGNMENT_BOTTOM
} FFDoublePageAlignment;

@class FFPage;
@class FFOptions;
#ifdef FFVIEW_APPLICATION
	@class FFOSD;
	@class FFShadowRectImage;
#endif

// Size of the page array (2 should be already be enough)
#define MAX_NUM_PAGES 5

@interface FFPageView : NSOpenGLView {
@public
	float					width, height; // view size
@private
	FFOptions*				m_opts;
	id						m_eventHandler;
	BOOL					m_bgAuto;
	GLfloat					m_bgColor[3]; // r,g,b
	FFDoublePageAlignment	m_dpAlignment;
	NSCursor*				m_cursor;
	GLint					m_maxTileSize;
	BOOL					m_needsLayout;

#ifdef FFVIEW_APPLICATION
	// OSD
	FFOSD*					m_OSD;
	GLfloat					m_OSDX, m_OSDY;
#endif
	
	// Page related
	int						m_numPages;
	FFPage*					m_pages[MAX_NUM_PAGES]; // weak
	GLfloat					m_totalWd, m_totalHt;
	GLfloat					m_totalWdSR, m_totalHtSR; // scaled+rotated
	
	// Layout
	GLfloat					m_angle;
	GLfloat					m_scaleFactor;
	BOOL					m_panX, m_panY;
	GLfloat					m_x, m_y; // -=left/top, +=right/bottom
	GLfloat					m_minX, m_minY, m_maxX, m_maxY;
	GLfloat					m_relativeX, m_relativeY;

	// Event
	BOOL					m_mouseDrag;

#ifdef FFVIEW_APPLICATION
	// Magnifying lens
	float					m_lensWidth, m_lensHeight;
	FFShadowRectImage*		m_lensRectImg;
	GLfloat					m_lensZoom;
	BOOL					m_lensEnabled;
	BOOL					m_lensVisible;
	float					m_lensMouseX, m_lensMouseY;
	GLfloat					m_lensViewportX, m_lensViewportY;
	GLfloat					m_lensX, m_lensY;
	GLfloat					m_lensFrameX, m_lensFrameY;
#endif // FFVIEW_APPLICATION
}

// May return nil if something fails
// Auto background w/ col = nil
// maxTileSize = 0 -> texture size / 2
#ifdef FFVIEW_APPLICATION
	- (id)initWithOptions:(FFOptions*)opts
		  backgroundColor:(NSColor*)col
				 lensSize:(NSSize)lensSize
				 lensZoom:(GLfloat)lensZoom
	  doublePageAlignment:(FFDoublePageAlignment)dpa
			  maxTileSize:(int)maxTileSize
			 eventHandler:(id)handler
				   andOSD:(FFOSD*)OSD;
#else
	- (id)initWithOptions:(FFOptions*)opts
		  backgroundColor:(NSColor*)col
	  doublePageAlignment:(FFDoublePageAlignment)dpa
			  maxTileSize:(int)maxTileSize
		  andEventHandler:(id)handler;
#endif

- (void)addPage:(FFPage*)page;
- (void)removeAllPages;
- (void)finishedAdding;

- (NSSize)preferredSize;
- (void)doLayout;
- (void)doLayoutAndDisplay;

- (GLint)maxTileSize;
- (void)readBufferWithWidth:(GLint)wd andHeight:(GLint)ht intoBuffer:(GLubyte*)buffer;

#ifdef FFVIEW_APPLICATION
	- (void)updateMagnifyingLensPoint:(NSPoint)pt; 
	- (void)showMagnifyingLensAtPoint:(NSPoint)pt;
	- (void)hideMagnifyingLens;
#endif

// False=no panning - nothing changed
- (BOOL)panWithDeltaX:(float)x andDeltaY:(float)y relative:(BOOL)relative;
- (BOOL)pageUp;
- (BOOL)pageDown;
- (BOOL)canPageUp;
- (BOOL)canPageDown;
- (BOOL)canMoveLeft;
- (BOOL)canMoveRight;

// nil = auto
// No refresh
- (void)setBackgroundColor:(NSColor*)col;
- (void)setDoublePageAlignment:(FFDoublePageAlignment)dpa;

// nil = no special cursor for the view
- (void)setCursor:(NSCursor*)cursor;

// Own refresh validation code 
- (void)setNeedsLayout:(BOOL)flag;
- (BOOL)needsLayout;
- (void)doLayoutAndDisplayIfNeeded;

// Multiple lines, line breaks
- (NSString*)description;

// Forward declarations
#ifdef FFVIEW_APPLICATION
	- (BOOL)_calcMagnifyingLens;
#endif
- (void)_autoBackgroundColor;

@end

#pragma mark -
#pragma mark Event handler

@interface NSObject (PageViewEventHandler)

// NSResponder methods
- (void)mouseMoved:(NSEvent*)event;
- (void)flagsChanged:(NSEvent*)event;
- (void)scrollWheel:(NSEvent*)event;
- (void)rightMouseDown:(NSEvent*)event;
- (void)rightMouseUp:(NSEvent*)event;
- (void)rightMouseDragged:(NSEvent*)event;

// Special methods
- (void)pageClicked:(int)no;

@end
