RCS_ID("$Id: FFPage.m 495 2005-09-26 16:15:17Z ravemax $")

#import "FFPage.h"
#import <math.h>
#import "FFPageView.h"
#import "FFTile.h"
#import "FFImageLoader.h"
#import "FFImageFile.h"

@implementation FFPage

- (id)initWithView:(FFPageView*)view {
	self = [super init];
	if (self != nil) {
		self->m_view		= view;
		self->m_numTiles	= 0;
		self->m_maxTileSize = [view maxTileSize];
		self->data			= NULL;
		self->fileIndex		= FILE_INDEX_UNDEFINED;
	}
	return self;
}

- (void)reset {
	if (m_numTiles > 0) {
		[[m_view openGLContext] makeCurrentContext];

		int	i;
		for (i = 0; i < m_numTiles; i++)
			[m_tiles[i] release];
		free(m_tiles);
		m_numTiles	= 0;
		
		free(data);
	}
	fileIndex = FILE_INDEX_UNDEFINED;
}

- (void)dealloc {
	[self reset];
	[super dealloc];
}

- (void)loadImageWithFilename:(NSString*)fname andFileIndex:(unsigned)findex {
	int		numRows, numCols;
	int		row, col, tileIndex;
	GLint	dataX, dataY;
	float	initY, halfwidth;
	GLuint	tileWd, lastWd, tileHt;
	
	// Reset
	[self reset];
	
	// Load the image
	loadImage(fname, &data, &width, &height, &depth);
	FFLOG(6, @"FFPage: LoadImageWithFilename %@, %u x %u", fname, width, height);
			  
	numRows		= (int)ceil((float)height / m_maxTileSize);
	numCols		= (int)ceil((float)width / m_maxTileSize);
	m_numTiles	= numRows * numCols;
	m_tiles		= (FFTile**)malloc(m_numTiles * sizeof(FFTile*));

	// Create tiles
	tileIndex	= 0;
	lastWd		= width - (numCols-1)*m_maxTileSize; // Modulo doesn't work
	dataY		= 0;
	halfwidth	= (float)width / 2;
	initY		= (float)height / 2;
		
	FFLOG(6, @"FFPage: LoadImageWithFilename: numRows=%d, numCols=%d -> numTiles=%d",
		  numRows, numCols, m_numTiles);
	
	[[m_view openGLContext] makeCurrentContext]; // Req. for the texture
	
	for (row = 0; row < numRows; row++) {
		tileHt = (row < numRows-1) ? m_maxTileSize : height - ((numRows-1)*m_maxTileSize);
		dataX	= 0;
		initY	-= tileHt;
		
		for (col = 0; col < numCols; col++) {
			tileWd	= (col < numCols-1) ? m_maxTileSize : lastWd;
			
			m_tiles[tileIndex++] = [[FFTile alloc] initWithData:data dataWidth:width
														  dataX:dataX dataY:dataY
														  width:tileWd height:tileHt
													   initialX:ceilf(dataX - halfwidth)
													   initialY:ceilf(initY)];
			dataX += m_maxTileSize;
		}
		dataY += m_maxTileSize;
	}
	
	// Everything worked out - store the file index
	fileIndex = findex;
}

- (void)draw {
	FFLOG(6, @"FFPage: Draw: x=%4.2f, y=%4.2f", x, y);
	
	glPushMatrix();
	glTranslatef(x, y, 0.0f);
	
	int	i;	
	for (i = 0; i < m_numTiles; i++)
		[m_tiles[i] draw];

	glPopMatrix();
}

- (NSString*)description {
	NSMutableString* dm;
	
	dm = [NSMutableString stringWithFormat:@"FFPage %u (%p): %ux%u,%u @ %.1f,%.1f",
		fileIndex, self, width, height, depth, x, y];
	
	if (m_numTiles > 0) {
		int i;
		for (i = 0; i < m_numTiles; i++)
			[dm appendFormat:@"\n%@", [m_tiles[i] description]];
	} else
		[dm appendString:@" <no tiles>"];
		
	return dm ;
}

@end
