// $Id: FFPage.h 495 2005-09-26 16:15:17Z ravemax $

#import <OpenGL/gl.h>

@class FFTile, FFPageView;

@interface FFPage : NSObject {
@public
	unsigned	fileIndex;
	GLubyte*	data; // ARGB
	GLuint		width, height, depth;
	float		x, y;
@private
	FFPageView*	m_view; // weak reference
	GLint		m_maxTileSize;
	unsigned	m_numTiles;
	FFTile**	m_tiles; // Array of FFTile*
}

- (id)initWithView:(FFPageView*)view;
- (void)reset;

// Executes "reset".
// Throws an exception if loading fails
- (void)loadImageWithFilename:(NSString*)fname andFileIndex:(unsigned)findex;
   
// Must be called within an existing context
- (void)draw;

// Multiple lines, line breaks
- (NSString*)description;

@end

#pragma mark -
#pragma mark Page helper routines

static inline NSString* pageInfo(FFPage* page) {
	return (page != nil) ? 
	[NSString stringWithFormat:@"%u x %u, %u bit", page->width, page->height, page->depth] :
	@"<no page>";
}
