#ifndef __FF_GLOBAL_H__
#define __FF_GLOBAL_H__

// $Id: FFGlobal.h 458 2005-07-16 19:27:58Z ravemax $

// #define FF_DEBUG_MODE
// Should be set in "Project Info" -> GNU Compiler -> Preprocesor Macros" 
// depending on the build style.

/*
 *  Logging
 */
#ifdef FF_DEBUG_MODE

extern int FFLogLevel;

	#define FFLOG(LEVEL, ...) { \
		if (LEVEL >= FFLogLevel) \
			NSLog(@"[%@:%d] %@", \
				  [[NSString stringWithCString:__FILE__] lastPathComponent], __LINE__, \
				  [NSString stringWithFormat:__VA_ARGS__]); \
	}

#else
	#define FFLOG(LEVEL, ...)
#endif

// Localization
#define FFTR(TEXT)			NSLocalizedString(TEXT, @"<no arguments>")
#define FFTRC(TEXT, CMT)	NSLocalizedString(TEXT, CMT)

// SCM 
#import "rcsid.h"

#endif // !__FF_GLOBAL_H__
