RCS_ID("$Id: FFOSD.m 425 2005-06-09 15:39:06Z ravemax $")

#import "FFOSD.h"
#import <stdlib.h>
#import "NSBezierPath_Additions.h"

@implementation FFOSD

#pragma mark -
#pragma mark Initialiasation and cleanup

- (void)_setupFontAttributes {
	NSShadow*	shd;

	// The shadow
	shd = [[NSShadow alloc] init];
	[shd setShadowBlurRadius:2.0];
	[shd setShadowColor:[NSColor blackColor]];
	[shd setShadowOffset:NSMakeSize(3.0, -3.0)];
	
	// Filename attributes
	m_fnFontAttrib = [[NSDictionary alloc] initWithObjectsAndKeys:
		[NSFont systemFontOfSize:22], NSFontAttributeName,
		[NSColor whiteColor], NSForegroundColorAttributeName,
		[shd autorelease], NSShadowAttributeName,
		nil];
	
	// Info attributes
	m_infoFontAttrib = [[NSDictionary alloc] initWithObjectsAndKeys:
		[NSFont systemFontOfSize:14], NSFontAttributeName,
		[NSColor lightGrayColor], NSForegroundColorAttributeName,
		[shd autorelease], NSShadowAttributeName,
		nil];	
}

- (float)_setupStateImageGroup:(FFOSDStateImage[])imgs number:(int)num startingAtX:(float)x
				withName:(NSString*)name {
	int		i, j;
	NSPoint p;
	
	p   = NSMakePoint(x, m_padding);	
	for (i = 0; i < num; i++) {
		for (j = 0; j < NUM_OSD_IMG_STATE; j++)
			imgs[i].img[j] = [[NSImage imageNamed:[NSString stringWithFormat:@"%@_%d-%d", name, i, j]] retain];
		imgs[i].origin = p;
		p.x += m_iconSize;
	}
	return (p.x+m_iconSpacing);
}

- (void)_updateStateImageGroup:(FFOSDStateImage[])imgs number:(int)num active:(int)active {
	// Deselect all
	int i;
	for (i = 0; i < num; i++)
		imgs[i].activeImg = imgs[i].img[OSD_IMG_NORMAL];
	
	// Select the active button
	imgs[active].activeImg = imgs[active].img[OSD_IMG_SELECTED];
}

#define UPDATE_SINGLE_STATE_IMAGE(IMG, STATE) \
	(IMG).activeImg = (IMG).img[(STATE)];

- (void)_setupStateImages {
	float   ix;
	
	// Load all images + calc origin
	ix  = [self _setupStateImageGroup:m_imgRotation number:OPT_NUM_ROTATION startingAtX:m_padding
							 withName:@"info_rot"];
	ix  = [self _setupStateImageGroup:m_imgScaling number:OPT_NUM_SCALING startingAtX:ix
							 withName:@"info_scale"];
	ix  = [self _setupStateImageGroup:m_imgAntialiasing number:1 startingAtX:ix
							 withName:@"info_aa"];
		[self _setupStateImageGroup:m_imgNoBlowUp number:1 startingAtX:ix
						   withName:@"info_noblowup"];

	// Highlight the options
	[self _updateStateImageGroup:m_imgRotation number:OPT_NUM_ROTATION active:[m_opts rotation]];
	[self _updateStateImageGroup:m_imgScaling number:OPT_NUM_SCALING active:[m_opts scaling]];
	UPDATE_SINGLE_STATE_IMAGE(m_imgAntialiasing[0], (int)[m_opts antialiasing]);
	UPDATE_SINGLE_STATE_IMAGE(m_imgNoBlowUp[0], (int)[m_opts noBlowUp]);	
}

- (id)initWithOptions:(FFOptions*)opts {
	self = [super init];
    if (self) {		
		m_opts = [opts retain];
		
		// May set by a setter later...
		m_radius		= 20.0;
		m_backgroundCol = [[NSColor colorWithCalibratedRed:0.0 green:0.0 blue:0.0 alpha:0.6] retain];
		m_padding		= 14.0;
		m_iconSize		= 34;
		m_iconSpacing   = 6.0;
		m_iconBoxWd		= 9*m_iconSize+3*m_iconSpacing; // 8 = number of icons
		m_filename		= m_information		= nil;
		m_filename2		= m_information2	= nil;
		m_baseTextPoint	= NSMakePoint(m_padding, (m_padding*2)+m_iconSize);
		m_textSpacing   = 4;
	
		// Generated OSD image and assoc. vars
		m_width				= 0;
		m_height			= 0;
		m_genImage			= nil;
		m_genBitmapRep		= nil;
		m_bitmapLock		= [[NSLock alloc] init];
		m_visible			= FALSE;
		
		// Complex initialisations
		[self _setupFontAttributes];
		[self _setupStateImages];
	}
	return self;
}

- (void)_freeStateImageGroup:(FFOSDStateImage[])imgs number:(int)num {
	int i, j;
	for (i = 0; i < num; i++)
		for (j = 0; j < NUM_OSD_IMG_STATE; j++)
			[imgs[i].img[j] release];
}

- (void)_freeStateImages {
	[self _freeStateImageGroup:m_imgRotation number:OPT_NUM_ROTATION];
	[self _freeStateImageGroup:m_imgScaling number:OPT_NUM_SCALING];
	[self _freeStateImageGroup:m_imgAntialiasing number:1];
	[self _freeStateImageGroup:m_imgNoBlowUp number:1];	
}

- (void)dealloc {	
	if (m_genImage != nil) {
		[m_genBitmapRep release];
		[m_genImage release];
		[m_rectPath release];
	}
	[m_bitmapLock release];

	[self _freeStateImages];

	[m_opts release];
	if (m_filename != nil)
		[m_filename release];
	if (m_information != nil)
		[m_information release];
	if (m_filename2 != nil) {
		[m_filename2 release];
		[m_information2 release];
	}
	[m_backgroundCol release];
	
	[super dealloc];
}

#pragma mark -
#pragma mark Generating the OSD

- (void)_calculateImageSize {
	NSSize  swa;
	float   wd, ht;

	// Compare icon box width with filename width
	swa = [m_filename sizeWithAttributes:m_fnFontAttrib];
	if (swa.width < m_iconBoxWd)
		wd = m_iconBoxWd;
	else
		wd = swa.width;
	ht = swa.height;
	
	// Handle informatiom width and height
	#define ADJUST_WD_AND_HT(VAR, FONT) \
		swa = [VAR sizeWithAttributes:FONT]; \
		if (wd < swa.width) \
			wd = swa.width; \
		ht	+= swa.height+m_textSpacing

	if (m_information != nil) {
		m_infoPoint	= m_baseTextPoint;
		ADJUST_WD_AND_HT(m_information, m_infoFontAttrib);
		m_fnPoint   = NSMakePoint(m_baseTextPoint.x, m_baseTextPoint.y+swa.height+m_textSpacing);
	} else
		m_fnPoint	= m_baseTextPoint;

	// 2nd filename & information
	if (m_filename2 != nil) {
		float htToAdd = ht;
		m_info2Point = m_infoPoint;
		ADJUST_WD_AND_HT(m_information2, m_infoFontAttrib);
		m_fn2Point = NSMakePoint(m_info2Point.x, m_info2Point.y+swa.height+m_textSpacing);
		ADJUST_WD_AND_HT(m_filename2, m_fnFontAttrib);

		htToAdd -= ht; // negative value!

		m_infoPoint.y	-= htToAdd; // -- -> +
		m_fnPoint.y		-= htToAdd; // -- -> +
	}

	// Store new size
	m_width		= (long)wd+(m_padding*2);
	m_height	= (long)ht+(m_padding*3)+m_iconSize;
}

- (void)_updateRectanglePath {
	if (m_rectPath != nil)
		[m_rectPath release];
	
	m_rectPath = [[NSBezierPath roundedRectangleWithWidth:m_width height:m_height
											andEdgeRadius:m_radius] retain];	
}

- (void)_compositeStateImageGroup:(FFOSDStateImage[])imgs number:(int)num {
	int i;
	for (i = 0; i < num; i++)
		[imgs[i].activeImg compositeToPoint:imgs[i].origin operation:2];
}

- (void)_generateOSDImage {
	// New image
	[self _calculateImageSize];

	[m_bitmapLock lock];
	
	if (m_genImage != nil) {
		[m_genBitmapRep release];
		[m_genImage release];
	}
		
	m_genImage = [[NSImage alloc] initWithSize:NSMakeSize(m_width, m_height)];
	
	// Draw rect
	[m_genImage lockFocus];
	[m_backgroundCol set];
	[m_rectPath fill];
	
	// Draw the filename & info
	[m_filename drawAtPoint:m_fnPoint withAttributes:m_fnFontAttrib];
	if (m_information != nil)
		[m_information drawAtPoint:m_infoPoint withAttributes:m_infoFontAttrib];
	
	if (m_filename2 != nil) {
		[m_filename2 drawAtPoint:m_fn2Point withAttributes:m_fnFontAttrib];
		[m_information2 drawAtPoint:m_info2Point withAttributes:m_infoFontAttrib];
	}

	// Draw the state images
	[self _compositeStateImageGroup:m_imgRotation number:OPT_NUM_ROTATION];
	[self _compositeStateImageGroup:m_imgScaling number:OPT_NUM_SCALING];
	[self _compositeStateImageGroup:m_imgAntialiasing number:1];
	[self _compositeStateImageGroup:m_imgNoBlowUp number:1];	
	
	m_genBitmapRep = [[NSBitmapImageRep alloc] initWithFocusedViewRect:
		NSMakeRect(0.0f, 0.0f, m_width, m_height)];	
	
	[m_genImage unlockFocus]; 
		
//	[[m_genImage TIFFRepresentation] writeToFile:@"/Users/ravemax/Desktop/osd.tiff" atomically:FALSE];
	
	[m_bitmapLock unlock];	
}

#pragma mark -
#pragma mark Setter

- (void)_setFilename:(NSString*)fn information:(NSString*)info andFilename2:(NSString*)fn2 {
	// Filename
	if (m_filename != nil)
		[m_filename release];
	m_filename = [fn retain];

	// Info
	if (m_information != nil)
		[m_information release];
	m_information = (info != nil) ? [info retain] : nil;
	
	if (m_filename2 != nil)
		[m_filename2 release];
	m_filename2 = (fn2 != nil) ? [fn2 retain] : nil;

	// Calc & render if visible
	if (m_visible) {
		[self _calculateImageSize];
		[self _updateRectanglePath];
		[self _generateOSDImage];		
	}
}

- (void)setFilename:(NSString*)fn andInformation:(NSString*)info {
	[self _setFilename:fn information:info andFilename2:nil];
}

- (void)setFilename:(NSString*)fn information:(NSString*)info
		  filename2:(NSString*)fn2 andInformation2:(NSString*)info2 {

	if (m_information2 != nil)
		[m_information2 release];
	m_information2 = [info2 retain];
	
	[self _setFilename:fn information:info andFilename2:fn2];
}

- (void)setRotation:(FFOptRotation)rot {
	[self _updateStateImageGroup:m_imgRotation number:OPT_NUM_ROTATION active:rot];
	if (m_visible)
		[self _generateOSDImage];
}

- (void)setScaling:(FFOptScaling)scale {
	[self _updateStateImageGroup:m_imgScaling number:OPT_NUM_SCALING active:scale];
	if (m_visible)
		[self _generateOSDImage];
}

- (void)setAntialiasing:(BOOL)aa {
	UPDATE_SINGLE_STATE_IMAGE(m_imgAntialiasing[0], (int)aa);
	if (m_visible)
		[self _generateOSDImage];
}

- (void)setNoBlowUp:(BOOL)noBlowUp {
	UPDATE_SINGLE_STATE_IMAGE(m_imgNoBlowUp[0], (int)noBlowUp);
	if (m_visible)
		[self _generateOSDImage];
}

- (void)setVisibility:(BOOL)vis {
	m_visible = vis;

	if (m_visible) {
		[self _calculateImageSize];
		[self _updateRectanglePath];
		[self _generateOSDImage];
	}
}

#pragma mark -
#pragma mark Getter

- (BOOL)isVisible   { return m_visible; }
- (long)width		{ return m_width; }
- (long)height		{ return m_height; }
- (char*)dataRGBA   {
	[m_bitmapLock lock]; [m_bitmapLock unlock];
	return [m_genBitmapRep bitmapData];
}

@end
