// $Id: FFPreferences.h 610 2007-08-26 19:40:40Z ravemax $

#import "FFImageList.h"
#import "FFPageView.h"

// The notifications
extern NSString*	CtrlForPanningEnOrDisabledNotification;
extern NSString*	RelativePanningEnOrDisabledNotification;
extern NSString*	DirectoryRootChangedNotification;
extern NSString*	WindowBackgroundChangedNotification;
extern NSString*	DoublePageAlignmentChangedNotification;

// Wrap
typedef enum {
	PREF_WRAP_NEVER = 0,
	PREF_WRAP_ASK,
	PREF_WRAP_ALWAYS
} FFPrefListWrap;

// Action when using the scrollwheel
typedef enum {
	PREF_SCROLL_WHEEL_PAN = 0,
	PREF_SCROLL_WHEEL_PAGE,
	PREF_SCROLL_WHEEL_IMAGE
} FFPrefScrollWheelAction;

// Extern classes
@class FFInputEvent;


// The class
@interface FFPreferences : NSObject {
	BOOL					m_saveOpts;
	float					m_zoomFactor;
	BOOL					m_borderlessWin;
	int						m_winLevel;
	double					m_slideshowTime;
	BOOL					m_keepMouseHidden;
	FFPrefListWrap			m_listWrap;
	NSString*				m_directoryRoot;
	BOOL					m_trashDelete;
	BOOL					m_listWinHiddenOnStartup;
	BOOL					m_ctrlForPanning;
	BOOL					m_relativePanning;
	unsigned				m_normalCursorShift;
	unsigned				m_accelCursorShift;
	float					m_mouseWheelSpeedup;
	int						m_ringBufSize;
	int						m_fetchDist;
	NSMutableArray*			m_inputEvents;
	int						m_thumbWidth, m_thumbHeight;
	BOOL					m_winBgAuto;
	NSColor*				m_winBgCol;
	FFDoublePageAlignment	m_doubleAlign;
	int						m_magLensWidth, m_magLensHeight;
	
	// Hidden options - not set thru the pref dialog
	float					m_imgWindowAlpha;
	float					m_listWinSnapTolerance;
	float					m_imageWinSnapTolerance;
	BOOL					m_clearListBeforeDrop;
	int						m_maxTileSize;
	BOOL					m_addAllOnDrop;
	float					m_lensZoom;
	BOOL					m_autoFullscreen;
	float					m_autoSinglePageAdj;
	BOOL					m_dontResizeImgWin;
	BOOL					m_disableAutoShowMenuBar;
	int						m_maxDirSearchDepth;
	BOOL					m_clearRecentOnQuit;
	FFPrefScrollWheelAction	m_scrollWheelAction;
	NSArray*				m_dirBlacklist;
	
	// External - not set thru the pref dialog
	FFImageListSortOrder	m_imageListSortOrder;
	BOOL					m_dirDrawerVisibleOnStartup;
	NSNumber*				m_screenNumber;

	// Misc
	BOOL					m_needToSave;
}

+ (FFPreferences*)instance;
- (void)save;
- (void)setNeedToSave:(BOOL)need;

// General
- (BOOL)saveOpts;
- (void)setSaveOpts:(BOOL)save;
- (float)zoomFactor;
- (void)setZoomFactor:(float)factor;
- (BOOL)borderlessWin;
- (void)setBorderlessWin:(BOOL)borderless;
- (int)winLevel;
- (void)setWinLevel:(int)level;
- (BOOL)winBackgroundAuto;
- (void)setWinBackgroundAuto:(BOOL)bgauto;
- (NSColor*)winBackgroundColor;
- (void)setWinBackgroundColor:(NSColor*)col;
- (double)slideshowTime;
- (void)setSlideshowTime:(double)time;
- (BOOL)keepMouseHidden;
- (void)setKeepMouseHidden:(BOOL)hidden;
- (FFDoublePageAlignment)doublePageAlignment;
- (void)setDoublePageAlignment:(FFDoublePageAlignment)alignment;
- (int)magnifyingLensWidth;
- (void)setMagnifyingLensWidth:(int)width;
- (int)magnifyingLensHeight;
- (void)setMagnifyingLensHeight:(int)height;

// Image list
- (FFPrefListWrap)listWrap;
- (void)setListWrap:(FFPrefListWrap)mode;
- (BOOL)trashDelete;
- (void)setTrashDelete:(BOOL)allow;
- (NSString*)directoryRoot;
- (void)setDirectoryRoot:(NSString*)root;
- (BOOL)listWinHiddenOnStartup;
- (void)setListWinHiddenOnStartup:(BOOL)hidden;
- (int)thumbWidth;
- (void)setThumbWidth:(int)width;
- (int)thumbHeight;
- (void)setThumbHeight:(int)height;

// Panning
- (BOOL)ctrlForPanning;
- (void)setCtrlForPanning:(BOOL)ctrl;
- (BOOL)relativePanning;
- (void)setRelativePanning:(BOOL)relative;
- (unsigned)normalCursorShift;
- (void)setNormalCursorShift:(unsigned)pixels;
- (unsigned)acceleratedCursorShift;
- (void)setAcceleratedCursorShift:(unsigned)pixels;
- (float)mouseWheelSpeedup;
- (void)setMouseWheelSpeedup:(float)speedup;

// Input events
- (void)addInputEvent:(FFInputEvent*)event;
- (void)removeInputEvent:(FFInputEvent*)event;
- (void)insertInputEvent:(FFInputEvent*)event after:(FFInputEvent*)afterEvent;
- (void)replaceInputEvent:(FFInputEvent*)oldEvent with:(FFInputEvent*)newEvent;
- (FFInputEvent*)inputEventAtIndex:(unsigned)idx;
- (NSEnumerator*)inputEventEnumerator;
- (unsigned)numberOfInputEvents;
- (BOOL)isInputEventAlreadyTaken:(FFInputEvent*)event;

// Advanced
- (int)ringBufferSize;
- (void)setRingBufferSize:(int)size;
- (int)fetchDistance;
- (void)setFetchDistance:(int)dist;

// Misc. - w/o pref view
- (float)imageWindowAlpha;
- (float)listWinSnapTolerance;
- (float)imageWinSnapTolerance;
- (BOOL)clearListBeforeDrop;
- (int)maxTileSize; // 0 = undefined
- (BOOL)addAllOnDrop;
- (float)lensZoom;
- (BOOL)autoFullscreen;
- (float)autoSinglePageAdjustment;
- (BOOL)dontResizeImageWindow;
- (BOOL)disableAutoShowMenuBar;
- (int)maxDirectorySearchDepth;
- (BOOL)clearRecentOnQuit;
- (FFPrefScrollWheelAction)scrollWheelAction;
- (BOOL)isBlacklistedDirectory:(NSString*)name;

#pragma mark -
#pragma mark External - not set thru the pref dialog

- (FFImageListSortOrder)imageListSortOrder;
- (void)setImageListSortOrder:(FFImageListSortOrder)sortOrder;
- (BOOL)dirDrawerVisibleOnStartup;
- (void)setDirDrawerVisibleOnStartup:(BOOL)visible;
- (NSNumber*)screenNumber; // may be nil
- (void)setScreenNumber:(NSNumber*)num;

// [Internal] Forward declaration
- (void)_setupDefaultInputEvents;

@end
