// $Id: FFOptions.h 564 2006-08-20 14:17:42Z ravemax $

typedef enum {
	OPT_NO_ROTATION = 0,
	OPT_ROTATE_RIGHT,
	OPT_ROTATE_180,
	OPT_ROTATE_LEFT,
	
	OPT_NUM_ROTATION
} FFOptRotation;

typedef enum {
	OPT_NO_SCALING = 0,
	OPT_FIT_TO_WINDOW,
	OPT_PAGEWIDTH,
	
	OPT_NUM_SCALING
} FFOptScaling;

typedef enum {
	OPT_MODE_SINGLE = 0,
	OPT_MODE_WESTERN,
	OPT_MODE_MANGA,
	
	OPT_NUM_PAGE_MODE
} FFOptPageMode;

#ifdef FFVIEW_APPLICATION
	// The notifications (send)
	extern NSString*	RotationChangedNotification;
	extern NSString*	ScalingChangedNotification;
	extern NSString*	PageModeChangedNotification;
	extern NSString*	NoBlowUpChangedNotification;
	extern NSString*	AntialiasingChangedNotification;
	extern NSString*	SpeechOnChangedNotification;
	extern NSString*	ScreenModeChangedNotification;
	extern NSString*	OSDVisibilityChangedNotification;
	extern NSString*	MagnifyingLensVisibilityChangedNotification;
	extern NSString*	ZoomMultiplierChangedNotification;

	// Notifications (receive)
	extern NSString*	ToggleScreenModeNotification;
	extern NSString*	ToggleOSDVisibilityNotification;
	extern NSString*	ToggleMagnifyingLensVisibilityNotification;
	extern NSString*	ZoomInNotification;
	extern NSString*	ZoomOutNotification;

	// External classes
	@class FFPreferences;
#endif // FFVIEW_APPLICATION	


// Class
@interface FFOptions : NSObject {
#ifdef FFVIEW_APPLICATION	
	FFPreferences*			m_prefs;
	NSNotificationCenter*   m_nc;

	BOOL					m_OSDVisibility;
	BOOL					m_magnifyingLensVisibility;
	BOOL					m_fullscreen;
	NSStringEncoding		m_archiveEncoding;
#else
	float					m_zoomFactor;
#endif
	
	FFOptRotation			m_rotation;
	FFOptScaling			m_scaling;
	FFOptPageMode			m_pageMode;
	BOOL					m_keepAspectRatio;
	BOOL					m_noBlowUp;
	BOOL					m_antialiasing;
	BOOL					m_speechOn;
	float					m_zoomMultiplier;
}

#ifdef FFVIEW_APPLICATION
	- (id)initWithPrefs:(FFPreferences*)prefs;
	- (void)save;
#else
	- (id)init;
#endif

- (FFOptRotation)rotation;
- (void)setRotation:(FFOptRotation)rot;
- (FFOptScaling)scaling;
- (void)setScaling:(FFOptScaling)scal;
- (FFOptPageMode)pageMode;
- (void)setPageMode:(FFOptPageMode)pmode;
- (BOOL)noBlowUp;
- (void)setNoBlowUp:(BOOL)no;
- (BOOL)antialiasing;
- (void)setAntialiasing:(BOOL)aa;
- (BOOL)speechOn;
- (void)setSpeechOn:(BOOL)speech;

#pragma mark -
#pragma mark Not in the "Options" menu

#ifdef FFVIEW_APPLICATION	
	- (BOOL)fullscreen;
	- (void)setFullscreen:(BOOL)fs;
	- (void)toggleScreenMode;
	- (BOOL)isOSDVisible;
	- (void)setOSDVisibility:(BOOL)osd;
	- (void)toggleOSDVisibility;
	- (BOOL)isMagnifyingLensVisible;
	- (void)setMagnifyingLensVisibility:(BOOL)lens;
	- (void)toggleMagnifyingLensVisibility;

	- (NSStringEncoding)archiveEncoding;
	- (void)setArchiveEncoding:(NSStringEncoding)encoding;
#else
	- (void)setZoomFactor:(float)factor;
#endif

- (void)zoomReset;
- (void)zoomIn;
- (void)zoomOut;
- (float)zoomMultiplier;

@end
