//	$Id: FFInputEvent.h 407 2005-06-08 20:33:42Z ravemax $

#import "FFMainController.h"

// Input event types
typedef enum {
	EVENT_NONE = 0,
	EVENT_KEY,
	EVENT_BUTTON,
	EVENT_SPEECH,
	
	NUM_EVENT_TYPE
} FFInputEventType;

@interface FFInputEvent : NSObject {
	FFInputEventType	m_type;
	FFMenuAction		m_action;
	unsigned			m_modifier;
	unichar				m_key;
	int					m_button;
	NSString*			m_command;
	NSString*			m_script;
}

// Creation - for preference defaults
+ (FFInputEvent*)event;
+ (FFInputEvent*)eventWithKey:(unichar)key modifier:(unsigned)modifier andAction:(FFMenuAction)action;
+ (FFInputEvent*)eventWithButton:(int)button modifier:(unsigned)modifier andAction:(FFMenuAction)action;
+ (FFInputEvent*)eventWithSpeechCommand:(NSString*)cmd andAction:(FFMenuAction)action;

// Getters for all the member variables
- (FFInputEventType)type;
- (FFMenuAction)action;
- (unsigned)modifier;
- (unichar)key;
- (int)button;
- (NSString*)command;
- (NSString*)script;

// Setters
- (void)setType:(FFInputEventType)type;
- (void)setAction:(FFMenuAction)action;
- (void)setModifier:(unsigned)modifier;
- (void)setKey:(unichar)key;
- (void)setButton:(int)button;
- (void)setCommand:(NSString*)command;
- (void)setScript:(NSString*)script;

// Storage
- (NSDictionary*)exportAsDictionary;
- (NSString*)description;
+ (FFInputEvent*)eventFromDictionary:(NSDictionary*)dict;

// Misc
- (BOOL)isCompleteDoIgnoreAction:(BOOL)ignoreAction;
- (BOOL)isEqualToInputEvent:(FFInputEvent*)otherEvent;
- (BOOL)isAssignedToScript;
- (NSString*)asString;
+ (NSArray*)specialKeyNames;
+ (NSArray*)specialKeyKeys;

@end
