RCS_ID("$Id: FFApplication.m 601 2006-09-30 19:15:46Z ravemax $")

#import "FFApplication.h"
#import "FFPreferences.h"
#import "FFMainController.h"
#import "FFInputEvent.h"
#import "FFScriptObject.h"
#import "FFMacModel.h"

@implementation FFApplication

static const NSString*	SupportHomeDirectory = @"~/Library/Application Support/FFView";

- (id)init {
	self = [super init];
	if (self != nil) {
		m_forwardAll	= TRUE; // till the maincontroller is set
		m_scriptObjs	= [[NSMutableDictionary alloc] init];
		m_supportDir	= [[SupportHomeDirectory stringByExpandingTildeInPath] retain];

		// Intel - modifier mask depends on the Mac model
		#ifdef __LITTLE_ENDIAN__
			if ([macModelName() hasPrefix:@"MacBook"])
				m_modifierMask	= (unsigned)0x0F;
			else
				m_modifierMask	= (unsigned)0x1F;
		#else
			m_modifierMask	= (unsigned)0x1F;
		#endif
		
		// Create the app support directory if it doesn't exist
		NSFileManager* fm = [NSFileManager defaultManager];
		if (![fm fileExistsAtPath:m_supportDir])
			[fm createDirectoryAtPath:m_supportDir attributes:nil];

	}
	return self;
}

- (void)cleanUp {
	[m_scriptObjs release];
	[m_supportDir release];
}

#pragma mark -
#pragma mark Event : Add/remove input events to/from a list

static void newNode(FFAppActionNode** rootNode, int value, FFInputEvent* event) {
	FFAppActionNode* node = (FFAppActionNode*)malloc(sizeof(FFAppActionNode));
	if (node == NULL) {
		NSLog(@"Critcal : not enough memory for newNode");
		exit(-1);
	}

	node->next		= NULL;
	node->value		= value;
	node->event		= event; // weak

	// Create root
	if (*rootNode == NULL)
		*rootNode = node;
	
	// Append
	else {
		FFAppActionNode* sn = *rootNode;
		while (sn->next != NULL)
			sn = sn->next;
		sn->next = node;
	}
}

static void rmNode(FFAppActionNode** rootNode, int value) {
	FFAppActionNode*	node = *rootNode, *tn;
	
	// First node
	if (node->value == value) {
		*rootNode = node->next; // May result in NULL
		free(node);

	// Node 2..n
	} else {
		while (node->next->value != value)
			node = node->next;
		tn = node->next;
		node->next = tn->next;
		free(tn);
	}
}

#define MOD_TO_INDEX(MOD) \
	(int)((MOD >> 17) & m_modifierMask)

- (void)_addInputEvent:(FFInputEvent*)ev {
	if ([ev type] == EVENT_KEY)
		newNode(&m_ieKeyRoot[MOD_TO_INDEX([ev modifier])], (int)[ev key], ev);		
	else
		newNode(&m_ieBtnRoot[MOD_TO_INDEX([ev modifier])], [ev button], ev);
}

- (void)_removeInputEvent:(FFInputEvent*)ev {
	if ([ev type] == EVENT_KEY)
		rmNode(&m_ieKeyRoot[MOD_TO_INDEX([ev modifier])], (int)[ev key]);
	else
		rmNode(&m_ieBtnRoot[MOD_TO_INDEX([ev modifier])], [ev button]);
}

#pragma mark -
#pragma mark Event : Setup

#ifdef FF_DEBUG_MODE
- (void)_dump:(NSString*)d root:(FFAppActionNode*[])root {
	FFAppActionNode*	node;
	
	int i;
	for (i = 0; i < NUM_MODIFIER_COMBINATIONS; i++) {
		node = root[i];
		if (node == NULL) 
			NSLog(@"%@ - comb=%d == NULL", d, i);
		else {
			while (node != NULL) {
				NSLog(@"%@ - comb=%d : value=%08lX, event=%@", d, i, node->value, node->event);				
				node = node->next;
			}
		}
	}
}
#endif

- (void)setupInputEvents {
	NSEnumerator*	en;
	FFInputEvent*	ev;

	memset(m_ieKeyRoot, NULL, NUM_MODIFIER_COMBINATIONS*sizeof(FFAppActionNode*));
	memset(m_ieBtnRoot, NULL, NUM_MODIFIER_COMBINATIONS*sizeof(FFAppActionNode*));

	en = [[FFPreferences instance] inputEventEnumerator];
	while (ev = [en nextObject])
		if ([ev type] != EVENT_SPEECH)
			[self _addInputEvent:ev];
	
	///// DEBUG
//	[self _dump:@"key" root:m_ieKeyRoot];
//	[self _dump:@"btn" root:m_ieBtnRoot];
}

- (void)setMainController:(FFMainController*)mainCtrl {
	m_mainCtrl		= mainCtrl;
	m_forwardAll	= FALSE;
}

#pragma mark -
#pragma mark Event : Setter

- (void)setForwardAll:(BOOL)forwardAll {
	m_forwardAll = forwardAll;
}

#pragma mark -
#pragma mark Event : Called from FFPreferences

- (void)didAddInputEvent:(FFInputEvent*)ev {
	if ([ev type] == EVENT_SPEECH) 
		[m_mainCtrl addSpeechEvent:ev];
	else {
		[self _addInputEvent:ev];

		// Forward the message to the maincontroller
		[m_mainCtrl addInputEvent:ev toMenu:[self mainMenu]];
	}
}

- (void)willRemoveInputEvent:(FFInputEvent*)ev {
	if ([ev type] == EVENT_SPEECH) 
		[m_mainCtrl removeSpeechEvent:ev];
	else {
		[self _removeInputEvent:ev];

		// Forward the message to the maincontroller
		[m_mainCtrl removeInputEvent:ev fromMenu:[self mainMenu]];
	}
}

- (void)willReplaceInputEvent:(FFInputEvent*)oldEv with:(FFInputEvent*)newEv {
	// Old event
	if ([oldEv type] == EVENT_SPEECH)
		[m_mainCtrl removeSpeechEvent:oldEv];
	else
		[self _removeInputEvent:oldEv];

	// New event
	if ([newEv type] == EVENT_SPEECH)
		[m_mainCtrl addSpeechEvent:newEv];
	else
		[self _addInputEvent:newEv];

	// Forward the message to the maincontroller
	[m_mainCtrl replaceInputEvent:oldEv inMenu:[self mainMenu] with:newEv];
}

#pragma mark -
#pragma mark Event : main

- (void)sendEvent:(NSEvent*)ev {
	if (!m_forwardAll) {
		FFAppActionNode*	node = NULL;
		int					value;
		
		if ([ev type] == NSKeyDown) {
			node	= m_ieKeyRoot[MOD_TO_INDEX([ev modifierFlags])];
			value	= (int)[[ev charactersIgnoringModifiers] characterAtIndex:0];
			
		} else if ([ev type] == NSOtherMouseDown) {
			node	= m_ieBtnRoot[MOD_TO_INDEX([ev modifierFlags])];
			value	= [ev buttonNumber]+1; // 1st button=0
		}
				
		while (node != NULL) {
			if (node->value == value) {
				[m_mainCtrl executeEvent:node->event];
				return; // Don't forward
			}
			node = node->next;
		}
	
	// Forward to dialogs
	} else if (([self keyWindow] != nil) && ([ev type] == NSKeyDown)) {
		if ([ev modifierFlags] & NSCommandKeyMask)
			[[self keyWindow] keyDown:ev]; // E.g. "Close window"
		else
			[[self keyWindow] sendEvent:ev];

		return;
	}
	
	[super sendEvent:ev];
}

#pragma mark -
#pragma mark AS : Script object management

- (void)registerElement:(id)element forKey:(NSString*)key {
	[m_scriptObjs setObject:
		[[[FFScriptObject alloc] initWithObject:element getter:nil
			andSetter:nil isElement:TRUE] autorelease]
		forKey:key];
}

- (void)registerPropertyWithTarget:(id)target getter:(SEL)getter andSetter:(SEL)setter 
							forKey:(NSString*)key {
	[m_scriptObjs setObject:
		[[[FFScriptObject alloc] initWithObject:target getter:getter 
			andSetter:setter isElement:FALSE] autorelease]
		forKey:key];	
}

- (id)valueForKey:(NSString*)key {
	FFLOG(3, @"valueForKey:%@", key);
	
	// Published object?
	FFScriptObject*	sobj = [m_scriptObjs objectForKey:key];
	if (sobj == nil)
		return nil;

	// Elements
	if ([sobj isElement]) {
		if ([[sobj object] count] == 0)
			return nil;
		return [sobj object];
	}

	// Forward to getter
	return [[sobj object] performSelector:[sobj getter]];
}

// used even though its deprecated, because "setValue:forKey:" isn't called
- (void)takeValue:(id)value forKey:(NSString*)key {
	FFScriptObject*	sobj = [m_scriptObjs objectForKey:key];
	
	if ((sobj != nil) && (![sobj isReadOnly]))
		[[sobj object] performSelector:[sobj setter] withObject:value];
}

- (NSScriptObjectSpecifier*)indexSpecifierForObject:(id)obj fromContainerWithKey:(id)key {
	// Published element?
	FFScriptObject*	sobj = [m_scriptObjs objectForKey:key];
	if ((sobj == nil) || (![sobj isElement]))
		return nil;

	// Search object
	unsigned oidx = [[sobj object] indexOfObjectIdenticalTo:obj];
	if (oidx == NSNotFound)
		return nil;
	
	// Create specifier
	NSScriptClassDescription* cdesc = (NSScriptClassDescription*)[self classDescription];
	
	return [[[NSIndexSpecifier allocWithZone:[self zone]]
			initWithContainerClassDescription:cdesc
						   containerSpecifier:nil
										  key:key
										index:oidx] autorelease];
}

#pragma mark -
#pragma mark Misc.

- (NSString*)supportDirectory {
	return m_supportDir;
}

@end
