RCS_ID("$Id: FFScriptCommands.m 522 2005-10-15 16:52:19Z ravemax $")

#import "FFScriptCommands.h"
#import "FFMainController.h"
#import "FFImageList.h"

@implementation FFScriptCommands

static FFMainController*	mainController = nil;
static FFImageList*			imgList	= nil;

+ (void)setMainController:(FFMainController*)ctrl andImageList:(FFImageList*)list {
	mainController	= ctrl;
	imgList			= list;
}

- (id)performDefaultImplementation {
	id arg;
	
	// No main controller yet
	if (mainController == nil)
		return nil;

	switch ([[self commandDescription] appleEventCode]) {
		case FOUR_CHAR_CODE('cnim'): // next image
			[mainController executeMenuAction:MENU_VIEW_NEXT_IMG];
			break;
		case FOUR_CHAR_CODE('cpim'): // previous image
			[mainController executeMenuAction:MENU_VIEW_PREV_IMG];
			break;
		case FOUR_CHAR_CODE('cshw'): // show
			arg = [self directParameter];
			if ([arg isKindOfClass:[NSNumber class]])
				[imgList selectImageAtIndex:[arg unsignedIntValue]];
			break;
		case FOUR_CHAR_CODE('cadd'): // add
			[imgList addFiles:[self directParameter] tillLevel:1 restoreSelectionIfPossible:TRUE];
			break;
		case FOUR_CHAR_CODE('cclr'): // clear
			[imgList clear];
			break;
		case FOUR_CHAR_CODE('csts'): // start slideshow
			[mainController executeMenuAction:MENU_VIEW_START_SLIDESHOW];
			break;
		case FOUR_CHAR_CODE('csps'): // stop slideshow
			[mainController executeMenuAction:MENU_VIEW_STOP_SLIDESHOW];
			break;
	}
	return nil; // No return values
}

@end
