RCS_ID("$Id: FFImageFile_Scriptable.m 407 2005-06-08 20:33:42Z ravemax $")

#import "FFImageFile_Scriptable.h"
#import "FFApplication.h"
#import "FFImageList.h"

@implementation FFImageFile (Scriptable)

// Four char code <-> enum mapping
static const unsigned ImageFileTypeFCC[NUM_IMAGE_FILE_TYPES] = {
	FOUR_CHAR_CODE('etno'),	// IMG_NORMAL_FILE
	FOUR_CHAR_CODE('etpa')	// IMG_PART_OF_ARCHIVE
};

#pragma mark -
#pragma mark Getters

- (NSNumber*)typeAS {
	return [NSNumber numberWithUnsignedInt:ImageFileTypeFCC[[self fileType]]];
}

- (NSString*)titleAS {
	return [[self displayName] string];
}

- (NSString*)fullPathAS {
	return [self fullPath];
}

- (NSNumber*)indexAS {
	return [NSNumber numberWithInt:[(NSIndexSpecifier*)[self objectSpecifier] index] + 1];
}

// Object specifier
- (NSScriptObjectSpecifier*)objectSpecifier {
	return [NSApp indexSpecifierForObject:self fromContainerWithKey:@"imageFiles"];
}

#pragma mark -
#pragma mark Commands

- (void)show:(id)_unused {
	[[NSNotificationCenter defaultCenter] postNotificationName:SelectSpecifiedImageNotification object:self];
}

@end
