RCS_ID("$Id: FFArchiveZIP.m 541 2006-08-20 13:47:14Z ravemax $")

#import "FFArchiveZIP.h"
#import <stdio.h>
#import <stdlib.h>
#import <unistd.h>
#import "unzip.h"

#define ZIP_BUF_SIZE 32768

@implementation FFArchiveZIP

#define FILENAMES	0
#define DATA		1

- (id)initWithFile:(NSString*)filePath fallbackEncoding:(NSStringEncoding)enc {
	self = [super initWithFile:filePath fallbackEncoding:enc];
	if (self != nil) {
		m_corruptNames[FILENAMES] = nil;
		m_encrypted = FALSE;
	}
	return self;
}

- (void)dealloc {
	if (m_corruptNames[FILENAMES] != nil) {
		[m_corruptNames[FILENAMES] release];
		[m_corruptNames[DATA] release];
	}
	[super dealloc];
}


- (NSArray*)filesInArchive {
	unzFile					uf;
	struct unz_file_info_s  finfo;
	int						ret;
	char*					fnbuf;
	NSMutableArray*			files;
	BOOL					enc;
	
	// Open the .zip
	uf = unzOpen([[self filePath] fileSystemRepresentation]);
	if (uf == NULL)
		[NSException raise:[self className]
					format:NSLocalizedString(@"Failed to open the ZIP '%@'", @"1=Filename"),
							[self filePath]];

	// Goto the first file
	if (unzGoToFirstFile(uf) != UNZ_OK) {
		unzClose(uf);
		[NSException raise:[self className]
					format:NSLocalizedString(@"ZIP file empty? Failed to seek to the first file", @"<no arguments")];
	}
		
	// Process all files
	files = [[NSMutableArray alloc] init];
	for (;;) {
		// Get the fileinfo
		ret = unzGetCurrentFileInfo(uf, &finfo, NULL, 0, NULL, 0, NULL, 0);
		if (ret != UNZ_OK)
			break;
		
		// Get the filename
		fnbuf = (char*)malloc(finfo.size_filename+1);
		ret = unzGetCurrentFileInfo(uf, NULL, fnbuf, finfo.size_filename+1, NULL, 0, NULL, 0);
		if (ret != UNZ_OK) {
			free(fnbuf);
			break;
		}
	
		// Add if filesize > 0
		if (finfo.compressed_size > 0) {
			NSString* fno = [NSString stringWithUTF8String:fnbuf];
			// Error handling for some buggy (NSString can't handle them) filenames (rare)
			if (fno == nil) {
				fno = [[[NSString alloc] initWithBytes:fnbuf length:finfo.size_filename
											  encoding:m_encoding] autorelease];
				if (fno != nil) {
					if (m_corruptNames[FILENAMES] == nil) {
						m_corruptNames[FILENAMES] = [[NSMutableArray alloc] initWithCapacity:1];
						m_corruptNames[DATA] = [[NSMutableArray alloc] initWithCapacity:1];						
					}
					[m_corruptNames[FILENAMES] addObject:fno];
					[m_corruptNames[DATA] addObject:
						[NSData dataWithBytesNoCopy:fnbuf length:(finfo.size_filename+1)]];
							
					fnbuf = NULL;
				}
			}
			
			// Encrypted?
			enc = (BOOL)(finfo.flag & 1); // Bit0: encrypted according to "Appnote.txt", 4.5 PKWare
			m_encrypted |= enc;
			
			// Add the file
			if (fno != nil)
				[files addObject:[NSDictionary dictionaryWithObjectsAndKeys:
					fno, FFFilename,
					[NSNumber numberWithUnsignedLong:finfo.compressed_size], FFCompressedFileSize,
					[NSNumber numberWithUnsignedLong:finfo.uncompressed_size], FFUncompressedFileSize,
					[NSDate dateWithString:[NSString stringWithFormat:@"%4u-%02u-%02u %02u:%02u:%u +0000",
						finfo.tmu_date.tm_year, finfo.tmu_date.tm_mon, finfo.tmu_date.tm_mday,
						finfo.tmu_date.tm_hour, finfo.tmu_date.tm_min, finfo.tmu_date.tm_sec]], 
						FFFileCreationDate,
					[NSNumber numberWithBool:enc], FFEncrypted,
					nil]];
		}
		free(fnbuf);

		// To the next file
		ret = unzGoToNextFile(uf);
		if (ret != UNZ_OK) {
			if (ret == UNZ_END_OF_LIST_OF_FILE)
				ret = UNZ_OK;
			break;
		}
	}
	unzClose(uf);	
	
	// If something went wrong
	if (ret != UNZ_OK) {
		[files release];
		[NSException raise:[self className]
					format:NSLocalizedString(@"Some internal problems with the ZIP", @"<no arguments")];
	}
	
	return [files autorelease];
}

- (void)extractFile:(NSString*)filename toFilePath:(NSString*)toPath {
	unzFile*		uf;
	const char*		fn;
	FILE*			fh;
	char*			buf;
	int				ret;
	BOOL			openErr = FALSE;
	
	// (Re)Open the .zip
	uf = unzOpen([[self filePath] fileSystemRepresentation]);
	if (uf == NULL)
		[NSException raise:[self className]
					format:NSLocalizedString(@"Failed to reopen the ZIP '%@'", @"1=ZIP filename"),
							[self filePath]];		
	
	// Seek to the file
	if ((m_corruptNames[0] == nil) || ![m_corruptNames[FILENAMES] containsObject:filename])
		fn = [filename UTF8String];
	else
		fn = (char*)[[m_corruptNames[DATA] objectAtIndex:
			[m_corruptNames[FILENAMES] indexOfObject:filename]] bytes];

	if (unzLocateFile(uf, fn, 1) == UNZ_END_OF_LIST_OF_FILE)
		openErr = TRUE;
	else if (m_encrypted) {
		const char* pwd = [self _getPassword];
		if ((pwd == NULL) || (unzOpenCurrentFilePassword(uf, pwd) != UNZ_OK))
			openErr = TRUE;		
	} else if (unzOpenCurrentFile(uf) != UNZ_OK)
		openErr = TRUE;
	
	if (openErr) {
		unzClose(uf);
		[NSException raise:[self className]
					format:NSLocalizedString(@"Corrupt ZIP or an internal error", @"<no arguments>")];
	}
	
	// Create the file
	fh = fopen([toPath fileSystemRepresentation], "w");
	if (fh == NULL) {
		unzClose(uf);
		[NSException raise:[self className]
					format:NSLocalizedString(@"Failed to create the temp file '%@'", @"1=Dest. path"),
							toPath];
	}
	
	// Decompress the file
	buf = (char*)malloc(ZIP_BUF_SIZE);
	for (;;) {
		ret = unzReadCurrentFile(uf, buf, ZIP_BUF_SIZE);
		if (ret <= 0) // EOF or failure
			break;

		fwrite(buf, 1, (size_t)ret, fh);
	}
	
	// Heavy deallocation
	free(buf);
	fclose(fh);
	unzCloseCurrentFile(uf);
	unzClose(uf);
		
	// Some error occurred
	if (ret < 0) {
		unlink([toPath fileSystemRepresentation]);
		[NSException raise:[self className]
					format:NSLocalizedString(@"Failed to decompress the file", @"<no arguments>")];		
	}
}

@end
