/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.constraints;

import java.util.List;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.psi.LambdaUtil;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiCodeBlock;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiLambdaExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.FunctionalInterfaceParameterizationUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.InferenceVariable;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.constraints.ExpressionCompatibilityConstraint;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.constraints.StrictSubtypingConstraint;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.constraints.TypeEqualityConstraint;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.TypeConversionUtil;

public class LambdaExpressionCompatibilityConstraint
implements ConstraintFormula {
    private static final Logger LOG = Logger.getInstance(LambdaExpressionCompatibilityConstraint.class);
    private final PsiLambdaExpression myExpression;
    private PsiType myT;

    public LambdaExpressionCompatibilityConstraint(PsiLambdaExpression expression2, PsiType t) {
        this.myExpression = expression2;
        this.myT = t;
    }

    @Override
    public boolean reduce(InferenceSession session2, List<? super ConstraintFormula> constraints) {
        block17: {
            if (!LambdaUtil.isFunctionalType(this.myT)) {
                session2.registerIncompatibleErrorMessage(session2.getPresentableText(this.myT) + " is not a functional interface");
                return false;
            }
            PsiType groundTargetType = FunctionalInterfaceParameterizationUtil.getGroundTargetType(this.myT, this.myExpression, false);
            PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType(groundTargetType);
            PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(resolveResult);
            if (interfaceMethod == null) {
                session2.registerIncompatibleErrorMessage("No valid function type can be found for " + session2.getPresentableText(this.myT));
                return false;
            }
            PsiSubstitutor substitutor2 = LambdaUtil.getSubstitutor(interfaceMethod, resolveResult);
            PsiParameter[] parameters2 = interfaceMethod.getParameterList().getParameters();
            PsiParameter[] lambdaParameters = this.myExpression.getParameterList().getParameters();
            if (lambdaParameters.length != parameters2.length) {
                session2.registerIncompatibleErrorMessage("Incompatible parameter types in lambda expression");
                return false;
            }
            if (this.myExpression.hasFormalParameterTypes()) {
                for (int i = 0; i < lambdaParameters.length; ++i) {
                    constraints.add(new TypeEqualityConstraint(lambdaParameters[i].getType(), session2.substituteWithInferenceVariables(substitutor2.substitute(parameters2[i].getType()))));
                }
                constraints.add(new StrictSubtypingConstraint(this.myT, groundTargetType));
            } else {
                for (PsiParameter parameter : parameters2) {
                    PsiType type3 = session2.substituteWithInferenceVariables(substitutor2.substitute(parameter.getType()));
                    if (session2.isProperType(type3)) continue;
                    return false;
                }
            }
            PsiType returnType2 = interfaceMethod.getReturnType();
            if (returnType2 == null) break block17;
            List<PsiExpression> returnExpressions = LambdaUtil.getReturnExpressions(this.myExpression);
            PsiElement lambdaBody = this.myExpression.getBody();
            if (returnType2.equals(PsiType.VOID)) {
                if (!(lambdaBody instanceof PsiCodeBlock && this.myExpression.isVoidCompatible() || LambdaUtil.isExpressionStatementExpression(lambdaBody))) {
                    session2.registerIncompatibleErrorMessage("Incompatible types: expected void but the lambda body is neither a statement expression nor a void-compatible block");
                    return false;
                }
            } else {
                if (lambdaBody instanceof PsiCodeBlock && !this.myExpression.isValueCompatible()) {
                    session2.registerIncompatibleErrorMessage("Incompatible types: expected not void but the lambda body is a block that is not value-compatible");
                    return false;
                }
                PsiSubstitutor nestedSubstitutor = session2.getInferenceSessionContainer().findNestedSubstitutor(this.myExpression, session2.getInferenceSubstitution());
                returnType2 = nestedSubstitutor.substitute(substitutor2.substitute(returnType2));
                boolean isProperType2 = InferenceSession.collectDependencies(returnType2, null, type2 -> {
                    PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly(type2);
                    return psiClass instanceof InferenceVariable && nestedSubstitutor.getSubstitutionMap().containsValue(type2) ? (InferenceVariable)psiClass : null;
                });
                if (!isProperType2 || this.myExpression.hasFormalParameterTypes()) {
                    for (PsiExpression returnExpression : returnExpressions) {
                        if (InferenceSession.ignoreLambdaConstraintTree(returnExpression)) continue;
                        constraints.add(new ExpressionCompatibilityConstraint(returnExpression, returnType2));
                    }
                } else {
                    for (PsiExpression returnExpression : returnExpressions) {
                        if (PsiPolyExpressionUtil.isPolyExpression(returnExpression) || TypeConversionUtil.areTypesAssignmentCompatible(returnType2, returnExpression)) continue;
                        PsiType type4 = returnExpression.getType();
                        if (type4 != null) {
                            session2.registerIncompatibleErrorMessage("Bad return type in lambda expression: " + session2.getPresentableText(type4) + " cannot be converted to " + session2.getPresentableText(returnType2));
                        } else {
                            session2.registerIncompatibleErrorMessage(returnExpression.getText() + " is not compatible with " + session2.getPresentableText(returnType2));
                        }
                        return false;
                    }
                }
            }
        }
        return true;
    }

    @Override
    public void apply(PsiSubstitutor substitutor2, boolean cache2) {
        this.myT = substitutor2.substitute(this.myT);
    }

    public String toString() {
        return this.myExpression.getText() + " -> " + this.myT.getPresentableText();
    }
}

