/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.registry;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Transformer;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.util.internal.CollectionUtils;

@ThreadSafe
class ModelPathSuggestionProvider
implements Transformer<List<ModelPath>, ModelPath> {
    private static final Predicate<Suggestion> REMOVE_NULLS = new Predicate<Suggestion>(){

        public boolean apply(Suggestion input) {
            return input != null;
        }
    };
    private final Iterable<ModelPath> availablePaths;

    public ModelPathSuggestionProvider(Iterable<ModelPath> availablePaths) {
        this.availablePaths = availablePaths;
    }

    public List<ModelPath> transform(final ModelPath unavailable) {
        Iterable suggestions = Iterables.transform(this.availablePaths, (Function)new Function<ModelPath, Suggestion>(){

            public Suggestion apply(ModelPath available) {
                boolean suggest;
                int distance = StringUtils.getLevenshteinDistance((String)unavailable.toString(), (String)available.toString());
                boolean bl = suggest = distance <= Math.min(3, unavailable.toString().length() / 2);
                if (suggest) {
                    return new Suggestion(distance, available);
                }
                return null;
            }
        });
        suggestions = Iterables.filter((Iterable)suggestions, REMOVE_NULLS);
        List sortedSuggestions = CollectionUtils.sort((Iterable)suggestions);
        return CollectionUtils.collect((Iterable)sortedSuggestions, (Transformer)Suggestion.EXTRACT_PATH);
    }

    @ThreadSafe
    private static class Suggestion
    implements Comparable<Suggestion> {
        private static final Transformer<ModelPath, Suggestion> EXTRACT_PATH = new Transformer<ModelPath, Suggestion>(){

            public ModelPath transform(Suggestion original) {
                return original.path;
            }
        };
        private final int distance;
        private final ModelPath path;

        private Suggestion(int distance, ModelPath path) {
            this.distance = distance;
            this.path = path;
        }

        @Override
        public int compareTo(Suggestion o) {
            int distanceDifference = this.distance - o.distance;
            if (distanceDifference == 0) {
                return this.path.toString().compareTo(o.path.toString());
            }
            return distanceDifference;
        }
    }
}

