/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.parser.sourcemaps;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.parser.sourcemaps.JSONKt;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonArray;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonNode;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonNull;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonNumber;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonObject;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonString;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonSyntaxException;
import org.jetbrains.kotlin.js.parser.sourcemaps.SourceMap;
import org.jetbrains.kotlin.js.parser.sourcemaps.SourceMapError;
import org.jetbrains.kotlin.js.parser.sourcemaps.SourceMapGroup;
import org.jetbrains.kotlin.js.parser.sourcemaps.SourceMapParseResult;
import org.jetbrains.kotlin.js.parser.sourcemaps.SourceMapSegment;
import org.jetbrains.kotlin.js.parser.sourcemaps.SourceMapSuccess;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u000bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/js/parser/sourcemaps/SourceMapParser;", "", "()V", "parse", "Lorg/jetbrains/kotlin/js/parser/sourcemaps/SourceMapParseResult;", "file", "Ljava/io/File;", "content", "", "jsonObject", "Lorg/jetbrains/kotlin/js/parser/sourcemaps/JsonNode;", "MappingStream", "js.parser"})
public final class SourceMapParser {
    public static final SourceMapParser INSTANCE;

    @NotNull
    public final SourceMapParseResult parse(@NotNull File file2) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        return this.parse(FilesKt.readText((File)file2, (Charset)Charsets.UTF_8));
    }

    @NotNull
    public final SourceMapParseResult parse(@NotNull String content) throws IOException {
        JsonNode jsonNode;
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        try {
            jsonNode = JSONKt.parseJson(content);
        }
        catch (JsonSyntaxException e) {
            String string = e.getMessage();
            if (string == null) {
                string = "parse error";
            }
            return new SourceMapError(string);
        }
        JsonNode jsonObject = jsonNode;
        return this.parse(jsonObject);
    }

    /*
     * WARNING - void declaration
     */
    private final SourceMapParseResult parse(JsonNode jsonObject) throws IOException {
        void $this$associateTo$iv$iv;
        List list2;
        List list3;
        Object it;
        Object object;
        Iterable destination$iv$iv;
        String string;
        JsonNode version;
        if (!(jsonObject instanceof JsonObject)) {
            return new SourceMapError("Top-level object expected");
        }
        JsonNode jsonNode = ((JsonObject)jsonObject).getProperties().get("version");
        if (jsonNode == null) {
            return new SourceMapError("Version not defined");
        }
        JsonNode jsonNode2 = version = jsonNode;
        boolean bl = false;
        boolean bl2 = false;
        JsonNode it422 = jsonNode2;
        boolean bl3 = false;
        if (!(version instanceof JsonNumber) || ((JsonNumber)version).getValue() != 3.0) {
            return new SourceMapError("Unsupported version: " + it422);
        }
        JsonNode jsonNode3 = ((JsonObject)jsonObject).getProperties().get("sourceRoot");
        bl2 = false;
        boolean it422 = false;
        JsonNode it32 = jsonNode3;
        boolean bl4 = false;
        if (it32 != null) {
            JsonNode jsonNode4 = it32;
            if (!(jsonNode4 instanceof JsonString)) {
                jsonNode4 = null;
            }
            JsonString jsonString = (JsonString)jsonNode4;
            if (jsonString == null) {
                return new SourceMapError("'sourceRoot' property is not of string type");
            }
            string = jsonString.getValue();
        } else {
            string = "";
        }
        String sourceRoot = string;
        JsonNode jsonNode5 = ((JsonObject)jsonObject).getProperties().get("sources");
        it422 = false;
        boolean it32 = false;
        JsonNode it22 = jsonNode5;
        boolean bl5 = false;
        if (it22 != null) {
            void $this$mapTo$iv$iv;
            JsonNode jsonNode6 = it22;
            if (!(jsonNode6 instanceof JsonArray)) {
                jsonNode6 = null;
            }
            JsonArray jsonArray = (JsonArray)jsonNode6;
            if (jsonArray == null) {
                return new SourceMapError("'sources' property is not of array type");
            }
            JsonArray sourcesProperty = jsonArray;
            Iterable $this$map$iv = sourcesProperty.getElements();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                JsonNode jsonNode7 = (JsonNode)item$iv$iv;
                object = destination$iv$iv;
                boolean bl6 = false;
                Object object2 = it;
                if (!(object2 instanceof JsonString)) {
                    object2 = null;
                }
                JsonString jsonString = (JsonString)object2;
                if (jsonString == null) {
                    return new SourceMapError("'sources' array must contain strings");
                }
                String string2 = jsonString.getValue();
                object.add(string2);
            }
            list3 = (List)destination$iv$iv;
        } else {
            list3 = CollectionsKt.emptyList();
        }
        List sources = list3;
        JsonNode it422 = ((JsonObject)jsonObject).getProperties().get("sourcesContent");
        it32 = false;
        boolean it22 = false;
        JsonNode it5 = it422;
        boolean $i$a$-let-SourceMapParser$parse$sourcesContent$22 = false;
        if (it5 != null) {
            void $this$mapTo$iv$iv;
            JsonNode jsonNode8 = it5;
            if (!(jsonNode8 instanceof JsonArray)) {
                jsonNode8 = null;
            }
            JsonArray jsonArray = (JsonArray)jsonNode8;
            if (jsonArray == null) {
                return new SourceMapError("'sourcesContent' property is not of array type");
            }
            JsonArray sourcesContentProperty = jsonArray;
            Iterable $this$map$iv = sourcesContentProperty.getElements();
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string3;
                void it6;
                object = (JsonNode)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl7 = false;
                void var22_59 = it6;
                if (var22_59 instanceof JsonNull) {
                    string3 = null;
                } else if (var22_59 instanceof JsonString) {
                    string3 = ((JsonString)it6).getValue();
                } else {
                    return new SourceMapError("'sources' array must contain strings");
                }
                String string4 = string3;
                collection.add(string4);
            }
            list2 = (List)destination$iv$iv2;
        } else {
            list2 = CollectionsKt.emptyList();
        }
        List sourcesContent = list2;
        Iterable $this$associate$iv = CollectionsKt.zip((Iterable)sources, (Iterable)sourcesContent);
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable $i$a$-let-SourceMapParser$parse$sourcesContent$22 = $this$associate$iv;
        Map destination$iv$iv3 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv3;
            Pair it7 = (Pair)element$iv$iv;
            boolean bl8 = false;
            Pair pair = it7;
            boolean bl9 = false;
            map2.put(pair.getFirst(), pair.getSecond());
        }
        Map sourcePathToContent = destination$iv$iv3;
        JsonNode jsonNode9 = ((JsonObject)jsonObject).getProperties().get("mappings");
        if (jsonNode9 == null) {
            return new SourceMapError("'mappings' property not found");
        }
        JsonNode mappings = jsonNode9;
        if (!(mappings instanceof JsonString)) {
            return new SourceMapError("'mappings' property is not of string type");
        }
        int jsColumn = 0;
        int sourceLine = 0;
        int sourceColumn = 0;
        int sourceIndex = 0;
        MappingStream stream = new MappingStream(((JsonString)mappings).getValue());
        SourceMap sourceMap2 = new SourceMap((Function1<? super String, ? extends Reader>)((Function1)new Function1<String, StringReader>(sourcePathToContent){
            final /* synthetic */ Map $sourcePathToContent;

            @Nullable
            public final StringReader invoke(@NotNull String it) {
                StringReader stringReader;
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                String string = (String)this.$sourcePathToContent.get(it);
                if (string != null) {
                    String string2 = string;
                    boolean bl = false;
                    boolean bl2 = false;
                    String it2 = string2;
                    boolean bl3 = false;
                    stringReader = new StringReader(it2);
                } else {
                    stringReader = null;
                }
                return stringReader;
            }
            {
                this.$sourcePathToContent = map2;
                super(1);
            }
        }));
        Object object3 = new SourceMapGroup();
        boolean bl10 = false;
        boolean bl11 = false;
        it = object3;
        boolean bl12 = false;
        Collection collection = sourceMap2.getGroups();
        boolean bl13 = false;
        collection.add(it);
        Object currentGroup = object3;
        while (!stream.isEof()) {
            SourceMapSegment sourceMapSegment;
            if (stream.isGroupTerminator()) {
                object3 = new SourceMapGroup();
                boolean bl14 = false;
                bl11 = false;
                it = object3;
                boolean bl15 = false;
                collection = sourceMap2.getGroups();
                bl13 = false;
                collection.add(it);
                currentGroup = object3;
                jsColumn = 0;
                stream.skipChar();
                continue;
            }
            Integer n = stream.readInt();
            if (n == null) {
                return stream.createError("VLQ-encoded JS column number expected");
            }
            jsColumn += n.intValue();
            if (stream.isEncodedInt()) {
                int n2;
                Integer n3 = stream.readInt();
                if (n3 == null) {
                    return stream.createError("VLQ-encoded source index expected");
                }
                sourceIndex += n3.intValue();
                Integer n4 = stream.readInt();
                if (n4 == null) {
                    return stream.createError("VLQ-encoded source line expected");
                }
                sourceLine += n4.intValue();
                Integer n5 = stream.readInt();
                if (n5 == null) {
                    return stream.createError("VLQ-encoded source column expected");
                }
                sourceColumn += n5.intValue();
                if (stream.isEncodedInt()) {
                    Integer n6 = stream.readInt();
                    if (n6 != null) {
                        n6.intValue();
                    } else {
                        return stream.createError("VLQ-encoded name index expected");
                    }
                }
                if (0 > (n2 = sourceIndex) || ((Collection)sources).size() <= n2) {
                    return stream.createError("Source index " + sourceIndex + " is out of bounds " + CollectionsKt.getIndices((Collection)sources));
                }
                object3 = ((SourceMapGroup)currentGroup).getSegments();
                sourceMapSegment = new SourceMapSegment(jsColumn, sourceRoot + (String)sources.get(sourceIndex), sourceLine, sourceColumn);
                bl11 = false;
                object3.add(sourceMapSegment);
            } else {
                object3 = ((SourceMapGroup)currentGroup).getSegments();
                sourceMapSegment = new SourceMapSegment(jsColumn, null, -1, -1);
                bl11 = false;
                object3.add(sourceMapSegment);
            }
            if (stream.isEof()) {
                return stream.createError("Unexpected EOF, ',' or ';' expected");
            }
            if (stream.isGroupTerminator()) {
                object3 = new SourceMapGroup();
                boolean bl16 = false;
                bl11 = false;
                it = object3;
                boolean bl17 = false;
                collection = sourceMap2.getGroups();
                bl13 = false;
                collection.add(it);
                currentGroup = object3;
                jsColumn = 0;
            } else if (!stream.isSegmentTerminator()) {
                return stream.createError("Unexpected char, ',' or ';' expected");
            }
            stream.skipChar();
        }
        return new SourceMapSuccess(sourceMap2);
    }

    private SourceMapParser() {
    }

    static {
        SourceMapParser sourceMapParser;
        INSTANCE = sourceMapParser = new SourceMapParser();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0017\u0010\u0013\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a2\u0006\u0002\u0010\u0016J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0003J\r\u0010\u001a\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\u001bJ\u0006\u0010\u001c\u001a\u00020\u001dR\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007R\u0011\u0010\b\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0007R\u0011\u0010\t\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0007R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/js/parser/sourcemaps/SourceMapParser$MappingStream;", "", "string", "", "(Ljava/lang/String;)V", "isEncodedInt", "", "()Z", "isEof", "isGroupTerminator", "isSegmentTerminator", "position", "", "getPosition", "()I", "setPosition", "(I)V", "getString", "()Ljava/lang/String;", "base64value", "c", "", "(C)Ljava/lang/Integer;", "createError", "Lorg/jetbrains/kotlin/js/parser/sourcemaps/SourceMapError;", "error", "readInt", "()Ljava/lang/Integer;", "skipChar", "", "js.parser"})
    public static final class MappingStream {
        private int position;
        @NotNull
        private final String string;

        public final int getPosition() {
            return this.position;
        }

        public final void setPosition(int n) {
            this.position = n;
        }

        public final boolean isEof() {
            return this.position == this.string.length();
        }

        public final boolean isSegmentTerminator() {
            return this.string.charAt(this.position) == ',';
        }

        public final boolean isGroupTerminator() {
            return this.string.charAt(this.position) == ';';
        }

        public final boolean isEncodedInt() {
            return !this.isEof() && !this.isSegmentTerminator() && !this.isGroupTerminator();
        }

        public final void skipChar() {
            int n = this.position;
            this.position = n + 1;
        }

        @Nullable
        public final Integer readInt() {
            int value = 0;
            int shift = 0;
            while (true) {
                if (this.isEof()) {
                    return null;
                }
                int n = this.position;
                this.position = n + 1;
                Integer n2 = this.base64value(this.string.charAt(n));
                if (n2 == null) {
                    return null;
                }
                int digit = n2;
                int digitValue = digit & 0x1F;
                value |= digitValue << shift;
                if ((digit & 0x20) == 0) break;
                shift += 5;
            }
            int unsignedValue = value >>> 1;
            return (value & 1) == 0 ? Integer.valueOf(unsignedValue) : Integer.valueOf(-unsignedValue);
        }

        private final Integer base64value(char c) {
            char c2 = c;
            char c3 = c2;
            return 'A' <= c3 && 'Z' >= c3 ? Integer.valueOf(c - 65) : ('a' <= (c3 = c2) && 'z' >= c3 ? Integer.valueOf(c - 97 + 26) : ('0' <= (c3 = c2) && '9' >= c3 ? Integer.valueOf(c - 48 + 52) : (c2 == '+' ? Integer.valueOf(62) : (c2 == '/' ? Integer.valueOf(63) : null))));
        }

        @NotNull
        public final SourceMapError createError(@NotNull String error) {
            Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
            return new SourceMapError("Error parsing stream at offset " + this.position + ": " + error);
        }

        @NotNull
        public final String getString() {
            return this.string;
        }

        public MappingStream(@NotNull String string) {
            Intrinsics.checkParameterIsNotNull((Object)string, (String)"string");
            this.string = string;
        }
    }
}

