/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal.msvcpp.version;

import java.io.File;
import java.util.List;
import org.gradle.api.specs.Spec;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.version.VisualCppInstallCandidate;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.version.VisualCppMetadataProvider;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.version.VisualStudioInstallCandidate;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.version.VisualStudioMetaDataProvider;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.version.VisualStudioMetadataBuilder;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.version.VisualStudioVersionLocator;

public class VisualStudioVersionDeterminer
implements VisualStudioMetaDataProvider {
    private final VisualStudioVersionLocator commandLineLocator;
    private final VisualStudioVersionLocator windowsRegistryLocator;
    private final VisualCppMetadataProvider visualCppMetadataProvider;

    public VisualStudioVersionDeterminer(VisualStudioVersionLocator commandLineLocator, VisualStudioVersionLocator windowsRegistryLocator, VisualCppMetadataProvider visualCppMetadataProvider) {
        this.commandLineLocator = commandLineLocator;
        this.windowsRegistryLocator = windowsRegistryLocator;
        this.visualCppMetadataProvider = visualCppMetadataProvider;
    }

    @Override
    public VisualStudioInstallCandidate getVisualStudioMetadataFromInstallDir(final File installDir) {
        VisualStudioInstallCandidate install = this.getVisualStudioMetadata(new Spec<VisualStudioInstallCandidate>(){

            public boolean isSatisfiedBy(VisualStudioInstallCandidate install) {
                return install.getInstallDir().equals(installDir);
            }
        });
        if (install == null) {
            VisualCppInstallCandidate visualCppMetadata = this.visualCppMetadataProvider.getVisualCppFromMetadataFile(installDir);
            if (visualCppMetadata != null) {
                return new VisualStudioMetadataBuilder().installDir(installDir).visualCppDir(visualCppMetadata.getVisualCppDir()).visualCppVersion(visualCppMetadata.getVersion()).compatibility(VisualStudioInstallCandidate.Compatibility.VS2017_OR_LATER).build();
            }
            File visualCppDir = new File(installDir, "VC");
            return new VisualStudioMetadataBuilder().installDir(installDir).visualCppDir(visualCppDir).compatibility(VisualStudioInstallCandidate.Compatibility.LEGACY).build();
        }
        return install;
    }

    @Override
    public VisualStudioInstallCandidate getVisualStudioMetadataFromCompiler(final File compilerFile) {
        VisualStudioInstallCandidate install = this.getVisualStudioMetadata(new Spec<VisualStudioInstallCandidate>(){

            public boolean isSatisfiedBy(VisualStudioInstallCandidate install) {
                if (install.getVersion().getMajor() >= 15) {
                    File compilerRoot = VisualStudioVersionDeterminer.getNthParent(compilerFile, 4);
                    return compilerRoot.equals(install.getVisualCppDir());
                }
                File compilerRoot = VisualStudioVersionDeterminer.getNthParent(compilerFile, 2);
                if (compilerRoot.equals(install.getVisualCppDir())) {
                    return true;
                }
                compilerRoot = VisualStudioVersionDeterminer.getNthParent(compilerFile, 3);
                return compilerRoot.equals(install.getVisualCppDir());
            }
        });
        if (install == null) {
            File installDir = VisualStudioVersionDeterminer.getNthParent(compilerFile, 8);
            VisualCppInstallCandidate visualCppMetadata = this.visualCppMetadataProvider.getVisualCppFromMetadataFile(installDir);
            if (visualCppMetadata != null) {
                File visualCppDir = visualCppMetadata.getVisualCppDir();
                return new VisualStudioMetadataBuilder().installDir(installDir).visualCppDir(visualCppDir).visualCppVersion(visualCppMetadata.getVersion()).compatibility(VisualStudioInstallCandidate.Compatibility.VS2017_OR_LATER).build();
            }
            File visualCppDir = VisualStudioVersionDeterminer.getNthParent(compilerFile, 2);
            if (!"VC".equals(visualCppDir.getName())) {
                visualCppDir = VisualStudioVersionDeterminer.getNthParent(compilerFile, 3);
            }
            return new VisualStudioMetadataBuilder().installDir(visualCppDir.getParentFile()).visualCppDir(visualCppDir).compatibility(VisualStudioInstallCandidate.Compatibility.LEGACY).build();
        }
        return install;
    }

    private VisualStudioInstallCandidate getVisualStudioMetadata(Spec<VisualStudioInstallCandidate> spec) {
        List<VisualStudioInstallCandidate> installs = this.commandLineLocator.getVisualStudioInstalls();
        if (installs.size() > 0) {
            VisualStudioInstallCandidate install = this.findMetadataForInstallDir(spec, installs);
            if (install != null) {
                return install;
            }
        } else {
            installs = this.windowsRegistryLocator.getVisualStudioInstalls();
            VisualStudioInstallCandidate install = this.findMetadataForInstallDir(spec, installs);
            if (install != null) {
                return install;
            }
        }
        return null;
    }

    private VisualStudioInstallCandidate findMetadataForInstallDir(Spec<VisualStudioInstallCandidate> spec, List<VisualStudioInstallCandidate> installs) {
        for (VisualStudioInstallCandidate install : installs) {
            if (!spec.isSatisfiedBy((Object)install)) continue;
            return install;
        }
        return null;
    }

    private static File getNthParent(File file, int n) {
        if (n == 0) {
            return file;
        }
        File parent = file.getParentFile();
        if (parent != null) {
            return VisualStudioVersionDeterminer.getNthParent(parent, --n);
        }
        return file;
    }
}

