/*
 * Decompiled with CFR 0.152.
 */
package net.orfjackal.retrolambda.lambdas;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import net.orfjackal.retrolambda.Agent;
import net.orfjackal.retrolambda.asm.ClassReader;
import net.orfjackal.retrolambda.asm.ClassVisitor;
import net.orfjackal.retrolambda.asm.ClassWriter;
import net.orfjackal.retrolambda.asm.MethodVisitor;
import net.orfjackal.retrolambda.asm.Type;
import net.orfjackal.retrolambda.minlog.Log;

public class InnerClassLambdaMetafactoryTransformer
implements ClassFileTransformer {
    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] bytes) throws IllegalClassFormatException {
        if (!"java/lang/invoke/InnerClassLambdaMetafactory".equals(className)) {
            return null;
        }
        try {
            byte[] transformed = this.transformMetafactory(bytes);
            Agent.enable();
            return transformed;
        }
        catch (Throwable e) {
            Log.error("Failed to transform " + className + ", cannot enable the Java agent. " + "Please report an issue to Retrolambda with full logs. " + "Probably you're running on an unsupported Java version.", e);
            return null;
        }
    }

    private byte[] transformMetafactory(byte[] bytes) {
        final boolean[] spinInnerClassFound = new boolean[]{false};
        final boolean[] toByteArrayFound = new boolean[]{false};
        ClassReader cr = new ClassReader(bytes);
        ClassWriter cw = new ClassWriter(cr, 0);
        ClassVisitor cv = new ClassVisitor(458752, cw){

            @Override
            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
                if (name.equals("spinInnerClass")) {
                    spinInnerClassFound[0] = true;
                    mv = new MethodVisitor(458752, mv){

                        @Override
                        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                            super.visitMethodInsn(opcode, owner, name, desc, itf);
                            if (name.equals("toByteArray")) {
                                if (toByteArrayFound[0]) {
                                    throw new RuntimeException("Found multiple toByteArray calls");
                                }
                                toByteArrayFound[0] = true;
                                this.mv.visitInsn(89);
                                this.mv.visitMethodInsn(184, Type.getInternalName(Agent.class), "saveLambda", "([B)V", false);
                            }
                        }

                        @Override
                        public void visitMaxs(int maxStack, int maxLocals) {
                            super.visitMaxs(maxStack + 1, maxLocals);
                        }
                    };
                }
                return mv;
            }
        };
        cr.accept(cv, 0);
        if (!spinInnerClassFound[0]) {
            throw new RuntimeException("Could not find the spinInnerClass method");
        }
        if (!toByteArrayFound[0]) {
            throw new RuntimeException("Could not find the toByteArray call");
        }
        return cw.toByteArray();
    }
}

