/*
 * Decompiled with CFR 0.152.
 */
package net.orfjackal.retrolambda.files;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class FilteringFileVisitor
implements FileVisitor<Path> {
    private final Set<Path> fileFilter;
    private final FileVisitor<? super Path> target;

    public FilteringFileVisitor(Collection<Path> fileFilter, FileVisitor<Path> target) {
        this.fileFilter = new HashSet<Path>(fileFilter);
        this.target = target;
    }

    @Override
    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
        return this.target.postVisitDirectory(dir, exc);
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        return this.target.preVisitDirectory(dir, attrs);
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        if (this.fileFilter.contains(file)) {
            return this.target.visitFile(file, attrs);
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
        return this.target.visitFileFailed(file, exc);
    }
}

