/*
 * Decompiled with CFR 0.152.
 */
package net.orfjackal.retrolambda;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.orfjackal.retrolambda.Config;

public class SystemPropertiesConfig
implements Config {
    private static final List<String> requiredProperties = new ArrayList<String>();
    private static final Map<String, String> alternativeProperties = new HashMap<String, String>();
    private static final List<String> propertiesHelp = new ArrayList<String>();
    private final Properties p;

    public SystemPropertiesConfig(Properties p) {
        this.p = p;
    }

    public boolean isFullyConfigured() {
        return this.hasAllRequiredProperties();
    }

    private boolean hasAllRequiredProperties() {
        for (String requiredParameter : requiredProperties) {
            if (this.isConfigured(requiredParameter)) continue;
            return false;
        }
        return true;
    }

    private boolean isConfigured(String parameter) {
        if (this.p.getProperty(parameter) != null) {
            return true;
        }
        for (Map.Entry<String, String> alt : alternativeProperties.entrySet()) {
            if (!alt.getValue().equals(parameter) || this.p.getProperty(alt.getKey()) == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getBytecodeVersion() {
        return Integer.parseInt(this.p.getProperty("retrolambda.bytecodeVersion", "51"));
    }

    @Override
    public boolean isDefaultMethodsEnabled() {
        return Boolean.parseBoolean(this.p.getProperty("retrolambda.defaultMethods", "false"));
    }

    @Override
    public Path getInputDir() {
        String inputDir = this.p.getProperty("retrolambda.inputDir");
        if (inputDir != null) {
            return Paths.get(inputDir, new String[0]);
        }
        throw new IllegalArgumentException("Missing required property: retrolambda.inputDir");
    }

    @Override
    public Path getOutputDir() {
        String outputDir = this.p.getProperty("retrolambda.outputDir");
        if (outputDir != null) {
            return Paths.get(outputDir, new String[0]);
        }
        return this.getInputDir();
    }

    @Override
    public List<Path> getClasspath() {
        String classpath = this.p.getProperty("retrolambda.classpath");
        if (classpath != null) {
            return SystemPropertiesConfig.parsePathList(classpath);
        }
        String classpathFile = this.p.getProperty("retrolambda.classpathFile");
        if (classpathFile != null) {
            return SystemPropertiesConfig.readPathList(Paths.get(classpathFile, new String[0]));
        }
        throw new IllegalArgumentException("Missing required property: retrolambda.classpath");
    }

    private static List<Path> parsePathList(String paths) {
        return Stream.of(paths.split(File.pathSeparator)).filter(path -> !path.isEmpty()).map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList());
    }

    private static List<Path> readPathList(Path file) {
        try {
            return Files.readAllLines(file).stream().filter(line -> !line.isEmpty()).map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read " + file, e);
        }
    }

    @Override
    public List<Path> getIncludedFiles() {
        String files = this.p.getProperty("retrolambda.includedFiles");
        if (files != null) {
            return SystemPropertiesConfig.parsePathList(files);
        }
        String filesFile = this.p.getProperty("retrolambda.includedFilesFile");
        if (filesFile != null) {
            return SystemPropertiesConfig.readPathList(Paths.get(filesFile, new String[0]));
        }
        return null;
    }

    @Override
    public boolean isJavacHacksEnabled() {
        return Boolean.parseBoolean(this.p.getProperty("retrolambda.javacHacks", "false"));
    }

    @Override
    public boolean isQuiet() {
        return Boolean.parseBoolean(this.p.getProperty("retrolambda.quiet", "false"));
    }

    public String getHelp() {
        String options = requiredProperties.stream().map(key -> "-D" + key + "=?").reduce((a, b) -> a + " " + b).get();
        return "Usage: java " + options + " [-javaagent:retrolambda.jar] -jar retrolambda.jar\n" + "\n" + "Retrolambda takes Java 8 classes and backports lambda expressions and\n" + "some other language features to work on Java 7, 6 or 5.\n" + "Web site: https://github.com/luontola/retrolambda\n" + "\n" + "Copyright (c) 2013-2017  Esko Luontola and other Retrolambda contributors\n" + "This software is released under the Apache License 2.0.\n" + "The license text is at http://www.apache.org/licenses/LICENSE-2.0\n" + "\n" + "Configurable system properties:\n" + "\n" + (String)propertiesHelp.stream().reduce((a, b) -> a + "\n" + b).get() + "\n" + "If the Java agent is used, then Retrolambda will use it to capture the\n" + "lambda classes generated by Java. Otherwise Retrolambda will hook into\n" + "Java's internal lambda dumping API, which is more susceptible to suddenly\n" + "stopping to work between Java releases.\n";
    }

    private static void requiredParameterHelp(String key, String ... lines) {
        requiredProperties.add(key);
        propertiesHelp.add(SystemPropertiesConfig.formatPropertyHelp(key, "required", lines));
    }

    private static void alternativeParameterHelp(String key, String replaces, String ... lines) {
        alternativeProperties.put(key, replaces);
        propertiesHelp.add(SystemPropertiesConfig.formatPropertyHelp(key, "alternative", lines));
    }

    private static void optionalParameterHelp(String key, String ... lines) {
        propertiesHelp.add(SystemPropertiesConfig.formatPropertyHelp(key, "", lines));
    }

    private static String formatPropertyHelp(String key, String tag, String ... lines) {
        tag = tag.isEmpty() ? "" : " (" + tag + ")";
        String help = "  " + key + tag + "\n";
        for (String line : lines) {
            help = help + "      " + line + "\n";
        }
        return help;
    }

    static {
        SystemPropertiesConfig.optionalParameterHelp("retrolambda.bytecodeVersion", "Major version number for the generated bytecode. For a list, see", "offset 7 at http://en.wikipedia.org/wiki/Java_class_file#General_layout", "Default value is 51 (i.e. Java 7)");
        SystemPropertiesConfig.optionalParameterHelp("retrolambda.defaultMethods", "Whether to backport default methods and static methods on interfaces.", "LIMITATIONS: All backported interfaces and all classes which implement", "them or call their static methods must be backported together,", "with one execution of Retrolambda.", "Disabled by default. Enable by setting to \"true\"");
        SystemPropertiesConfig.requiredParameterHelp("retrolambda.inputDir", "Input directory from where the original class files are read.");
        SystemPropertiesConfig.optionalParameterHelp("retrolambda.outputDir", "Output directory into where the generated class files are written.", "Defaults to same as retrolambda.inputDir");
        SystemPropertiesConfig.requiredParameterHelp("retrolambda.classpath", "Classpath containing the original class files and their dependencies.", "Uses ; or : as the path separator, see java.io.File#pathSeparatorChar");
        SystemPropertiesConfig.alternativeParameterHelp("retrolambda.classpathFile", "retrolambda.classpath", "File listing the classpath entries.", "Alternative to retrolambda.classpath for avoiding the command line", "length limit. The file must list one file per line with UTF-8 encoding.");
        SystemPropertiesConfig.optionalParameterHelp("retrolambda.includedFiles", "List of files to process, instead of processing all files.", "This is useful for a build tool to support incremental compilation.", "Uses ; or : as the path separator, see java.io.File#pathSeparatorChar");
        SystemPropertiesConfig.alternativeParameterHelp("retrolambda.includedFilesFile", "retrolambda.includedFiles", "File listing the files to process, instead of processing all files.", "Alternative to retrolambda.includedFiles for avoiding the command line", "length limit. The file must list one file per line with UTF-8 encoding.");
        SystemPropertiesConfig.optionalParameterHelp("retrolambda.javacHacks", "Attempts to fix javac bugs (type-annotation emission for local variables).", "Disabled by default. Enable by setting to \"true\"");
        SystemPropertiesConfig.optionalParameterHelp("retrolambda.quiet", "Reduces the amount of logging.", "Disabled by default. Enable by setting to \"true\"");
    }
}

