/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.DragSourceEffect;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;

public class TableDragSourceEffect
extends DragSourceEffect {
    Image dragSourceImage = null;

    public TableDragSourceEffect(Table table) {
        super(table);
    }

    @Override
    public void dragFinished(DragSourceEvent dragSourceEvent) {
        if (this.dragSourceImage != null) {
            this.dragSourceImage.dispose();
        }
        this.dragSourceImage = null;
    }

    @Override
    public void dragStart(DragSourceEvent dragSourceEvent) {
        dragSourceEvent.image = this.getDragSourceImage(dragSourceEvent);
    }

    Image getDragSourceImage(DragSourceEvent dragSourceEvent) {
        int[] nArray;
        if (this.dragSourceImage != null) {
            this.dragSourceImage.dispose();
        }
        this.dragSourceImage = null;
        Table table = (Table)this.control;
        if (OS.GTK_VERSION < OS.VERSION(2, 2, 0)) {
            return null;
        }
        if (table.isListening(40) || table.isListening(42)) {
            return null;
        }
        int n = table.handle;
        int n2 = OS.gtk_tree_view_get_selection(n);
        int n3 = OS.gtk_tree_selection_get_selected_rows(n2, nArray = OS.GTK_VERSION < OS.VERSION(2, 2, 4) ? new int[1] : null);
        if (n3 == 0) {
            return null;
        }
        int n4 = Math.min(10, OS.g_list_length(n3));
        Display display = table.getDisplay();
        if (n4 == 1) {
            int n5 = OS.g_list_nth_data(n3, 0);
            int n6 = OS.gtk_tree_view_create_row_drag_icon(n, n5);
            this.dragSourceImage = Image.gtk_new(display, 1, n6, 0);
            OS.gtk_tree_path_free(n5);
        } else {
            int n7;
            int n8;
            int n9 = 0;
            int n10 = 0;
            int[] nArray2 = new int[1];
            int[] nArray3 = new int[1];
            int[] nArray4 = new int[n4];
            int[] nArray5 = new int[n4];
            int[] nArray6 = new int[n4];
            GdkRectangle gdkRectangle = new GdkRectangle();
            for (n8 = 0; n8 < n4; ++n8) {
                n7 = OS.g_list_nth_data(n3, n8);
                OS.gtk_tree_view_get_cell_area(n, n7, 0, gdkRectangle);
                nArray6[n8] = OS.gtk_tree_view_create_row_drag_icon(n, n7);
                OS.gdk_drawable_get_size(nArray6[n8], nArray2, nArray3);
                n9 = Math.max(n9, nArray2[0]);
                n10 = gdkRectangle.y + nArray3[0] - nArray4[0];
                nArray4[n8] = gdkRectangle.y;
                nArray5[n8] = nArray3[0];
                OS.gtk_tree_path_free(n7);
            }
            n8 = OS.gdk_pixmap_new(OS.gdk_get_default_root_window(), n9, n10, -1);
            n7 = OS.gdk_gc_new(n8);
            int n11 = OS.gdk_pixmap_new(OS.gdk_get_default_root_window(), n9, n10, 1);
            int n12 = OS.gdk_gc_new(n11);
            GdkColor gdkColor = new GdkColor();
            gdkColor.pixel = 0;
            OS.gdk_gc_set_foreground(n12, gdkColor);
            OS.gdk_draw_rectangle(n11, n12, 1, 0, 0, n9, n10);
            gdkColor.pixel = 1;
            OS.gdk_gc_set_foreground(n12, gdkColor);
            for (int i = 0; i < n4; ++i) {
                OS.gdk_draw_drawable(n8, n7, nArray6[i], 0, 0, 0, nArray4[i] - nArray4[0], -1, -1);
                OS.gdk_draw_rectangle(n11, n12, 1, 0, nArray4[i] - nArray4[0], n9, nArray5[i]);
                OS.g_object_unref(nArray6[i]);
            }
            OS.g_object_unref(n7);
            OS.g_object_unref(n12);
            this.dragSourceImage = Image.gtk_new(display, 1, n8, n11);
        }
        OS.g_list_free(n3);
        return this.dragSourceImage;
    }
}

